/*
 * Decompiled with CFR 0.152.
 */
package com.bram91.fishingnotifier;

import com.bram91.fishingnotifier.FishingNotifierConfig;
import com.google.inject.Provides;
import javax.inject.Inject;
import net.runelite.api.Actor;
import net.runelite.api.Client;
import net.runelite.api.NPC;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.GameTick;
import net.runelite.client.Notifier;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.game.FishingSpot;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Fishing Notifier", description="Notifies when idling while fishing.")
public class FishingNotifierPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(FishingNotifierPlugin.class);
    @Inject
    private Client client;
    @Inject
    private Notifier notifier;
    @Inject
    private FishingNotifierConfig config;
    FishingSpot previousTick;
    FishingSpot currentTick;

    @Provides
    FishingNotifierConfig provideConfig(ConfigManager configManager) {
        return (FishingNotifierConfig)configManager.getConfig(FishingNotifierConfig.class);
    }

    public boolean checkNotify() {
        Actor actor = this.client.getLocalPlayer().getInteracting();
        if (actor != null) {
            FishingSpot spot;
            if (actor instanceof NPC && (spot = FishingSpot.findSpot((int)((NPC)actor).getId())) != null) {
                this.previousTick = this.currentTick;
                this.currentTick = spot;
            }
        } else {
            this.previousTick = this.currentTick;
            this.currentTick = null;
            if (this.previousTick != null) {
                return true;
            }
        }
        return false;
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged event) {
        switch (event.getGameState()) {
            case LOADING: 
            case LOGIN_SCREEN: 
            case HOPPING: {
                this.previousTick = null;
                this.currentTick = null;
            }
        }
    }

    @Subscribe
    public void onGameTick(GameTick event) {
        boolean notify = this.checkNotify();
        if (!notify) {
            return;
        }
        boolean shouldNotify = false;
        if (this.config.eelFishing() && (FishingSpot.SACRED_EEL.getName().equals(this.previousTick.getName()) || FishingSpot.INFERNAL_EEL.getName().equals(this.previousTick.getName()))) {
            shouldNotify = true;
        } else if (this.config.barbFishing() && FishingSpot.BARB_FISH.getName().equals(this.previousTick.getName())) {
            shouldNotify = true;
        } else if (this.config.anglerFishing() && FishingSpot.ANGLERFISH.getName().equals(this.previousTick.getName())) {
            shouldNotify = true;
        } else if (this.config.karambwanFishing() && FishingSpot.KARAMBWAN.getName().equals(this.previousTick.getName())) {
            shouldNotify = true;
        } else if (this.config.monkFishing() && FishingSpot.MONKFISH.getName().equals(this.previousTick.getName())) {
            shouldNotify = true;
        } else if (this.config.harpoonFish() && FishingSpot.HARPOONFISH.getName().equals(this.previousTick.getName())) {
            shouldNotify = true;
        } else if (this.config.otherFishing() && (FishingSpot.LOBSTER.getName().equals(this.previousTick.getName()) || FishingSpot.DARK_CRAB.getName().equals(this.previousTick.getName()) || FishingSpot.SHRIMP.getName().equals(this.previousTick.getName()) || FishingSpot.SHARK.getName().equals(this.previousTick.getName()) || FishingSpot.MINNOW.getName().equals(this.previousTick.getName()) || FishingSpot.KARAMBWANJI.getName().equals(this.previousTick.getName()) || FishingSpot.SALMON.getName().equals(this.previousTick.getName()))) {
            shouldNotify = true;
        }
        if (shouldNotify) {
            this.notifier.notify("[" + this.client.getLocalPlayer().getName() + "] is slacking!");
        }
    }
}

