/*
 * Decompiled with CFR 0.152.
 */
package com.jebscape.core;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import net.runelite.client.ui.overlay.components.LayoutableRenderableEntity;
import net.runelite.client.ui.overlay.components.TextComponent;
import net.runelite.client.util.Text;

public class RuneLiteTableComponent
implements LayoutableRenderableEntity {
    private final Rectangle bounds = new Rectangle();
    private ArrayList<String[]> cells = new ArrayList();
    private TableAlignment[] columnAlignments;
    private Color[] columnColors;
    private int numCols;
    private int numRows;
    private TableAlignment defaultAlignment = TableAlignment.LEFT;
    private Color defaultColor = Color.WHITE;
    private Dimension gutter = new Dimension(3, 0);
    private Point preferredLocation = new Point();
    private Dimension preferredSize = new Dimension(129, 0);

    public Dimension render(Graphics2D graphics) {
        FontMetrics metrics = graphics.getFontMetrics();
        int[] columnWidths = this.getColumnWidths(metrics);
        int height = 0;
        graphics.translate(this.preferredLocation.x, this.preferredLocation.y);
        for (int row = 0; row < this.numRows; ++row) {
            int x = 0;
            int startingRowHeight = height;
            for (int col = 0; col < this.numCols; ++col) {
                String[] lines;
                int y = startingRowHeight;
                for (String line : lines = RuneLiteTableComponent.lineBreakText(this.getCellText(col, row), columnWidths[col], metrics)) {
                    int alignmentOffset = RuneLiteTableComponent.getAlignedPosition(line, this.getColumnAlignment(col), columnWidths[col], metrics);
                    TextComponent leftLineComponent = new TextComponent();
                    leftLineComponent.setPosition(new Point(x + alignmentOffset, y += metrics.getHeight()));
                    leftLineComponent.setText(line);
                    leftLineComponent.setColor(this.getColumnColor(col));
                    leftLineComponent.render(graphics);
                }
                height = Math.max(height, y);
                x += columnWidths[col] + this.gutter.width;
            }
            height += this.gutter.height;
        }
        graphics.translate(-this.preferredLocation.x, -this.preferredLocation.y);
        Dimension dimension = new Dimension(this.preferredSize.width, height);
        this.bounds.setLocation(this.preferredLocation);
        this.bounds.setSize(dimension);
        return dimension;
    }

    public void setPreferredLocation(@Nonnull Point location) {
        this.preferredLocation = location;
    }

    public void setPreferredSize(@Nonnull Dimension size) {
        this.preferredSize = size;
    }

    public void setDefaultColor(@Nonnull Color color) {
        this.defaultColor = color;
    }

    public void setDefaultAlignment(@Nonnull TableAlignment alignment) {
        this.defaultAlignment = alignment;
    }

    public void setGutter(@Nonnull Dimension gutter) {
        this.gutter = gutter;
    }

    public void setColumnColors(Color ... colors) {
        this.columnColors = colors;
    }

    public void setColumnAlignments(TableAlignment ... alignments) {
        this.columnAlignments = alignments;
    }

    public void setColumnColor(int col, Color color) {
        assert (this.columnColors.length > col);
        this.columnColors[col] = color;
    }

    public void setColumnAlignment(int col, TableAlignment alignment) {
        assert (this.columnAlignments.length > col);
        this.columnAlignments[col] = alignment;
    }

    public void addRow(String ... cells) {
        this.numCols = Math.max(this.numCols, cells.length);
        ++this.numRows;
        this.cells.add(cells);
    }

    public void addRows(String[] ... rows) {
        for (String[] row : rows) {
            this.addRow(row);
        }
    }

    private Color getColumnColor(int column) {
        if (this.columnColors == null || this.columnColors.length <= column || this.columnColors[column] == null) {
            return this.defaultColor;
        }
        return this.columnColors[column];
    }

    private TableAlignment getColumnAlignment(int column) {
        if (this.columnAlignments == null || this.columnAlignments.length <= column || this.columnAlignments[column] == null) {
            return this.defaultAlignment;
        }
        return this.columnAlignments[column];
    }

    private String getCellText(int col, int row) {
        assert (col < this.numCols && row < this.numRows);
        if (this.cells.get(row).length < col) {
            return "";
        }
        return this.cells.get(row)[col];
    }

    private int[] getColumnWidths(FontMetrics metrics) {
        int col;
        int col2;
        int[] maxtextw = new int[this.numCols];
        int[] maxwordw = new int[this.numCols];
        boolean[] flex = new boolean[this.numCols];
        boolean[] wrap = new boolean[this.numCols];
        int[] finalcolw = new int[this.numCols];
        for (int col3 = 0; col3 < this.numCols; ++col3) {
            for (int row = 0; row < this.numRows; ++row) {
                String cell = this.getCellText(col3, row);
                int cellWidth = RuneLiteTableComponent.getTextWidth(metrics, cell);
                maxtextw[col3] = Math.max(maxtextw[col3], cellWidth);
                for (String word : cell.split(" ")) {
                    maxwordw[col3] = Math.max(maxwordw[col3], RuneLiteTableComponent.getTextWidth(metrics, word));
                }
                if (maxtextw[col3] != cellWidth) continue;
                wrap[col3] = cell.contains(" ");
            }
        }
        int left = this.preferredSize.width - (this.numCols - 1) * this.gutter.width;
        double avg = (double)left / (double)this.numCols;
        int nflex = 0;
        for (col2 = 0; col2 < this.numCols; ++col2) {
            double maxNonFlexLimit = 1.5 * avg;
            boolean bl = flex[col2] = (double)maxtextw[col2] > maxNonFlexLimit;
            if (flex[col2]) {
                ++nflex;
                continue;
            }
            finalcolw[col2] = maxtextw[col2];
            left -= finalcolw[col2];
        }
        if ((double)left < (double)nflex * avg) {
            for (col2 = 0; col2 < this.numCols; ++col2) {
                if (flex[col2] || !wrap[col2]) continue;
                left += finalcolw[col2];
                finalcolw[col2] = 0;
                flex[col2] = true;
                ++nflex;
            }
        }
        int tot = 0;
        for (col = 0; col < this.numCols; ++col) {
            if (!flex[col]) continue;
            maxtextw[col] = Math.min(maxtextw[col], this.preferredSize.width);
            tot += maxtextw[col];
        }
        for (col = 0; col < this.numCols; ++col) {
            if (!flex[col]) continue;
            finalcolw[col] = left * maxtextw[col] / tot;
            finalcolw[col] = Math.max(finalcolw[col], maxwordw[col]);
            left -= finalcolw[col];
        }
        int extraPerCol = left / this.numCols;
        int col4 = 0;
        while (col4 < this.numCols) {
            int n = col4++;
            finalcolw[n] = finalcolw[n] + extraPerCol;
            left -= extraPerCol;
        }
        int n = finalcolw.length - 1;
        finalcolw[n] = finalcolw[n] + left;
        return finalcolw;
    }

    private static int getTextWidth(FontMetrics metrics, String cell) {
        return metrics.stringWidth(Text.removeTags((String)cell));
    }

    private static String[] lineBreakText(String text, int maxWidth, FontMetrics metrics) {
        String[] words = text.split(" ");
        if (words.length == 0) {
            return new String[0];
        }
        StringBuilder wrapped = new StringBuilder(words[0]);
        int spaceLeft = maxWidth - RuneLiteTableComponent.getTextWidth(metrics, wrapped.toString());
        for (int i = 1; i < words.length; ++i) {
            int spaceWidth;
            String word = words[i];
            int wordLen = RuneLiteTableComponent.getTextWidth(metrics, word);
            if (wordLen + (spaceWidth = metrics.stringWidth(" ")) > spaceLeft) {
                wrapped.append('\n').append(word);
                spaceLeft = maxWidth - wordLen;
                continue;
            }
            wrapped.append(' ').append(word);
            spaceLeft -= spaceWidth + wordLen;
        }
        return wrapped.toString().split("\n");
    }

    private static int getAlignedPosition(String str, TableAlignment alignment, int columnWidth, FontMetrics metrics) {
        int stringWidth = RuneLiteTableComponent.getTextWidth(metrics, str);
        int offset = 0;
        switch (alignment) {
            case LEFT: {
                break;
            }
            case CENTER: {
                offset = columnWidth / 2 - stringWidth / 2;
                break;
            }
            case RIGHT: {
                offset = columnWidth - stringWidth;
            }
        }
        return offset;
    }

    public Rectangle getBounds() {
        return this.bounds;
    }

    public static enum TableAlignment {
        LEFT,
        CENTER,
        RIGHT;

    }
}

