/*
 * Decompiled with CFR 0.152.
 */
package com.jebscape.core;

import com.jebscape.core.JebScapeActor;
import com.jebscape.core.JebScapeActorIndicatorOverlay;
import com.jebscape.core.JebScapeConnection;
import com.jebscape.core.JebScapeLiveHiscoresOverlay;
import com.jebscape.core.JebScapeMinimapOverlay;
import com.jebscape.core.JebScapeServerData;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collection;
import net.runelite.api.Actor;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.Model;
import net.runelite.api.ModelData;
import net.runelite.api.Player;
import net.runelite.api.Skill;
import net.runelite.api.WorldType;
import net.runelite.api.coords.LocalPoint;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.events.AnimationChanged;
import net.runelite.api.events.ChatMessage;
import net.runelite.api.events.ClientTick;
import net.runelite.api.events.FakeXpDrop;
import net.runelite.client.util.Text;

public class MegaserverMod {
    public final int MEGASERVER_MOVEMENT_UPDATE_CMD = 1;
    public final int LIVE_HISCORES_STATS_UPDATE_CMD = 2;
    private final int MAX_GHOSTS = 64;
    private static final int NUM_SKILLS = 24;
    private int[] post200mXpAccumulator = new int[24];
    private Skill skillTypeToTrack = Skill.AGILITY;
    private int startRankToTrack = 1;
    private static final int NUM_RANKS = 5;
    private String[] liveHiscoresPlayerNames = new String[5];
    private int[] liveHiscoresLevels = new int[5];
    private int[] liveHiscoresXPs = new int[5];
    private boolean[] liveHiscoresOnlineStatuses = new boolean[5];
    private boolean isActive = false;
    private Client client;
    private JebScapeConnection server;
    private JebScapeLiveHiscoresOverlay liveHiscoresOverlay;
    private int[] clientData = new int[3];
    private Model ghostModel;
    private JebScapeActor[] ghosts = new JebScapeActor[64];
    private byte[] nameBytes = new byte[12];
    private byte[] chatBytes = new byte[80];
    private String chatMessageToSend = "";

    public void init(Client client, JebScapeConnection server, JebScapeActorIndicatorOverlay indicatorOverlay, JebScapeMinimapOverlay minimapOverlay, JebScapeLiveHiscoresOverlay liveHiscoresOverlay) {
        this.client = client;
        this.server = server;
        for (int i = 0; i < 64; ++i) {
            this.ghosts[i] = new JebScapeActor();
            this.ghosts[i].init(client);
        }
        indicatorOverlay.setJebScapeActors(this.ghosts);
        minimapOverlay.setJebScapeActors(this.ghosts);
        this.liveHiscoresOverlay = liveHiscoresOverlay;
        liveHiscoresOverlay.setContainsData(false);
    }

    public void start() {
        if (this.isActive) {
            this.stop();
        }
        if (!this.server.isChatLoggedIn()) {
            this.liveHiscoresOverlay.setContainsData(false);
            this.resetPost200mXpAccumulators();
        }
        this.isActive = true;
        this.loadGhostRenderables();
    }

    public void stop() {
        if (!this.isActive) {
            return;
        }
        this.isActive = false;
        this.chatMessageToSend = "";
        if (!this.server.isChatLoggedIn()) {
            this.liveHiscoresOverlay.setContainsData(false);
            this.resetPost200mXpAccumulators();
        }
        for (int i = 0; i < 64; ++i) {
            this.ghosts[i].despawn();
        }
    }

    public boolean isActive() {
        return this.isActive;
    }

    public void onChatMessage(ChatMessage chatMessage) {
        if (chatMessage.getName() != null && (chatMessage.getType() == ChatMessageType.PUBLICCHAT || chatMessage.getType() == ChatMessageType.MODCHAT)) {
            String senderName = Text.sanitize((String)chatMessage.getName());
            String playerName = Text.sanitize((String)this.client.getLocalPlayer().getName());
            if (chatMessage.getName() != null && senderName.contentEquals(playerName)) {
                this.chatMessageToSend = chatMessage.getMessage();
            }
        }
    }

    public void onAnimationChanged(AnimationChanged animationChanged) {
    }

    public void onFakeXpDrop(FakeXpDrop fakeXpDrop) {
        Skill skill = fakeXpDrop.getSkill();
        int n = skill.ordinal();
        this.post200mXpAccumulator[n] = this.post200mXpAccumulator[n] + fakeXpDrop.getXp();
    }

    public void resetPost200mXpAccumulators() {
        Arrays.fill(this.post200mXpAccumulator, 0);
    }

    public void setLiveHiscoresSkillType(Skill skillType) {
        this.skillTypeToTrack = skillType;
    }

    public void setLiveHiscoresStartRank(int startRank) {
        this.startRankToTrack = startRank;
    }

    public int onGameTick() {
        this.liveHiscoresOverlay.onGameTick();
        JebScapeServerData[][] gameServerData = this.server.getRecentGameServerData();
        JebScapeServerData[][] chatServerData = this.server.getRecentChatServerData();
        int[] numGamePacketsSent = this.server.getNumGameServerPacketsSent();
        int[] numChatPacketsSent = this.server.getNumChatServerPacketsSent();
        int lastReceivedGameTick = this.server.getLastReceivedGameTick();
        int lastReceivedChatTick = this.server.getLastReceivedChatTick();
        int JAU_PACKING_RATIO = 32;
        int i = 0;
        while (true) {
            int chatTick;
            if (i >= 16) break;
            int gameTick = (lastReceivedGameTick + i) % 16;
            if (numGamePacketsSent[gameTick] > 0) {
                int packetID = 0;
                while (true) {
                    if (packetID >= 16) break;
                    JebScapeServerData data = gameServerData[gameTick][packetID];
                    boolean emptyPacket = data.isEmpty();
                    boolean containsMegaserverCmd = false;
                    int playerWorldFlags = 0;
                    int playerWorld = 0;
                    int playerWorldLocationX = 0;
                    int playerWorldLocationY = 0;
                    int playerWorldLocationPlane = 0;
                    int playerAnimationState = 0;
                    boolean isInstanced = false;
                    if (!emptyPacket) {
                        containsMegaserverCmd = (data.coreData[0] & 0xFF & 1) != 0;
                        playerWorldFlags = data.coreData[0] >>> 8 & 0xFF;
                        playerWorld = data.coreData[0] >>> 16 & 0x3FFF;
                        playerWorldLocationPlane = data.coreData[0] >>> 30 & 3;
                        playerWorldLocationX = data.coreData[1] & 0xFFFF;
                        playerWorldLocationY = data.coreData[1] >>> 16 & 0xFFFF;
                        playerAnimationState = data.coreData[2];
                        boolean bl = isInstanced = (playerWorldFlags >>> 1 & 1) == 1;
                        if (this.client.isInInstancedRegion() && isInstanced) {
                            WorldPoint currentPlayerWorldPosition = this.client.getLocalPlayer().getWorldLocation();
                            WorldPoint currentPlayerInstancePosition = WorldPoint.fromLocalInstance((Client)this.client, (LocalPoint)LocalPoint.fromWorld((Client)this.client, (WorldPoint)currentPlayerWorldPosition));
                            int dx = playerWorldLocationX - currentPlayerInstancePosition.getX();
                            int dy = playerWorldLocationY - currentPlayerInstancePosition.getY();
                            playerWorldLocationX = currentPlayerWorldPosition.getX() + dx;
                            playerWorldLocationY = currentPlayerWorldPosition.getY() + dy;
                            playerWorldLocationPlane = currentPlayerWorldPosition.getPlane();
                        }
                    }
                    if (containsMegaserverCmd && playerWorld == this.client.getWorld()) {
                        playerWorldLocationX -= 15;
                        playerWorldLocationY -= 15;
                        for (int j = 0; j < 4; ++j) {
                            boolean despawned;
                            int ghostID = packetID * 4 + j;
                            if (packetID >= numGamePacketsSent[gameTick]) {
                                this.ghosts[ghostID].despawn();
                                continue;
                            }
                            if (emptyPacket) continue;
                            int ghostData = data.subDataBlocks[0][j];
                            boolean bl = despawned = (ghostData & 0x3FF) == 1023;
                            if (despawned) {
                                this.ghosts[ghostID].despawn();
                                continue;
                            }
                            int dx = ghostData & 0x1F;
                            int dy = ghostData >>> 5 & 0x1F;
                            int packedOrientation = ghostData >>> 10 & 0x3F;
                            int animationID = ghostData >>> 16 & 0x3FFF;
                            boolean isInteracting = (ghostData >>> 30 & 1) == 1;
                            boolean isPoseAnimation = (ghostData >>> 31 & 1) == 1;
                            WorldPoint ghostPosition = new WorldPoint(playerWorldLocationX + dx, playerWorldLocationY + dy, playerWorldLocationPlane);
                            this.ghosts[ghostID].moveTo(ghostPosition, packedOrientation * 32, animationID, isInteracting, isPoseAnimation, isInstanced);
                            int ghostWorld = data.subDataBlocks[j + 1][0];
                            this.ghosts[ghostID].setWorld(ghostWorld);
                            this.nameBytes[0] = (byte)(data.subDataBlocks[j + 1][1] & 0xFF);
                            this.nameBytes[1] = (byte)(data.subDataBlocks[j + 1][1] >>> 8 & 0xFF);
                            this.nameBytes[2] = (byte)(data.subDataBlocks[j + 1][1] >>> 16 & 0xFF);
                            this.nameBytes[3] = (byte)(data.subDataBlocks[j + 1][1] >>> 24 & 0xFF);
                            this.nameBytes[4] = (byte)(data.subDataBlocks[j + 1][2] & 0xFF);
                            this.nameBytes[5] = (byte)(data.subDataBlocks[j + 1][2] >>> 8 & 0xFF);
                            this.nameBytes[6] = (byte)(data.subDataBlocks[j + 1][2] >>> 16 & 0xFF);
                            this.nameBytes[7] = (byte)(data.subDataBlocks[j + 1][2] >>> 24 & 0xFF);
                            this.nameBytes[8] = (byte)(data.subDataBlocks[j + 1][3] & 0xFF);
                            this.nameBytes[9] = (byte)(data.subDataBlocks[j + 1][3] >>> 8 & 0xFF);
                            this.nameBytes[10] = (byte)(data.subDataBlocks[j + 1][3] >>> 16 & 0xFF);
                            this.nameBytes[11] = (byte)(data.subDataBlocks[j + 1][3] >>> 24 & 0xFF);
                            this.ghosts[ghostID].setName(new String(this.nameBytes, StandardCharsets.UTF_8).trim());
                        }
                    }
                    ++packetID;
                }
            }
            if (numChatPacketsSent[chatTick = (lastReceivedChatTick + i) % 16] > 0) {
                int packetID = 0;
                while (true) {
                    int ghostWorld;
                    if (packetID >= 4) break;
                    JebScapeServerData data = chatServerData[chatTick][packetID];
                    boolean emptyPacket = data.isEmpty();
                    boolean containsMegaserverCmd = false;
                    boolean containsLiveHiscoresCmd = false;
                    int playerWorldFlags = 0;
                    int playerWorld = 0;
                    int playerWorldLocationX = 0;
                    int playerWorldLocationY = 0;
                    int playerWorldLocationPlane = 0;
                    int playerAnimationState = 0;
                    boolean isInstanced = false;
                    if (!emptyPacket) {
                        containsMegaserverCmd = (data.coreData[0] & 0xFF & 1) != 0;
                        containsLiveHiscoresCmd = (data.coreData[0] & 0xFF & 2) != 0;
                        playerWorldFlags = data.coreData[0] >>> 8 & 0xFF;
                        playerWorld = data.coreData[0] >>> 16 & 0x3FFF;
                        playerWorldLocationPlane = data.coreData[0] >>> 30 & 3;
                        playerWorldLocationX = data.coreData[1] & 0xFFFF;
                        playerWorldLocationY = data.coreData[1] >>> 16 & 0xFFFF;
                        playerAnimationState = data.coreData[2];
                        boolean bl = isInstanced = (playerWorldFlags >>> 1 & 1) == 1;
                    }
                    if (containsMegaserverCmd && playerWorld == this.client.getWorld() && (ghostWorld = data.subDataBlocks[0][0]) != 0) {
                        this.nameBytes[0] = (byte)(data.subDataBlocks[0][1] & 0xFF);
                        this.nameBytes[1] = (byte)(data.subDataBlocks[0][1] >>> 8 & 0xFF);
                        this.nameBytes[2] = (byte)(data.subDataBlocks[0][1] >>> 16 & 0xFF);
                        this.nameBytes[3] = (byte)(data.subDataBlocks[0][1] >>> 24 & 0xFF);
                        this.nameBytes[4] = (byte)(data.subDataBlocks[0][2] & 0xFF);
                        this.nameBytes[5] = (byte)(data.subDataBlocks[0][2] >>> 8 & 0xFF);
                        this.nameBytes[6] = (byte)(data.subDataBlocks[0][2] >>> 16 & 0xFF);
                        this.nameBytes[7] = (byte)(data.subDataBlocks[0][2] >>> 24 & 0xFF);
                        this.nameBytes[8] = (byte)(data.subDataBlocks[0][3] & 0xFF);
                        this.nameBytes[9] = (byte)(data.subDataBlocks[0][3] >>> 8 & 0xFF);
                        this.nameBytes[10] = (byte)(data.subDataBlocks[0][3] >>> 16 & 0xFF);
                        this.nameBytes[11] = (byte)(data.subDataBlocks[0][3] >>> 24 & 0xFF);
                        String senderName = new String(this.nameBytes, StandardCharsets.UTF_8).trim();
                        for (int ghostID = 0; ghostID < 64; ++ghostID) {
                            JebScapeActor ghost = this.ghosts[ghostID];
                            String name = ghost.getName();
                            if (ghost.getWorld() != ghostWorld || name == null || !name.contentEquals(senderName)) continue;
                            int index = 0;
                            for (int j = 1; j < 6; ++j) {
                                for (int k = 0; k < 4; ++k) {
                                    this.chatBytes[index++] = (byte)(data.subDataBlocks[j][k] & 0xFF);
                                    this.chatBytes[index++] = (byte)(data.subDataBlocks[j][k] >>> 8 & 0xFF);
                                    this.chatBytes[index++] = (byte)(data.subDataBlocks[j][k] >>> 16 & 0xFF);
                                    this.chatBytes[index++] = (byte)(data.subDataBlocks[j][k] >>> 24 & 0xFF);
                                }
                            }
                            this.ghosts[ghostID].setChatMessage(new String(this.chatBytes, StandardCharsets.UTF_8).trim());
                            break;
                        }
                    }
                    if (containsLiveHiscoresCmd) {
                        int monitoredPlayerRankOffset = data.subDataBlocks[0][0] & 7;
                        int startRank = data.subDataBlocks[0][0] >>> 3 & 0x1FFFF;
                        this.liveHiscoresLevels[0] = data.subDataBlocks[0][0] >>> 20 & 0xFFF;
                        this.liveHiscoresLevels[1] = data.subDataBlocks[0][1] & 0xFFF;
                        this.liveHiscoresLevels[2] = data.subDataBlocks[0][1] >>> 12 & 0xFFF;
                        this.liveHiscoresLevels[3] = data.subDataBlocks[0][2] & 0xFFF;
                        this.liveHiscoresLevels[4] = data.subDataBlocks[0][2] >>> 12 & 0xFFF;
                        int skillType = data.subDataBlocks[0][3] & 0x7F;
                        boolean validSkillType = false;
                        Skill trackedSkill = Skill.AGILITY;
                        if (skillType > 0 && skillType <= Skill.values().length) {
                            trackedSkill = Skill.values()[skillType - 1];
                            validSkillType = true;
                        }
                        if (validSkillType) {
                            for (int j = 0; j < 5; ++j) {
                                this.liveHiscoresXPs[j] = data.subDataBlocks[j + 1][0] & Integer.MAX_VALUE;
                                this.liveHiscoresOnlineStatuses[j] = data.subDataBlocks[j + 1][0] >>> 31 == 1;
                                this.nameBytes[0] = (byte)(data.subDataBlocks[j + 1][1] & 0xFF);
                                this.nameBytes[1] = (byte)(data.subDataBlocks[j + 1][1] >>> 8 & 0xFF);
                                this.nameBytes[2] = (byte)(data.subDataBlocks[j + 1][1] >>> 16 & 0xFF);
                                this.nameBytes[3] = (byte)(data.subDataBlocks[j + 1][1] >>> 24 & 0xFF);
                                this.nameBytes[4] = (byte)(data.subDataBlocks[j + 1][2] & 0xFF);
                                this.nameBytes[5] = (byte)(data.subDataBlocks[j + 1][2] >>> 8 & 0xFF);
                                this.nameBytes[6] = (byte)(data.subDataBlocks[j + 1][2] >>> 16 & 0xFF);
                                this.nameBytes[7] = (byte)(data.subDataBlocks[j + 1][2] >>> 24 & 0xFF);
                                this.nameBytes[8] = (byte)(data.subDataBlocks[j + 1][3] & 0xFF);
                                this.nameBytes[9] = (byte)(data.subDataBlocks[j + 1][3] >>> 8 & 0xFF);
                                this.nameBytes[10] = (byte)(data.subDataBlocks[j + 1][3] >>> 16 & 0xFF);
                                this.nameBytes[11] = (byte)(data.subDataBlocks[j + 1][3] >>> 24 & 0xFF);
                                this.liveHiscoresPlayerNames[j] = new String(this.nameBytes, StandardCharsets.UTF_8).trim();
                            }
                            this.liveHiscoresOverlay.updateSkillHiscoresData(trackedSkill, startRank, this.liveHiscoresPlayerNames, this.liveHiscoresLevels, this.liveHiscoresXPs, this.liveHiscoresOnlineStatuses);
                        }
                    }
                    ++packetID;
                }
            }
            ++i;
        }
        Player player = this.client.getLocalPlayer();
        WorldPoint position = player.getWorldLocation();
        boolean isPoseAnimation = player.getAnimation() == -1;
        int animationID = isPoseAnimation ? player.getPoseAnimation() : player.getAnimation();
        boolean isInteracting = player.getInteracting() != null;
        int packedOrientation = player.getOrientation() / 32;
        boolean isPVP = WorldType.isPvpWorld((Collection)this.client.getWorldType());
        boolean isInstanced = this.client.isInInstancedRegion();
        if (isInstanced) {
            position = WorldPoint.fromLocalInstance((Client)this.client, (LocalPoint)LocalPoint.fromWorld((Client)this.client, (WorldPoint)position));
        }
        this.clientData[0] = 1;
        this.clientData[0] = this.clientData[0] | (isPVP ? 1 : 0) << 8;
        this.clientData[0] = this.clientData[0] | (isInstanced ? 1 : 0) << 9;
        this.clientData[0] = this.clientData[0] | 0;
        this.clientData[0] = this.clientData[0] | (this.client.getWorld() & 0x3FFF) << 16;
        this.clientData[0] = this.clientData[0] | (this.client.getPlane() & 3) << 30;
        this.clientData[1] = position.getX() & 0xFFFF;
        this.clientData[1] = this.clientData[1] | (position.getY() & 0xFFFF) << 16;
        this.clientData[2] = 0;
        this.clientData[2] = this.clientData[2] | (packedOrientation & 0x3F) << 10;
        this.clientData[2] = this.clientData[2] | (animationID & 0x3FFF) << 16;
        this.clientData[2] = this.clientData[2] | (isInteracting ? 1 : 0) << 30;
        this.clientData[2] = this.clientData[2] | (isPoseAnimation ? 1 : 0) << 31;
        byte[] extraChatData = new byte[96];
        if (!this.chatMessageToSend.isEmpty()) {
            extraChatData = this.chatMessageToSend.getBytes(StandardCharsets.UTF_8);
            this.chatMessageToSend = "";
        } else {
            this.clientData[0] = this.clientData[0] | 2;
            int skillType = this.skillTypeToTrack.ordinal() + 1;
            int userInputDataA = 0;
            int userInputDataB = 0;
            int userInputDataC = this.startRankToTrack & 0x1FFFF;
            userInputDataC |= (skillType & 0x7F) << 17;
            if (!this.server.isGuest()) {
                Skill[] skills = Skill.values();
                int numSkills = skills.length;
                for (int i2 = 0; i2 < numSkills; ++i2) {
                    int xp = this.client.getSkillExperience(skills[i2]);
                    if (xp == 200000000) {
                        this.post200mXpAccumulator[i2] = Math.max(0, Math.min(336870911, this.post200mXpAccumulator[i2]));
                        xp += this.post200mXpAccumulator[i2];
                        if (this.post200mXpAccumulator[i2] > 300000000) {
                            this.resetPost200mXpAccumulators();
                        }
                    }
                    extraChatData[i2 * 4] = (byte)(xp &= 0x1FFFFFFF);
                    extraChatData[i2 * 4 + 1] = (byte)(xp >>> 8);
                    extraChatData[i2 * 4 + 2] = (byte)(xp >>> 16);
                    extraChatData[i2 * 4 + 3] = (byte)(xp >>> 24);
                }
            }
            for (int i3 = 0; i3 < 24; ++i3) {
                int n = i3 * 4 + 3;
                extraChatData[n] = (byte)(extraChatData[n] | (byte)((userInputDataA >>> i3 & 1) << 5));
                int n2 = i3 * 4 + 3;
                extraChatData[n2] = (byte)(extraChatData[n2] | (byte)((userInputDataB >>> i3 & 1) << 6));
                int n3 = i3 * 4 + 3;
                extraChatData[n3] = (byte)(extraChatData[n3] | (byte)((userInputDataC >>> i3 & 1) << 7));
            }
        }
        return this.server.sendGameData(this.clientData[0], this.clientData[1], this.clientData[2], extraChatData) ? 12 : 0;
    }

    public void onClientTick(ClientTick clientTick) {
        if (!this.isActive) {
            return;
        }
        for (int i = 0; i < 64; ++i) {
            this.ghosts[i].onClientTick();
        }
    }

    private void loadGhostRenderables() {
        int[] ids = this.client.getNpcDefinition(3516).getModels();
        ModelData[] modelData = new ModelData[ids.length];
        for (int i = 0; i < ids.length; ++i) {
            modelData[i] = this.client.loadModelData(ids[i]);
        }
        ModelData combinedModelData = this.client.mergeModels(modelData, ids.length);
        this.ghostModel = combinedModelData.light(64, 850, -30, -50, -30);
        Player player = this.client.getLocalPlayer();
        for (int i = 0; i < 64; ++i) {
            this.ghosts[i].setModel(this.ghostModel);
            this.ghosts[i].setPoseAnimations((Actor)player);
        }
    }
}

