/*
 * Decompiled with CFR 0.152.
 */
package com.jebscape.core;

import com.google.inject.Provides;
import com.jebscape.core.JebScapeAccountKeyOverlay;
import com.jebscape.core.JebScapeActorIndicatorOverlay;
import com.jebscape.core.JebScapeConfig;
import com.jebscape.core.JebScapeConnection;
import com.jebscape.core.JebScapeLiveHiscoresOverlay;
import com.jebscape.core.JebScapeMinimapOverlay;
import com.jebscape.core.MegaserverMod;
import javax.inject.Inject;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.ScriptEvent;
import net.runelite.api.Skill;
import net.runelite.api.events.AnimationChanged;
import net.runelite.api.events.ChatMessage;
import net.runelite.api.events.ClientTick;
import net.runelite.api.events.FakeXpDrop;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.GameTick;
import net.runelite.api.widgets.Widget;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.chat.ChatColorType;
import net.runelite.client.chat.ChatMessageBuilder;
import net.runelite.client.chat.ChatMessageManager;
import net.runelite.client.chat.QueuedMessage;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.config.RuneScapeProfileType;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import net.runelite.client.util.LinkBrowser;
import net.runelite.client.util.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="JebScape")
public class JebScapePlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(JebScapePlugin.class);
    @Inject
    private Client client;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private JebScapeActorIndicatorOverlay actorIndicatorOverlay;
    @Inject
    private JebScapeMinimapOverlay minimapOverlay;
    @Inject
    private JebScapeLiveHiscoresOverlay liveHiscoresOverlay;
    @Inject
    private JebScapeAccountKeyOverlay accountKeyOverlay;
    @Inject
    private ClientThread clientThread;
    @Inject
    private JebScapeConfig config;
    @Inject
    private ConfigManager configManager;
    @Inject
    private ChatMessageManager chatMessageManager;
    private JebScapeConnection server = new JebScapeConnection();
    private MegaserverMod megaserverMod = new MegaserverMod();
    private boolean useMegaserverMod = true;
    private boolean useAccountKey = false;
    private long accountKey = 0L;

    protected void startUp() throws Exception {
        log.info("JebScape has started!");
        this.server.init();
        if (!this.server.connect()) {
            log.debug("ERROR: JebScape datagram channel failed to connect.");
        }
        this.actorIndicatorOverlay.init(this.client);
        this.minimapOverlay.init(this.client);
        this.liveHiscoresOverlay.init(this.client);
        this.accountKeyOverlay.init(this.client, this);
        this.overlayManager.add((Overlay)this.actorIndicatorOverlay);
        this.overlayManager.add((Overlay)this.minimapOverlay);
        this.overlayManager.add((Overlay)this.liveHiscoresOverlay);
        this.overlayManager.add((Overlay)this.accountKeyOverlay);
        this.clientThread.invoke(() -> {
            this.useMegaserverMod = true;
            this.megaserverMod.init(this.client, this.server, this.actorIndicatorOverlay, this.minimapOverlay, this.liveHiscoresOverlay);
            if (((Boolean)this.configManager.getConfiguration("jebscape", "hideLiveHiscores", Boolean.TYPE)).booleanValue()) {
                this.liveHiscoresOverlay.hide();
            } else {
                this.liveHiscoresOverlay.show();
            }
            this.megaserverMod.setLiveHiscoresSkillType((Skill)this.configManager.getConfiguration("jebscape", "selectSkillLiveHiscores", Skill.class));
            this.megaserverMod.setLiveHiscoresStartRank((Integer)this.configManager.getConfiguration("jebscape", "startRankLiveHiscores", Integer.TYPE));
        });
    }

    protected void shutDown() throws Exception {
        this.clientThread.invoke(() -> {
            this.server.logout();
            this.megaserverMod.resetPost200mXpAccumulators();
            this.megaserverMod.stop();
        });
        this.accountKeyOverlay.cleanup();
        this.overlayManager.remove((Overlay)this.accountKeyOverlay);
        this.overlayManager.remove((Overlay)this.liveHiscoresOverlay);
        this.overlayManager.remove((Overlay)this.minimapOverlay);
        this.overlayManager.remove((Overlay)this.actorIndicatorOverlay);
        this.server.disconnect();
        log.info("JebScape has stopped!");
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged gameStateChanged) {
        if (gameStateChanged.getGameState() != GameState.LOGGED_IN && this.client.getGameState() != GameState.LOADING) {
            this.server.logout();
            this.accountKeyOverlay.hide();
            this.liveHiscoresOverlay.setContainsData(false);
            this.megaserverMod.resetPost200mXpAccumulators();
        } else if (gameStateChanged.getGameState() != GameState.LOGGED_IN) {
            this.megaserverMod.stop();
        }
    }

    @Subscribe
    public void onChatMessage(ChatMessage chatMessage) {
        if (this.megaserverMod.isActive()) {
            this.megaserverMod.onChatMessage(chatMessage);
        }
    }

    @Subscribe
    public void onAnimationChanged(AnimationChanged animationChanged) {
        if (this.megaserverMod.isActive()) {
            this.megaserverMod.onAnimationChanged(animationChanged);
        }
    }

    @Subscribe
    public void onFakeXpDrop(FakeXpDrop fakeXpDrop) {
        if (this.megaserverMod.isActive()) {
            this.megaserverMod.onFakeXpDrop(fakeXpDrop);
        }
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged configChanged) {
        if (configChanged.getGroup().contentEquals("jebscape")) {
            if (configChanged.getKey().contentEquals("hideLiveHiscores")) {
                if (this.config.hideLiveHiscores()) {
                    this.liveHiscoresOverlay.hide();
                } else {
                    this.liveHiscoresOverlay.show();
                }
            }
            if (configChanged.getKey().contentEquals("selectSkillLiveHiscores")) {
                this.megaserverMod.setLiveHiscoresSkillType(this.config.selectSkillLiveHiscores());
            }
            if (configChanged.getKey().contentEquals("startRankLiveHiscores")) {
                this.megaserverMod.setLiveHiscoresStartRank(this.config.startRankLiveHiscores());
            }
        }
    }

    public void setRSProfileAccountKey(long key) {
        this.configManager.setRSProfileConfiguration("JebScape", "JebScapeAccountKey", (Object)(key ^ this.client.getAccountHash()));
        this.clientThread.invokeLater(() -> this.server.logout());
        this.megaserverMod.resetPost200mXpAccumulators();
    }

    public boolean getUseAccountKey() {
        return this.useAccountKey;
    }

    public void addGameMessage(String message) {
        this.clientThread.invokeLater(() -> this.client.addChatMessage(ChatMessageType.GAMEMESSAGE, "", message, null));
    }

    @Subscribe
    public void onGameTick(GameTick gameTick) {
        if (!this.useMegaserverMod && this.megaserverMod.isActive()) {
            this.server.logout();
            this.megaserverMod.resetPost200mXpAccumulators();
            this.megaserverMod.stop();
        }
        if (this.useMegaserverMod && (this.client.getGameState() == GameState.LOGGED_IN || this.client.getGameState() == GameState.LOADING)) {
            boolean prevGameLoginStatus = this.server.isGameLoggedIn();
            RuneScapeProfileType rsProfileType = RuneScapeProfileType.getCurrent((Client)this.client);
            if (!this.server.isGameLoggedIn() || !this.server.isChatLoggedIn()) {
                String keyConfig = this.configManager.getRSProfileConfiguration("JebScape", "JebScapeAccountKey");
                if (keyConfig != null && rsProfileType == RuneScapeProfileType.STANDARD) {
                    Long key = Long.parseLong(keyConfig);
                    if (key != null) {
                        this.accountKey = key ^ this.client.getAccountHash();
                        this.useAccountKey = true;
                    } else {
                        this.accountKey = 0L;
                        this.useAccountKey = false;
                    }
                } else {
                    this.accountKey = 0L;
                    this.useAccountKey = false;
                }
            }
            this.server.onGameTick();
            if (!this.server.isGameLoggedIn()) {
                if (this.megaserverMod.isActive()) {
                    this.megaserverMod.stop();
                }
                this.server.login(this.client.getAccountHash(), this.accountKey, Text.sanitize((String)this.client.getLocalPlayer().getName()), this.useAccountKey);
            } else if (this.client.getAccountHash() == this.server.getAccountHash()) {
                Widget chatWidget;
                if (!this.server.isChatLoggedIn()) {
                    this.server.login(this.client.getAccountHash(), this.accountKey, Text.sanitize((String)this.client.getLocalPlayer().getName()), this.useAccountKey);
                    this.liveHiscoresOverlay.setContainsData(false);
                    this.megaserverMod.resetPost200mXpAccumulators();
                }
                int gameDataBytesSent = 0;
                if (!this.megaserverMod.isActive()) {
                    this.megaserverMod.start();
                }
                gameDataBytesSent += this.megaserverMod.onGameTick();
                if (!prevGameLoginStatus) {
                    ChatMessageBuilder message = new ChatMessageBuilder();
                    message.append(ChatColorType.NORMAL).append("Welcome to JebScape! There are currently " + this.server.getGameNumOnlinePlayers() + " players online.");
                    this.chatMessageManager.queue(QueuedMessage.builder().type(ChatMessageType.WELCOME).runeLiteFormattedMessage(message.build()).build());
                    if (this.server.isGuest()) {
                        if (this.useAccountKey) {
                            message = new ChatMessageBuilder();
                            message.append(ChatColorType.HIGHLIGHT).append("Login attempt failed. Invalid account details sent to server. Try again.");
                            this.chatMessageManager.queue(QueuedMessage.builder().type(ChatMessageType.GAMEMESSAGE).runeLiteFormattedMessage(message.build().replaceAll("colHIGHLIGHT", "col=f50202")).build());
                            this.configManager.unsetRSProfileConfiguration("JebScape", "JebScapeAccountKey");
                            this.useAccountKey = false;
                        }
                        if (rsProfileType != RuneScapeProfileType.STANDARD) {
                            message = new ChatMessageBuilder();
                            message.append(ChatColorType.NORMAL).append("You are logged in as a guest. Account key login requires a standard world.");
                            this.chatMessageManager.queue(QueuedMessage.builder().type(ChatMessageType.GAMEMESSAGE).runeLiteFormattedMessage(message.build().replaceAll("colHIGHLIGHT", "col=d4f502")).build());
                        } else {
                            message = new ChatMessageBuilder();
                            message.append(ChatColorType.HIGHLIGHT).append("You are logged in as a guest. Click here to create an account.");
                            this.chatMessageManager.queue(QueuedMessage.builder().type(ChatMessageType.GAMEMESSAGE).runeLiteFormattedMessage(message.build().replaceAll("colHIGHLIGHT", "col=d4f502")).build());
                            this.useAccountKey = false;
                        }
                    }
                }
                if ((chatWidget = this.client.getWidget(WidgetInfo.CHATBOX_MESSAGE_LINES)) != null && !this.useAccountKey) {
                    for (Widget w : chatWidget.getDynamicChildren()) {
                        if (Text.removeTags((String)w.getText()).contains("You are logged in as a guest. Click here to create an account.")) {
                            this.clientThread.invokeLater(() -> {
                                w.setAction(1, "Create JebScape Account");
                                w.setOnOpListener(new Object[]{this::clickCreateJebScapeAccount});
                                w.setHasListener(true);
                                w.setNoClickThrough(true);
                                w.revalidate();
                            });
                            continue;
                        }
                        this.clientThread.invokeLater(() -> {
                            w.setHasListener(false);
                            w.setNoClickThrough(false);
                            w.revalidate();
                        });
                    }
                }
            }
        }
    }

    protected void clickCreateJebScapeAccount(ScriptEvent ev) {
        LinkBrowser.browse((String)"www.patreon.com/jebscape/membership");
        this.accountKeyOverlay.show();
    }

    @Subscribe
    public void onClientTick(ClientTick clientTick) {
        this.megaserverMod.onClientTick(clientTick);
    }

    @Provides
    JebScapeConfig provideConfig(ConfigManager configManager) {
        return (JebScapeConfig)configManager.getConfig(JebScapeConfig.class);
    }
}

