/*
 * Decompiled with CFR 0.152.
 */
package com.jebscape.core;

import com.jebscape.core.JebScapeActor;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import net.runelite.api.Client;
import net.runelite.api.Perspective;
import net.runelite.api.Point;
import net.runelite.api.SpritePixels;
import net.runelite.api.coords.LocalPoint;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.OverlayPriority;
import net.runelite.client.ui.overlay.OverlayUtil;

public class JebScapeMinimapOverlay
extends Overlay {
    private JebScapeActor[] actors;
    private Client client;
    private final Color color = new Color(5, 248, 242, 218);

    public void init(Client client) {
        this.client = client;
        this.setLayer(OverlayLayer.ABOVE_WIDGETS);
        this.setPriority(OverlayPriority.HIGHEST);
        this.setPosition(OverlayPosition.DYNAMIC);
        this.setMovable(false);
    }

    public void setJebScapeActors(JebScapeActor[] actors) {
        this.actors = actors;
    }

    public Dimension render(Graphics2D graphics) {
        SpritePixels[] mapDots;
        if (this.actors != null && (mapDots = this.client.getMapDots()) != null) {
            for (int i = 0; i < this.actors.length; ++i) {
                Point minimapPoint;
                JebScapeActor actor = this.actors[i];
                if (!actor.isActive() || (minimapPoint = Perspective.localToMinimap((Client)this.client, (LocalPoint)this.actors[i].getLocalLocation())) == null) continue;
                OverlayUtil.renderMinimapLocation((Graphics2D)graphics, (Point)minimapPoint, (Color)this.color);
            }
        }
        return null;
    }
}

