/*
 * Decompiled with CFR 0.152.
 */
package com.jebscape.core;

import com.jebscape.core.JebScapePlugin;
import com.jebscape.core.RuneLiteTableComponent;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.Point;
import net.runelite.api.Skill;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayPanel;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.OverlayPriority;
import net.runelite.client.ui.overlay.components.TitleComponent;
import net.runelite.client.ui.overlay.tooltip.Tooltip;
import net.runelite.client.ui.overlay.tooltip.TooltipManager;
import net.runelite.client.util.ColorUtil;

public class JebScapeLiveHiscoresOverlay
extends OverlayPanel {
    private static final String RANK_COLUMN_HEADER = "Rank";
    private static final String NAME_COLUMN_HEADER = "Name";
    private static final String LEVEL_COLUMN_HEADER = "Level";
    private static final String XP_COLUMN_HEADER = "XP";
    private Skill currentSkill;
    private int currentStartRank;
    private String[] currentPlayerNames;
    private int[] currentLevels;
    private int[] currentXPs;
    private boolean[] currentOnlineStatuses;
    private boolean containsData;
    private final int MAX_SKILL_FRAME_QUEUE_SIZE = 10;
    private final SkillFrame[] skillFrameQueue = new SkillFrame[10];
    private int currentSkillFrameIndex;
    private int skillFrameQueueSize;
    @Inject
    JebScapePlugin plugin;
    @Inject
    private TooltipManager tooltipManager;
    private Client client;
    private final Color headerColor = new Color(5, 248, 242, 218);
    private final Color onlineColor = new Color(5, 248, 5, 218);
    private final Tooltip guestTooltip = new Tooltip("Requires JebScape account to participate. See JebScape settings to configure.");
    private final Tooltip accountTooltip = new Tooltip("See JebScape settings to configure.");
    private boolean isVisible;

    public void init(Client client) {
        this.client = client;
        this.isVisible = false;
        this.containsData = false;
        this.currentSkill = Skill.AGILITY;
        this.currentSkillFrameIndex = 0;
        this.skillFrameQueueSize = 0;
        for (int i = 0; i < 10; ++i) {
            this.skillFrameQueue[i] = new SkillFrame();
        }
        this.setPosition(OverlayPosition.DYNAMIC);
        this.setPriority(OverlayPriority.LOW);
        this.setLayer(OverlayLayer.ABOVE_SCENE);
        this.setMovable(true);
        this.setClearChildren(true);
    }

    public boolean isVisible() {
        return this.isVisible;
    }

    public void updateSkillHiscoresData(Skill skill, int startRank, String[] playerNames, int[] levels, int[] XPs, boolean[] onlineStatuses) {
        if (this.skillFrameQueueSize >= 8 || this.currentSkill != skill) {
            this.currentSkill = skill;
            this.skillFrameQueueSize = 0;
        }
        int newSkillFrameIndex = (this.currentSkillFrameIndex + this.skillFrameQueueSize++) % 10;
        this.skillFrameQueue[newSkillFrameIndex].skill = skill;
        this.skillFrameQueue[newSkillFrameIndex].startRank = startRank;
        this.skillFrameQueue[newSkillFrameIndex].playerNames = playerNames;
        this.skillFrameQueue[newSkillFrameIndex].levels = levels;
        this.skillFrameQueue[newSkillFrameIndex].XPs = XPs;
        this.skillFrameQueue[newSkillFrameIndex].onlineStatuses = onlineStatuses;
        this.setContainsData(true);
    }

    public void onGameTick() {
        if (this.skillFrameQueueSize > 0) {
            this.currentSkill = this.skillFrameQueue[this.currentSkillFrameIndex].skill;
            this.currentStartRank = this.skillFrameQueue[this.currentSkillFrameIndex].startRank;
            this.currentPlayerNames = this.skillFrameQueue[this.currentSkillFrameIndex].playerNames;
            this.currentLevels = this.skillFrameQueue[this.currentSkillFrameIndex].levels;
            this.currentXPs = this.skillFrameQueue[this.currentSkillFrameIndex].XPs;
            this.currentOnlineStatuses = this.skillFrameQueue[this.currentSkillFrameIndex].onlineStatuses;
            this.currentSkillFrameIndex = (this.currentSkillFrameIndex + 1) % 10;
            --this.skillFrameQueueSize;
        }
    }

    public void setContainsData(boolean containsData) {
        this.containsData = containsData;
    }

    public void hide() {
        this.isVisible = false;
    }

    public void show() {
        this.isVisible = true;
    }

    public Dimension render(Graphics2D graphics) {
        if (!this.isVisible || !this.containsData || this.currentXPs == null || this.currentXPs.length == 0) {
            return super.render(graphics);
        }
        this.setPreferredSize(new Dimension(320, 100));
        this.getPanelComponent().getChildren().add(TitleComponent.builder().text("JebScape Live Hiscores").color(this.headerColor).build());
        this.getPanelComponent().getChildren().add(TitleComponent.builder().text(this.currentSkill.getName()).color(this.headerColor).build());
        RuneLiteTableComponent liveHiscoresTable = new RuneLiteTableComponent();
        liveHiscoresTable.setColumnAlignments(RuneLiteTableComponent.TableAlignment.LEFT, RuneLiteTableComponent.TableAlignment.CENTER, RuneLiteTableComponent.TableAlignment.CENTER, RuneLiteTableComponent.TableAlignment.RIGHT);
        liveHiscoresTable.addRow(ColorUtil.prependColorTag((String)RANK_COLUMN_HEADER, (Color)this.headerColor), ColorUtil.prependColorTag((String)NAME_COLUMN_HEADER, (Color)this.headerColor), ColorUtil.prependColorTag((String)LEVEL_COLUMN_HEADER, (Color)this.headerColor), ColorUtil.prependColorTag((String)XP_COLUMN_HEADER, (Color)this.headerColor));
        for (int i = 0; i < this.currentXPs.length; ++i) {
            if (this.currentPlayerNames[i] == null || this.currentPlayerNames[i].length() == 0) {
                this.currentPlayerNames[i] = "[No Player Ranked]";
            }
            if (this.currentOnlineStatuses[i]) {
                liveHiscoresTable.addRow(ColorUtil.prependColorTag((String)Integer.toString(this.currentStartRank + i), (Color)this.onlineColor), ColorUtil.prependColorTag((String)this.currentPlayerNames[i], (Color)this.onlineColor), ColorUtil.prependColorTag((String)Integer.toString(this.currentLevels[i]), (Color)this.onlineColor), ColorUtil.prependColorTag((String)String.format("%,d", this.currentXPs[i]), (Color)this.onlineColor));
                continue;
            }
            liveHiscoresTable.addRow(Integer.toString(this.currentStartRank + i), this.currentPlayerNames[i], Integer.toString(this.currentLevels[i]), String.format("%,d", this.currentXPs[i]));
        }
        this.getPanelComponent().getChildren().add(liveHiscoresTable);
        Rectangle bounds = this.getBounds();
        Point mousePosition = this.client.getMouseCanvasPosition();
        if (bounds.contains(mousePosition.getX(), mousePosition.getY())) {
            if (this.plugin.getUseAccountKey()) {
                this.tooltipManager.add(this.accountTooltip);
            } else {
                this.tooltipManager.add(this.guestTooltip);
            }
        }
        return super.render(graphics);
    }

    private static class SkillFrame {
        private Skill skill;
        private int startRank;
        private String[] playerNames;
        private int[] levels;
        private int[] XPs;
        private boolean[] onlineStatuses;

        private SkillFrame() {
        }
    }
}

