/*
 * Decompiled with CFR 0.152.
 */
package com.jebscape.core;

import com.jebscape.core.JebScapePacket;
import com.jebscape.core.JebScapeServerData;
import java.net.InetSocketAddress;
import java.net.StandardProtocolFamily;
import java.nio.channels.DatagramChannel;
import java.nio.charset.StandardCharsets;

public class JebScapeConnection {
    private DatagramChannel gameChannel;
    private DatagramChannel chatChannel;
    private InetSocketAddress gameAddress;
    private InetSocketAddress chatAddress;
    private boolean isGameLoggedIn;
    private boolean isChatLoggedIn;
    private int currentGameTick;
    private int currentChatTick;
    private int lastReceivedGameTick;
    private int lastReceivedChatTick;
    public static final int TICKS_UNTIL_LOGOUT = 16;
    public static final int GAME_SERVER_PACKETS_PER_TICK = 16;
    public static final int CHAT_SERVER_PACKETS_PER_TICK = 4;
    private long accountHash;
    private long accountKey;
    private boolean isUsingKey;
    private static final byte[] EMPTY_BYTES = new byte[96];
    private int gameSessionID = -1;
    private int chatSessionID = -1;
    private int gameServerPacketsReceived = 0;
    private int chatServerPacketsReceived = 0;
    private int gameNumOnlinePlayers = 0;
    private int chatNumOnlinePlayers = 0;
    private static final int PROTOCOL_VERSION = 1;
    private static final int EMPTY_PACKET = 0;
    private static final int LOGIN_PACKET = 1;
    private static final int GAME_PACKET = 2;
    private static final int CHAT_PACKET = 3;
    private static final int GAME_CLIENT_PACKET_SIZE = 64;
    private static final int CHAT_CLIENT_PACKET_SIZE = 128;
    private static final int GAME_SERVER_PACKET_SIZE = 128;
    private static final int CHAT_SERVER_PACKET_SIZE = 128;
    private JebScapePacket gameClientPacket = new JebScapePacket();
    private JebScapePacket chatClientPacket = new JebScapePacket();
    private JebScapePacket gameServerPacket = new JebScapePacket();
    private JebScapePacket chatServerPacket = new JebScapePacket();
    private JebScapeServerData[][] gameServerData = new JebScapeServerData[16][16];
    private JebScapeServerData[][] chatServerData = new JebScapeServerData[16][4];
    private int[] numGameServerPacketsSent = new int[16];
    private int[] numChatServerPacketsSent = new int[16];

    public void init() throws Exception {
        int j;
        int i;
        this.gameAddress = new InetSocketAddress("game.jebscape.com", 43596);
        this.chatAddress = new InetSocketAddress("chat.jebscape.com", 43597);
        this.gameChannel = DatagramChannel.open(StandardProtocolFamily.INET);
        this.gameChannel.configureBlocking(false);
        this.gameChannel.bind(null);
        this.chatChannel = DatagramChannel.open(StandardProtocolFamily.INET);
        this.chatChannel.configureBlocking(false);
        this.chatChannel.bind(null);
        this.isGameLoggedIn = false;
        this.isChatLoggedIn = false;
        this.currentGameTick = 0;
        this.gameClientPacket.init(64);
        this.chatClientPacket.init(128);
        this.gameServerPacket.init(128);
        this.gameServerPacket.erase();
        this.chatServerPacket.init(128);
        this.chatServerPacket.erase();
        for (i = 0; i < 16; ++i) {
            for (j = 0; j < 16; ++j) {
                this.gameServerData[i][j] = new JebScapeServerData();
            }
        }
        for (i = 0; i < 16; ++i) {
            for (j = 0; j < 4; ++j) {
                this.chatServerData[i][j] = new JebScapeServerData();
            }
        }
    }

    public boolean connect() {
        boolean connected;
        try {
            if (!this.gameChannel.isConnected()) {
                this.gameChannel.connect(this.gameAddress);
            }
            if (!this.chatChannel.isConnected()) {
                this.chatChannel.connect(this.chatAddress);
            }
            connected = this.gameChannel.isConnected();
        }
        catch (Exception e) {
            connected = false;
        }
        return connected;
    }

    public void disconnect() {
        this.isGameLoggedIn = false;
        this.isChatLoggedIn = false;
        this.gameSessionID = -1;
        this.chatSessionID = -1;
        try {
            if (this.chatChannel.isConnected()) {
                this.chatChannel.disconnect();
            }
            if (this.gameChannel.isConnected()) {
                this.gameChannel.disconnect();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean isConnected() {
        return this.gameChannel.isConnected() && this.chatChannel.isConnected();
    }

    public boolean isLoggedIn() {
        return this.isConnected() && this.isGameLoggedIn && this.isChatLoggedIn;
    }

    public boolean isGameLoggedIn() {
        return this.isConnected() && this.isGameLoggedIn;
    }

    public boolean isChatLoggedIn() {
        return this.isConnected() && this.isChatLoggedIn;
    }

    public boolean login(long accountHash, long accountKey, String accountName, boolean useKey) {
        long reserved;
        int strLen;
        byte[] nameBytes;
        int loginPacketHeader;
        if (!this.gameChannel.isConnected() || !this.chatChannel.isConnected()) {
            this.connect();
        }
        if (!this.gameChannel.isConnected() || !this.chatChannel.isConnected() || accountName.length() > 12) {
            return false;
        }
        this.accountHash = accountHash;
        this.accountKey = accountKey;
        this.isUsingKey = useKey;
        boolean success = true;
        if (!this.isGameLoggedIn) {
            this.gameServerPacketsReceived = 65535;
            loginPacketHeader = 1;
            loginPacketHeader |= (this.gameSessionID & 0x1FFFF) << 2;
            loginPacketHeader |= (this.isUsingKey ? 1 : 0) << 19;
            loginPacketHeader |= 0x100000;
            loginPacketHeader |= 0xF0000000;
            nameBytes = accountName.getBytes(StandardCharsets.UTF_8);
            strLen = accountName.length();
            reserved = -1L;
            try {
                this.gameClientPacket.buffer.clear();
                this.gameClientPacket.buffer.putInt(loginPacketHeader);
                this.gameClientPacket.buffer.putLong(accountHash);
                this.gameClientPacket.buffer.putLong(accountKey);
                this.gameClientPacket.buffer.put(nameBytes, 0, strLen);
                if (strLen < 12) {
                    this.gameClientPacket.buffer.put(EMPTY_BYTES, 0, 12 - strLen);
                }
                this.gameClientPacket.buffer.putLong(reserved);
                this.gameClientPacket.buffer.putLong(reserved);
                this.gameClientPacket.buffer.putLong(reserved);
                this.gameClientPacket.buffer.putLong(reserved);
                this.gameClientPacket.buffer.rewind();
                success = this.gameChannel.write(this.gameClientPacket.buffer) == 64;
            }
            catch (Exception e) {
                try {
                    this.gameChannel = DatagramChannel.open(StandardProtocolFamily.INET);
                    this.gameChannel.configureBlocking(false);
                    this.gameChannel.bind(null);
                    this.gameChannel.connect(this.gameAddress);
                    success = this.gameChannel.write(this.gameClientPacket.buffer) == 64;
                }
                catch (Exception exception) {
                    return false;
                }
            }
        }
        if (!this.isChatLoggedIn) {
            this.chatServerPacketsReceived = 65535;
            loginPacketHeader = 1;
            loginPacketHeader |= (this.chatSessionID & 0x1FFFF) << 2;
            loginPacketHeader |= (this.isUsingKey ? 1 : 0) << 19;
            loginPacketHeader |= 0x100000;
            loginPacketHeader |= 0xF0000000;
            nameBytes = accountName.getBytes(StandardCharsets.UTF_8);
            strLen = accountName.length();
            reserved = -1L;
            try {
                this.chatClientPacket.buffer.clear();
                this.chatClientPacket.buffer.putInt(loginPacketHeader);
                this.chatClientPacket.buffer.putLong(accountHash);
                this.chatClientPacket.buffer.putLong(accountKey);
                this.chatClientPacket.buffer.put(nameBytes, 0, strLen);
                if (strLen < 12) {
                    this.chatClientPacket.buffer.put(EMPTY_BYTES, 0, 12 - strLen);
                }
                this.chatClientPacket.buffer.putLong(reserved);
                this.chatClientPacket.buffer.putLong(reserved);
                this.chatClientPacket.buffer.putLong(reserved);
                this.chatClientPacket.buffer.putLong(reserved);
                this.chatClientPacket.buffer.putLong(reserved);
                this.chatClientPacket.buffer.putLong(reserved);
                this.chatClientPacket.buffer.putLong(reserved);
                this.chatClientPacket.buffer.putLong(reserved);
                this.chatClientPacket.buffer.putLong(reserved);
                this.chatClientPacket.buffer.putLong(reserved);
                this.chatClientPacket.buffer.putLong(reserved);
                this.chatClientPacket.buffer.putLong(reserved);
                this.chatClientPacket.buffer.rewind();
                success = success && this.chatChannel.write(this.chatClientPacket.buffer) == 128;
            }
            catch (Exception e) {
                try {
                    this.chatChannel = DatagramChannel.open(StandardProtocolFamily.INET);
                    this.chatChannel.configureBlocking(false);
                    this.chatChannel.bind(null);
                    this.chatChannel.connect(this.chatAddress);
                    success = success && this.chatChannel.write(this.chatClientPacket.buffer) == 128;
                }
                catch (Exception exception) {
                    return false;
                }
            }
        }
        return success;
    }

    public void logout() {
        this.accountHash = 0L;
        this.accountKey = 0L;
        this.isUsingKey = false;
        this.logoutGame();
        this.logoutChat();
    }

    public void logoutGame() {
        this.isGameLoggedIn = false;
        this.currentGameTick = 0;
        this.lastReceivedGameTick = 0;
        this.gameSessionID = -1;
        this.gameNumOnlinePlayers = 0;
    }

    public void logoutChat() {
        this.isChatLoggedIn = false;
        this.currentChatTick = 0;
        this.lastReceivedChatTick = 0;
        this.chatSessionID = -1;
        this.chatNumOnlinePlayers = 0;
    }

    public long getAccountHash() {
        return this.accountHash;
    }

    public boolean isGuest() {
        return this.isGameLoggedIn && !this.isUsingKey;
    }

    public JebScapeServerData[][] getRecentGameServerData() {
        return this.gameServerData;
    }

    public JebScapeServerData[][] getRecentChatServerData() {
        return this.chatServerData;
    }

    public int[] getNumGameServerPacketsSent() {
        return this.numGameServerPacketsSent;
    }

    public int[] getNumChatServerPacketsSent() {
        return this.numChatServerPacketsSent;
    }

    public int getLastReceivedGameTick() {
        return this.lastReceivedGameTick;
    }

    public int getLastReceivedChatTick() {
        return this.lastReceivedChatTick;
    }

    public int getCurrentGameTick() {
        return this.currentGameTick;
    }

    public int getCurrentChatTick() {
        return this.currentChatTick;
    }

    public int getGameNumOnlinePlayers() {
        return this.gameNumOnlinePlayers;
    }

    public int getChatNumOnlinePlayers() {
        return this.chatNumOnlinePlayers;
    }

    public boolean sendGameData(int dataA, int dataB, int dataC, byte[] extraChatData) {
        int packetHeader;
        if (!this.gameChannel.isConnected() || !this.chatChannel.isConnected()) {
            return false;
        }
        long reserved = -1L;
        int bytesWritten = 0;
        if (this.isGameLoggedIn) {
            packetHeader = 2;
            packetHeader |= (this.gameSessionID & 0x1FFFF) << 2;
            packetHeader |= (this.isUsingKey ? 1 : 0) << 19;
            packetHeader |= (this.currentGameTick & 0xF) << 20;
            packetHeader |= 0xFF000000;
            try {
                this.gameClientPacket.buffer.clear();
                this.gameClientPacket.buffer.putInt(packetHeader);
                this.gameClientPacket.buffer.putLong(this.accountHash);
                this.gameClientPacket.buffer.putLong(this.accountKey);
                this.gameClientPacket.buffer.putInt(dataA);
                this.gameClientPacket.buffer.putInt(dataB);
                this.gameClientPacket.buffer.putInt(dataC);
                this.gameClientPacket.buffer.putLong(reserved);
                this.gameClientPacket.buffer.putLong(reserved);
                this.gameClientPacket.buffer.putLong(reserved);
                this.gameClientPacket.buffer.putLong(reserved);
                this.gameClientPacket.buffer.rewind();
                bytesWritten += this.gameChannel.write(this.gameClientPacket.buffer);
            }
            catch (Exception e) {
                try {
                    this.gameChannel = DatagramChannel.open(StandardProtocolFamily.INET);
                    this.gameChannel.configureBlocking(false);
                    this.gameChannel.bind(null);
                    this.gameChannel.connect(this.gameAddress);
                    bytesWritten += this.gameChannel.write(this.gameClientPacket.buffer);
                }
                catch (Exception exception) {
                    return false;
                }
            }
        }
        if (this.isChatLoggedIn) {
            packetHeader = 3;
            packetHeader |= (this.chatSessionID & 0x1FFFF) << 2;
            packetHeader |= (this.isUsingKey ? 1 : 0) << 19;
            packetHeader |= (this.currentChatTick & 0xF) << 20;
            packetHeader |= 0xFF000000;
            int bytesLength = extraChatData.length;
            if (bytesLength > 96) {
                bytesLength = 96;
            }
            try {
                this.chatClientPacket.buffer.clear();
                this.chatClientPacket.buffer.putInt(packetHeader);
                this.chatClientPacket.buffer.putLong(this.accountHash);
                this.chatClientPacket.buffer.putLong(this.accountKey);
                this.chatClientPacket.buffer.putInt(dataA);
                this.chatClientPacket.buffer.putInt(dataB);
                this.chatClientPacket.buffer.putInt(dataC);
                if (bytesLength > 0) {
                    this.chatClientPacket.buffer.put(extraChatData, 0, bytesLength);
                }
                if (bytesLength < 96) {
                    this.chatClientPacket.buffer.put(EMPTY_BYTES, 0, 96 - bytesLength);
                }
                this.chatClientPacket.buffer.rewind();
                bytesWritten += this.chatChannel.write(this.chatClientPacket.buffer);
            }
            catch (Exception e) {
                try {
                    this.chatChannel = DatagramChannel.open(StandardProtocolFamily.INET);
                    this.chatChannel.configureBlocking(false);
                    this.chatChannel.bind(null);
                    this.chatChannel.connect(this.chatAddress);
                    bytesWritten += this.chatChannel.write(this.chatClientPacket.buffer);
                }
                catch (Exception exception) {
                    return false;
                }
            }
        }
        return bytesWritten == 192;
    }

    public void onGameTick() {
        int packetID;
        int tick;
        int i;
        int newPacketID;
        int newNumPacketsSent;
        int newTick;
        boolean newIsUsingKey;
        int newSessionID;
        int newPacketType;
        int packetHeader;
        if (!this.gameChannel.isConnected() || !this.chatChannel.isConnected()) {
            return;
        }
        for (int i2 = 0; i2 < 16; ++i2) {
            int j;
            this.numGameServerPacketsSent[i2] = 0;
            for (j = 0; j < 16; ++j) {
                this.gameServerData[i2][j].clear();
            }
            this.numChatServerPacketsSent[i2] = 0;
            for (j = 0; j < 4; ++j) {
                this.chatServerData[i2][j].clear();
            }
        }
        try {
            int bytesReceived;
            do {
                this.gameServerPacket.erase();
                this.gameServerPacket.buffer.clear();
                bytesReceived = this.gameChannel.read(this.gameServerPacket.buffer);
                this.gameServerPacket.buffer.rewind();
                if (bytesReceived != 128) continue;
                packetHeader = this.gameServerPacket.buffer.getInt();
                newPacketType = packetHeader & 3;
                newSessionID = packetHeader >>> 2 & 0x1FFFF;
                newIsUsingKey = (packetHeader >>> 19 & 1) == 1;
                newTick = packetHeader >>> 20 & 0xF;
                newNumPacketsSent = packetHeader >>> 24 & 0xF;
                newPacketID = packetHeader >>> 28 & 0xF;
                if (newPacketType == 1) {
                    this.isGameLoggedIn = true;
                    this.isUsingKey = newIsUsingKey;
                    this.gameSessionID = newSessionID;
                }
                if (!this.isGameLoggedIn || newPacketType != 1 && newPacketType != 2 || this.gameSessionID != newSessionID) continue;
                this.currentGameTick = newTick;
                this.lastReceivedGameTick = newTick;
                this.gameServerData[newTick][newPacketID].setData(this.gameServerPacket);
                this.numGameServerPacketsSent[newTick] = newNumPacketsSent + 1;
                this.gameNumOnlinePlayers = this.gameServerData[newTick][newPacketID].subDataBlocks[6][3];
            } while (bytesReceived > 0);
        }
        catch (Exception bytesReceived) {
            // empty catch block
        }
        try {
            do {
                this.chatServerPacket.erase();
                this.chatServerPacket.buffer.clear();
                int bytesReceived = this.chatChannel.read(this.chatServerPacket.buffer);
                this.chatServerPacket.buffer.rewind();
                if (bytesReceived != 128) continue;
                packetHeader = this.chatServerPacket.buffer.getInt();
                newPacketType = packetHeader & 3;
                newSessionID = packetHeader >>> 2 & 0x1FFFF;
                newIsUsingKey = (packetHeader >>> 19 & 1) == 1;
                newTick = packetHeader >>> 20 & 0xF;
                newNumPacketsSent = packetHeader >>> 24 & 0xF;
                newPacketID = packetHeader >>> 28 & 0xF;
                if (newPacketType == 1) {
                    this.isChatLoggedIn = true;
                    this.chatSessionID = newSessionID;
                }
                if (!this.isChatLoggedIn || newPacketType != 1 && newPacketType != 3 || this.chatSessionID != newSessionID) continue;
                this.currentChatTick = newTick;
                this.lastReceivedChatTick = newTick;
                this.chatServerData[newTick][newPacketID].setData(this.chatServerPacket);
                this.numChatServerPacketsSent[newTick] = newNumPacketsSent + 1;
                this.chatNumOnlinePlayers = this.chatServerData[newTick][newPacketID].subDataBlocks[6][3];
            } while (bytesReceived > 0);
        }
        catch (Exception bytesReceived) {
            // empty catch block
        }
        if (this.isGameLoggedIn) {
            int prevReceivedGameTick = this.lastReceivedGameTick;
            for (i = 0; i < 16; ++i) {
                tick = (prevReceivedGameTick + i) % 16;
                if (this.numGameServerPacketsSent[tick] <= 0) continue;
                this.currentGameTick = tick;
                this.lastReceivedGameTick = tick;
            }
            this.gameServerPacketsReceived = 0;
            if (this.numGameServerPacketsSent[this.lastReceivedGameTick] > 0) {
                for (packetID = 0; packetID < 16; ++packetID) {
                    this.gameServerPacketsReceived = (!this.gameServerData[this.lastReceivedGameTick][packetID].isEmpty() ? 1 : 0) << packetID;
                }
            }
            this.currentGameTick = (this.currentGameTick + 1) % 16;
            if (this.currentGameTick == this.lastReceivedGameTick) {
                this.logoutGame();
            }
        }
        if (this.isChatLoggedIn) {
            int prevReceivedChatTick = this.lastReceivedChatTick;
            for (i = 0; i < 16; ++i) {
                tick = (prevReceivedChatTick + i) % 16;
                if (this.numChatServerPacketsSent[tick] <= 0) continue;
                this.currentChatTick = tick;
                this.lastReceivedChatTick = tick;
            }
            this.chatServerPacketsReceived = 0;
            if (this.numChatServerPacketsSent[this.lastReceivedChatTick] > 0) {
                for (packetID = 0; packetID < 4; ++packetID) {
                    this.chatServerPacketsReceived = (!this.chatServerData[this.lastReceivedChatTick][packetID].isEmpty() ? 1 : 0) << packetID;
                }
            }
            this.currentChatTick = (this.currentChatTick + 1) % 16;
            if (this.currentChatTick == this.lastReceivedChatTick) {
                this.logoutChat();
            }
        }
    }
}

