/*
 * Decompiled with CFR 0.152.
 */
package com.jebscape.core;

import com.jebscape.core.JebScapeActor;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import javax.inject.Singleton;
import net.runelite.api.Client;
import net.runelite.api.Perspective;
import net.runelite.api.Point;
import net.runelite.api.coords.LocalPoint;
import net.runelite.client.ui.FontManager;
import net.runelite.client.ui.JagexColors;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.OverlayPriority;
import net.runelite.client.ui.overlay.OverlayUtil;

@Singleton
public class JebScapeActorIndicatorOverlay
extends Overlay {
    private JebScapeActor[] actors;
    private Client client;
    private final Color color = new Color(5, 248, 242, 218);

    public void init(Client client) {
        this.client = client;
        this.setLayer(OverlayLayer.ABOVE_SCENE);
        this.setPriority(OverlayPriority.HIGHEST);
        this.setPosition(OverlayPosition.TOP_LEFT);
        this.setMovable(false);
    }

    public void setJebScapeActors(JebScapeActor[] actors) {
        this.actors = actors;
    }

    public Dimension render(Graphics2D graphics) {
        if (this.actors != null) {
            for (int i = 0; i < this.actors.length; ++i) {
                Point textLocation;
                String chatMessage;
                Point textLocation2;
                JebScapeActor actor = this.actors[i];
                if (!actor.isActive()) continue;
                String overheadText = actor.getOverheadText();
                if (overheadText != null && !overheadText.isEmpty() && (textLocation2 = Perspective.localToCanvas((Client)this.client, (LocalPoint)actor.getLocalLocation(), (int)this.client.getPlane(), (int)260)) != null) {
                    Font chatFont = FontManager.getRunescapeSmallFont();
                    FontMetrics metrics = graphics.getFontMetrics(chatFont);
                    if ((textLocation2 = new Point(textLocation2.getX() - (metrics.stringWidth(overheadText) >>> 1), textLocation2.getY())) != null) {
                        graphics.setFont(chatFont);
                        OverlayUtil.renderTextLocation((Graphics2D)graphics, (Point)textLocation2, (String)overheadText, (Color)this.color);
                    }
                }
                if ((chatMessage = actor.getChatMessage()) == null || chatMessage.isEmpty() || (textLocation = Perspective.localToCanvas((Client)this.client, (LocalPoint)actor.getLocalLocation(), (int)this.client.getPlane(), (int)225)) == null) continue;
                Font chatFont = FontManager.getRunescapeBoldFont();
                FontMetrics metrics = graphics.getFontMetrics(chatFont);
                if ((textLocation = new Point(textLocation.getX() - (metrics.stringWidth(chatMessage) >>> 1), textLocation.getY())) == null) continue;
                graphics.setFont(chatFont);
                OverlayUtil.renderTextLocation((Graphics2D)graphics, (Point)textLocation, (String)chatMessage, (Color)JagexColors.YELLOW_INTERFACE_TEXT);
            }
        }
        return null;
    }
}

