/*
 * Decompiled with CFR 0.152.
 */
package com.jebscape.core;

import net.runelite.api.Actor;
import net.runelite.api.Animation;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.Model;
import net.runelite.api.RuneLiteObject;
import net.runelite.api.coords.LocalPoint;
import net.runelite.api.coords.WorldPoint;

public class JebScapeActor {
    private Client client;
    private RuneLiteObject rlObject;
    private int world;
    private int plane;
    private String actorName;
    private String overheadText;
    private String chatMessage;
    private static final int MAX_CHAT_MESSAGE_TIME = 6;
    private int remainingOverheadChatMessageTime;
    private static final int MAX_TARGET_QUEUE_SIZE = 10;
    private final Target[] targetQueue = new Target[10];
    private int currentTargetIndex;
    private int targetQueueSize;
    private int currentMovementSpeed;
    private int currentAnimationID;
    private int animationStall;
    private static final int[][] BLOCKING_DIRECTIONS_5x5 = new int[][]{{16, 16, 32, 64, 64}, {16, 16, 32, 64, 64}, {8, 8, 0, 128, 128}, {4, 4, 2, 1, 1}, {4, 4, 2, 1, 1}};
    private static final int[][] JAU_DIRECTIONS_5X5 = new int[][]{{768, 768, 1024, 1280, 1280}, {768, 768, 1024, 1280, 1280}, {512, 512, 0, 1536, 1536}, {256, 256, 0, 1792, 1792}, {256, 256, 0, 1792, 1792}};
    private static final int CENTER_INDEX_5X5 = 2;
    Animation[] animationPoses = new Animation[8];

    public void init(Client client) {
        this.client = client;
        this.rlObject = client.createRuneLiteObject();
        for (int i = 0; i < 10; ++i) {
            this.targetQueue[i] = new Target();
        }
    }

    public void setModel(Model model) {
        this.rlObject.setModel(model);
    }

    public void spawn(WorldPoint position, int jauOrientation) {
        LocalPoint localPosition = LocalPoint.fromWorld((Client)this.client, (WorldPoint)position);
        if (localPosition == null || this.client.getPlane() != position.getPlane()) {
            return;
        }
        this.rlObject.setLocation(localPosition, position.getPlane());
        this.rlObject.setOrientation(jauOrientation);
        this.rlObject.setAnimation(null);
        this.rlObject.setShouldLoop(true);
        this.rlObject.setActive(true);
        this.plane = position.getPlane();
        this.currentAnimationID = -1;
        this.currentMovementSpeed = 0;
        this.currentTargetIndex = 0;
        this.targetQueueSize = 0;
        this.remainingOverheadChatMessageTime = 0;
    }

    public void despawn() {
        this.rlObject.setActive(false);
        this.overheadText = "";
        this.actorName = "";
        this.chatMessage = "";
        this.remainingOverheadChatMessageTime = 0;
        this.world = 0;
        this.plane = 0;
        this.currentAnimationID = -1;
        this.currentMovementSpeed = 0;
        this.currentTargetIndex = 0;
        this.targetQueueSize = 0;
    }

    public void setPoseAnimations(Actor actor) {
        this.animationPoses[POSE_ANIM.IDLE.ordinal()] = this.client.loadAnimation(actor.getIdlePoseAnimation());
        this.animationPoses[POSE_ANIM.WALK.ordinal()] = this.client.loadAnimation(actor.getWalkAnimation());
        this.animationPoses[POSE_ANIM.RUN.ordinal()] = this.client.loadAnimation(actor.getRunAnimation());
        this.animationPoses[POSE_ANIM.WALK_ROTATE_180.ordinal()] = this.client.loadAnimation(actor.getWalkRotate180());
        this.animationPoses[POSE_ANIM.WALK_STRAFE_LEFT.ordinal()] = this.client.loadAnimation(actor.getWalkRotateLeft());
        this.animationPoses[POSE_ANIM.WALK_STRAFE_RIGHT.ordinal()] = this.client.loadAnimation(actor.getWalkRotateRight());
        this.animationPoses[POSE_ANIM.IDLE_ROTATE_LEFT.ordinal()] = this.client.loadAnimation(actor.getIdleRotateLeft());
        this.animationPoses[POSE_ANIM.IDLE_ROTATE_RIGHT.ordinal()] = this.client.loadAnimation(actor.getIdleRotateRight());
    }

    public WorldPoint getWorldLocation() {
        return this.targetQueueSize > 0 ? this.targetQueue[this.currentTargetIndex].worldDestinationPosition : WorldPoint.fromLocal((Client)this.client, (LocalPoint)this.rlObject.getLocation());
    }

    public LocalPoint getLocalLocation() {
        return this.rlObject.getLocation();
    }

    public boolean isActive() {
        return this.rlObject.isActive();
    }

    public void setWorld(int world) {
        this.world = world;
    }

    public int getWorld() {
        return this.world;
    }

    public void setName(String name) {
        this.actorName = name;
        this.overheadText = this.world != 0 ? "[W" + this.world + "] " : "";
        this.overheadText = this.overheadText + name;
    }

    public String getName() {
        return this.actorName;
    }

    public String getOverheadText() {
        return this.overheadText;
    }

    public void setChatMessage(String chatMessage) {
        this.chatMessage = chatMessage;
        this.remainingOverheadChatMessageTime = 6;
        this.client.addChatMessage(ChatMessageType.PUBLICCHAT, this.actorName, chatMessage, null);
    }

    public String getChatMessage() {
        return this.chatMessage;
    }

    public void moveTo(WorldPoint worldPosition, int jauOrientation, int primaryAnimationID, boolean isInteracting, boolean isPoseAnimation, boolean isInstanced) {
        WorldPoint prevWorldPosition;
        int distance;
        if (!this.rlObject.isActive()) {
            this.spawn(worldPosition, jauOrientation);
            if (!this.rlObject.isActive()) {
                return;
            }
        }
        if (this.targetQueueSize >= 8) {
            this.targetQueueSize = 0;
        }
        int prevTargetIndex = (this.currentTargetIndex + this.targetQueueSize - 1) % 10;
        int newTargetIndex = (this.currentTargetIndex + this.targetQueueSize) % 10;
        LocalPoint localPosition = LocalPoint.fromWorld((Client)this.client, (WorldPoint)worldPosition);
        if (localPosition == null) {
            return;
        }
        if ((distance = (prevWorldPosition = this.targetQueueSize++ > 0 ? this.targetQueue[prevTargetIndex].worldDestinationPosition : WorldPoint.fromLocal((Client)this.client, (LocalPoint)this.rlObject.getLocation())).distanceTo(worldPosition)) > 0 && distance <= 2) {
            int[][] colliders;
            int dx = worldPosition.getX() - prevWorldPosition.getX();
            int dy = worldPosition.getY() - prevWorldPosition.getY();
            boolean useMidPointTile = false;
            if (distance == 1 && dx != 0 && dy != 0) {
                colliders = this.client.getCollisionMaps()[worldPosition.getPlane()].getFlags();
                int diagonalTest = BLOCKING_DIRECTIONS_5x5[2 - dy][2 + dx];
                int axisXTest = BLOCKING_DIRECTIONS_5x5[2][2 + dx] | BLOCKING_DIRECTIONS_5x5[2 + dy][2] | 0x240100;
                int axisYTest = BLOCKING_DIRECTIONS_5x5[2 - dy][2] | BLOCKING_DIRECTIONS_5x5[2][2 - dx] | 0x240100;
                int diagonalFlag = colliders[localPosition.getSceneX()][localPosition.getSceneY()];
                int axisXFlag = colliders[localPosition.getSceneX()][localPosition.getSceneY() - dy];
                int axisYFlag = colliders[localPosition.getSceneX() - dx][localPosition.getSceneY()];
                if ((axisXFlag & axisXTest) != 0 || (axisYFlag & axisYTest) != 0 || (diagonalFlag & diagonalTest) != 0) {
                    useMidPointTile = true;
                    distance = 2;
                    if ((axisXFlag & axisXTest) == 0) {
                        dy = 0;
                    } else {
                        dx = 0;
                    }
                }
            } else if (distance == 2 && Math.abs(Math.abs(dy) - Math.abs(dx)) == 1) {
                useMidPointTile = true;
                colliders = this.client.getCollisionMaps()[worldPosition.getPlane()].getFlags();
                int diagonalTest = BLOCKING_DIRECTIONS_5x5[2 - dy][2 + dx];
                int axisXTest = BLOCKING_DIRECTIONS_5x5[2][2 + dx] | BLOCKING_DIRECTIONS_5x5[2 + dy][2] | 0x240100;
                int axisYTest = BLOCKING_DIRECTIONS_5x5[2 - dy][2] | BLOCKING_DIRECTIONS_5x5[2][2 - dx] | 0x240100;
                int dxSign = Integer.signum(dx);
                int dySign = Integer.signum(dy);
                int diagonalFlag = colliders[localPosition.getSceneX()][localPosition.getSceneY()];
                int axisXFlag = colliders[localPosition.getSceneX()][localPosition.getSceneY() - Integer.signum(dySign)];
                int axisYFlag = colliders[localPosition.getSceneX() - Integer.signum(dxSign)][localPosition.getSceneY()];
                if ((axisXFlag & axisXTest) == 0 && (axisYFlag & axisYTest) == 0 && (diagonalFlag & diagonalTest) == 0) {
                    if (Math.abs(dx) == 2) {
                        dx = dxSign;
                        dy = 0;
                    } else {
                        dx = 0;
                        dy = dySign;
                    }
                } else if (Math.abs(dx) == 2) {
                    dx = dxSign;
                } else {
                    dy = dySign;
                }
            }
            if (useMidPointTile) {
                WorldPoint midPoint = new WorldPoint(prevWorldPosition.getX() + dx, prevWorldPosition.getY() + dy, prevWorldPosition.getPlane());
                if (!isInteracting) {
                    dx = midPoint.getX() - prevWorldPosition.getX();
                    dy = midPoint.getY() - prevWorldPosition.getY();
                    jauOrientation = JAU_DIRECTIONS_5X5[2 - dy][2 + dx];
                }
                this.targetQueue[newTargetIndex].worldDestinationPosition = midPoint;
                this.targetQueue[newTargetIndex].localDestinationPosition = LocalPoint.fromWorld((Client)this.client, (WorldPoint)midPoint);
                this.targetQueue[newTargetIndex].tileMovementSpeed = distance;
                this.targetQueue[newTargetIndex].jauDestinationOrientation = jauOrientation;
                this.targetQueue[newTargetIndex].primaryAnimationID = primaryAnimationID;
                this.targetQueue[newTargetIndex].isPoseAnimation = isPoseAnimation;
                this.targetQueue[newTargetIndex].isInteracting = isInteracting;
                this.targetQueue[newTargetIndex].isMidPoint = true;
                this.targetQueue[newTargetIndex].isInstanced = isInstanced;
                newTargetIndex = (this.currentTargetIndex + this.targetQueueSize++) % 10;
                prevWorldPosition = midPoint;
            }
            if (!isInteracting) {
                dx = worldPosition.getX() - prevWorldPosition.getX();
                dy = worldPosition.getY() - prevWorldPosition.getY();
                jauOrientation = JAU_DIRECTIONS_5X5[2 - dy][2 + dx];
            }
        }
        this.targetQueue[newTargetIndex].worldDestinationPosition = worldPosition;
        this.targetQueue[newTargetIndex].localDestinationPosition = localPosition;
        this.targetQueue[newTargetIndex].tileMovementSpeed = distance;
        this.targetQueue[newTargetIndex].jauDestinationOrientation = jauOrientation;
        this.targetQueue[newTargetIndex].primaryAnimationID = primaryAnimationID;
        this.targetQueue[newTargetIndex].isInteracting = isInteracting;
        this.targetQueue[newTargetIndex].isPoseAnimation = isPoseAnimation;
        this.targetQueue[newTargetIndex].isMidPoint = false;
        this.targetQueue[newTargetIndex].isInstanced = isInstanced;
        if (this.remainingOverheadChatMessageTime > 0) {
            --this.remainingOverheadChatMessageTime;
            if (this.remainingOverheadChatMessageTime == 0 && !this.chatMessage.isEmpty()) {
                this.chatMessage = "";
            }
        }
    }

    public boolean onClientTick() {
        if (this.rlObject.isActive()) {
            if (this.targetQueueSize > 0) {
                int targetPlane = this.targetQueue[this.currentTargetIndex].worldDestinationPosition.getPlane();
                LocalPoint targetPosition = this.targetQueue[this.currentTargetIndex].localDestinationPosition;
                int targetOrientation = this.targetQueue[this.currentTargetIndex].jauDestinationOrientation;
                if (this.client.getPlane() != targetPlane || this.plane != targetPlane || targetPosition == null || !targetPosition.isInScene() || targetOrientation < 0) {
                    this.despawn();
                    return false;
                }
                int animationID = this.targetQueue[this.currentTargetIndex].primaryAnimationID;
                if (!this.targetQueue[this.currentTargetIndex].isPoseAnimation && this.currentAnimationID != animationID) {
                    this.rlObject.setAnimation(this.client.loadAnimation(animationID));
                    this.currentAnimationID = animationID;
                } else if (this.targetQueue[this.currentTargetIndex].isPoseAnimation && (this.currentAnimationID != -1 || this.currentMovementSpeed != this.targetQueue[this.currentTargetIndex].tileMovementSpeed)) {
                    int speed = this.targetQueue[this.currentTargetIndex].tileMovementSpeed;
                    this.rlObject.setAnimation(speed > 2 ? null : this.animationPoses[speed]);
                    this.currentAnimationID = -1;
                }
                this.currentMovementSpeed = this.targetQueue[this.currentTargetIndex].tileMovementSpeed;
                LocalPoint currentPosition = this.rlObject.getLocation();
                int currentOrientation = this.rlObject.getOrientation();
                int dx = targetPosition.getX() - currentPosition.getX();
                int dy = targetPosition.getY() - currentPosition.getY();
                if (dx != 0 || dy != 0) {
                    int movementPerClientTick = 4;
                    if (currentOrientation != targetOrientation && !this.targetQueue[this.currentTargetIndex].isInteracting) {
                        movementPerClientTick = 2;
                    }
                    if (this.targetQueueSize > 2) {
                        movementPerClientTick = 6;
                    }
                    if (this.targetQueueSize > 3) {
                        movementPerClientTick = 8;
                    }
                    if (this.animationStall > 0 && this.targetQueueSize > 1) {
                        movementPerClientTick = 8;
                        --this.animationStall;
                    }
                    if (this.animationStall == 0) {
                        int speed = this.currentMovementSpeed * movementPerClientTick;
                        if (speed > 0) {
                            if (Math.abs(dx) > speed) {
                                dx = Integer.signum(dx) * speed;
                            }
                            if (Math.abs(dy) > speed) {
                                dy = Integer.signum(dy) * speed;
                            }
                        }
                        LocalPoint newLocation = new LocalPoint(currentPosition.getX() + dx, currentPosition.getY() + dy);
                        this.rlObject.setLocation(newLocation, targetPlane);
                    }
                    currentPosition = this.rlObject.getLocation();
                    dx = targetPosition.getX() - currentPosition.getX();
                    dy = targetPosition.getY() - currentPosition.getY();
                }
                int JAU_FULL_ROTATION = 2048;
                int dJau = (targetOrientation - currentOrientation) % 2048;
                if (dJau != 0) {
                    int JAU_HALF_ROTATION = 1024;
                    int JAU_TURN_SPEED = 32;
                    int dJauCW = Math.abs(dJau);
                    if (dJauCW > 1024) {
                        dJau = (currentOrientation - targetOrientation) % 2048;
                    } else if (dJauCW == 1024) {
                        dJau = dJauCW;
                    }
                    if (Math.abs(dJau) > 32) {
                        dJau = Integer.signum(dJau) * 32;
                    }
                    int newOrientation = (2048 + this.rlObject.getOrientation() + dJau) % 2048;
                    this.rlObject.setOrientation(newOrientation);
                    dJau = (targetOrientation - newOrientation) % 2048;
                }
                if (dx == 0 && dy == 0 && dJau == 0) {
                    this.currentTargetIndex = (this.currentTargetIndex + 1) % 10;
                    --this.targetQueueSize;
                }
            }
            return true;
        }
        return false;
    }

    private static enum POSE_ANIM {
        IDLE,
        WALK,
        RUN,
        WALK_ROTATE_180,
        WALK_STRAFE_LEFT,
        WALK_STRAFE_RIGHT,
        IDLE_ROTATE_LEFT,
        IDLE_ROTATE_RIGHT;

    }

    private static class Target {
        public WorldPoint worldDestinationPosition;
        public LocalPoint localDestinationPosition;
        public int tileMovementSpeed;
        public int jauDestinationOrientation;
        public int primaryAnimationID;
        public boolean isPoseAnimation;
        public boolean isInteracting;
        public boolean isMidPoint;
        public boolean isInstanced;

        private Target() {
        }
    }
}

