/*
 * Decompiled with CFR 0.152.
 */
package com.jebscape.core;

import com.jebscape.core.JebScapePlugin;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.event.MouseEvent;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.Point;
import net.runelite.client.input.MouseListener;
import net.runelite.client.input.MouseManager;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.OverlayPriority;
import net.runelite.client.ui.overlay.components.PanelComponent;
import net.runelite.client.ui.overlay.components.TitleComponent;
import net.runelite.client.ui.overlay.tooltip.Tooltip;
import net.runelite.client.ui.overlay.tooltip.TooltipManager;
import org.apache.commons.lang3.StringUtils;

public class JebScapeAccountKeyOverlay
extends Overlay
implements MouseListener {
    private Client client;
    private JebScapePlugin plugin;
    @Inject
    private TooltipManager tooltipManager;
    @Inject
    MouseManager mouseManager;
    private final Color color = new Color(5, 248, 242, 218);
    private final Tooltip tooltip = new Tooltip("Paste Account Key");
    private final Dimension dimension = new Dimension(290, 25);
    private final PanelComponent panelComponent = new PanelComponent();
    private boolean isVisible;
    private int invalidCount;

    public void init(Client client, JebScapePlugin plugin) {
        this.client = client;
        this.plugin = plugin;
        this.isVisible = false;
        this.invalidCount = 0;
        this.setPosition(OverlayPosition.ABOVE_CHATBOX_RIGHT);
        this.setPriority(OverlayPriority.HIGHEST);
        this.setLayer(OverlayLayer.ALWAYS_ON_TOP);
        this.setMovable(false);
        this.mouseManager.registerMouseListener((MouseListener)this);
        this.panelComponent.getChildren().clear();
        this.panelComponent.setPreferredSize(this.dimension);
        this.panelComponent.getChildren().add(TitleComponent.builder().text("Click here to paste your JebScape account key.").color(this.color).build());
    }

    public void cleanup() {
        this.mouseManager.unregisterMouseListener((MouseListener)this);
    }

    public void hide() {
        this.isVisible = false;
    }

    public void show() {
        this.isVisible = true;
        this.invalidCount = 0;
    }

    public Dimension render(Graphics2D graphics) {
        if (this.isVisible) {
            Point mousePosition;
            Rectangle bounds = this.getBounds();
            if (bounds.contains((mousePosition = this.client.getMouseCanvasPosition()).getX(), mousePosition.getY())) {
                this.tooltipManager.add(this.tooltip);
            }
            return this.panelComponent.render(graphics);
        }
        return null;
    }

    public MouseEvent mouseClicked(MouseEvent mouseEvent) {
        Point mousePosition;
        Rectangle bounds;
        if (this.isVisible && (bounds = this.getBounds()).contains((mousePosition = this.client.getMouseCanvasPosition()).getX(), mousePosition.getY())) {
            boolean validInput = false;
            try {
                Long key;
                String strippedText;
                Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                String pastedText = (String)clipboard.getData(DataFlavor.stringFlavor);
                if (pastedText != null && (strippedText = StringUtils.left((String)pastedText.replaceAll("[^0-9]", ""), (int)20)).length() > 0 && (key = Long.valueOf(Long.parseUnsignedLong(strippedText))) != null) {
                    validInput = true;
                    this.plugin.setRSProfileAccountKey(key);
                    this.hide();
                    this.invalidCount = 0;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (!validInput) {
                ++this.invalidCount;
                if (this.invalidCount < 3) {
                    this.plugin.addGameMessage("Invalid account key format. Copy your account key from jebscape.com and try again.");
                } else {
                    this.plugin.addGameMessage("Third invalid login attempt. Please try again later.");
                    this.hide();
                }
            }
            mouseEvent.consume();
        }
        return mouseEvent;
    }

    public MouseEvent mousePressed(MouseEvent mouseEvent) {
        Point mousePosition;
        Rectangle bounds;
        if (this.isVisible && (bounds = this.getBounds()).contains((mousePosition = this.client.getMouseCanvasPosition()).getX(), mousePosition.getY())) {
            mouseEvent.consume();
        }
        return mouseEvent;
    }

    public MouseEvent mouseReleased(MouseEvent mouseEvent) {
        Point mousePosition;
        Rectangle bounds = this.getBounds();
        if (bounds.contains((mousePosition = this.client.getMouseCanvasPosition()).getX(), mousePosition.getY())) {
            mouseEvent.consume();
        }
        return mouseEvent;
    }

    public MouseEvent mouseDragged(MouseEvent mouseEvent) {
        return mouseEvent;
    }

    public MouseEvent mouseMoved(MouseEvent mouseEvent) {
        return mouseEvent;
    }

    public MouseEvent mouseEntered(MouseEvent mouseEvent) {
        return mouseEvent;
    }

    public MouseEvent mouseExited(MouseEvent mouseEvent) {
        return mouseEvent;
    }
}

