/*
 * Decompiled with CFR 0.152.
 */
package io.github.zeroone3010.yahueapi.discovery;

import io.github.zeroone3010.yahueapi.HueBridge;
import io.github.zeroone3010.yahueapi.discovery.DiscoverState;
import io.github.zeroone3010.yahueapi.discovery.HueBridgeDiscoverer;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.logging.Logger;

final class UPnPDiscoverer
implements HueBridgeDiscoverer {
    private static final Logger logger = Logger.getLogger("UPnPDiscoverer");
    private static final int DISCOVERY_MESSAGE_COUNT = 5;
    private static final int DEFAULT_PORT = 1900;
    private static final long MILLISECONDS_BETWEEN_DISCOVERY_MESSAGES = 950L;
    private final InetAddress multicastAddress;
    private MulticastSocket socket;
    private ScheduledExecutorService scheduledExecutorService;
    private ScheduledFuture requestSendTask;
    private final DatagramPacket requestPacket;
    private DiscoverState state = DiscoverState.IDLE;
    private final Consumer<HueBridge> discoverer;
    private final int port;

    UPnPDiscoverer(Consumer<HueBridge> discoverer) {
        this("239.255.255.250", discoverer, 1900);
    }

    UPnPDiscoverer(String multicastAddressm, Consumer<HueBridge> discoverer, int port) {
        this.discoverer = discoverer;
        this.port = port;
        try {
            this.multicastAddress = InetAddress.getByName(multicastAddressm);
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        this.requestPacket = this.createRequestPacket();
    }

    @Override
    public CompletableFuture<Void> discoverBridges() {
        return CompletableFuture.supplyAsync(this::lambda$discoverBridges$0);
    }

    private void startSocket() {
        if (this.state == DiscoverState.IDLE) {
            try {
                this.socket = new MulticastSocket();
                TimeUnit.MILLISECONDS.sleep(100L);
                this.state = DiscoverState.SEARCHING;
            }
            catch (Exception e) {
                this.state = DiscoverState.CRASHED;
                e.printStackTrace();
            }
        }
    }

    private void scheduleMessages() {
        if (this.state == DiscoverState.SEARCHING) {
            this.scheduledExecutorService = Executors.newSingleThreadScheduledExecutor();
            this.requestSendTask = this.scheduledExecutorService.schedule(() -> {
                try {
                    for (int i = 0; i < 5; ++i) {
                        logger.fine("Sending a discovery message");
                        this.socket.send(this.requestPacket);
                        TimeUnit.MILLISECONDS.sleep(950L);
                    }
                }
                catch (IOException | InterruptedException e) {
                    this.state = DiscoverState.CRASHED;
                    e.printStackTrace();
                }
                finally {
                    this.stop();
                }
            }, 0L, TimeUnit.SECONDS);
        }
    }

    private void stop() {
        logger.info("UPnP discoverer stopped");
        this.state = DiscoverState.STOPPED;
        if (this.requestSendTask != null) {
            this.scheduledExecutorService.shutdown();
        }
        if (this.socket != null) {
            this.socket.close();
        }
    }

    private void packetHandler(DatagramPacket packet) {
        String data = new String(packet.getData());
        if (data.contains("IpBridge")) {
            int startIndex = data.indexOf("http://");
            int endIndex = data.indexOf("/description.xml");
            if (startIndex != -1 && endIndex != -1) {
                String ip = data.substring(startIndex + 7, endIndex);
                int portIndex = ip.indexOf(58);
                if (portIndex > -1) {
                    ip = ip.substring(0, portIndex);
                }
                this.discoverer.accept(new HueBridge(ip));
            }
        }
    }

    private DatagramPacket createRequestPacket() {
        StringBuilder sb = new StringBuilder("M-SEARCH * HTTP/1.1\r\n").append("HOST: ").append(this.multicastAddress.getHostAddress()).append(':').append(this.port).append("\r\n").append("MAN: \"ssdp:discover\"\r\n").append("MX: 3\r\n").append("USER-AGENT: Yet Another Hue API\r\n").append("ST: ssdp:all\r\n");
        byte[] content = sb.toString().getBytes(StandardCharsets.UTF_8);
        return new DatagramPacket(content, content.length, this.multicastAddress, this.port);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private /* synthetic */ Void lambda$discoverBridges$0() {
        try {
            this.startSocket();
            this.scheduleMessages();
            if (this.state == DiscoverState.IDLE) {
                this.state = DiscoverState.SEARCHING;
            }
            UPnPDiscoverer.logger.info("UPnP discoverer started");
            while (this.state == DiscoverState.SEARCHING) {
                buffer = new byte[8192];
                packet = new DatagramPacket(buffer, buffer.length);
                try {
                    this.socket.receive(packet);
                    ** GOTO lbl20
                }
                catch (IOException e) {
                    if (this.state == DiscoverState.STOPPED) {
                        var4_4 = null;
                        this.stop();
                        return var4_4;
                    }
                    try {
                        e.printStackTrace();
lbl20:
                        // 2 sources

                        this.packetHandler(packet);
                    }
                    catch (Throwable var5_5) {
                        throw var5_5;
                        return null;
                    }
                }
            }
        }
        finally {
            this.stop();
        }
    }
}

