/*
 * Decompiled with CFR 0.152.
 */
package io.github.zeroone3010.yahueapi.discovery;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.github.zeroone3010.yahueapi.HueBridge;
import io.github.zeroone3010.yahueapi.discovery.HueBridgeDiscoverer;
import io.github.zeroone3010.yahueapi.discovery.NUPnPDiscoverer;
import io.github.zeroone3010.yahueapi.discovery.UPnPDiscoverer;
import io.github.zeroone3010.yahueapi.domain.BridgeConfig;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.logging.Logger;
import java.util.stream.Stream;

public final class HueBridgeDiscoveryService {
    private static final Logger logger = Logger.getLogger("HueBridgeDiscoveryService");

    public Future<List<HueBridge>> discoverBridges(Consumer<HueBridge> bridgeDiscoverer, DiscoveryMethod ... discoveryMethods) {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        HashSet bridges = new HashSet();
        HashSet ips = new HashSet();
        Consumer<HueBridge> commonConsumer = discoveredBridge -> {
            BridgeConfig config;
            boolean added;
            String ip = discoveredBridge.getIp();
            Collection collection = ips;
            synchronized (collection) {
                added = ips.add(ip);
            }
            if (added && (config = this.fetchBridgeConfiguration(objectMapper, ip)) != null) {
                HueBridge confirmedBridge = new HueBridge(ip, config.getName(), config.getMac());
                Collection collection2 = bridges;
                synchronized (collection2) {
                    bridges.add(confirmedBridge);
                }
                bridgeDiscoverer.accept(confirmedBridge);
            }
        };
        List<DiscoveryMethod> methods = this.parseMethods(discoveryMethods);
        CompletableFuture[] futures = (CompletableFuture[])methods.stream().map(DiscoveryMethod::getDiscovererCreator).map(creator -> (HueBridgeDiscoverer)creator.apply(commonConsumer)).map(HueBridgeDiscoverer::discoverBridges).toArray(CompletableFuture[]::new);
        return CompletableFuture.allOf(futures).thenApply(allDone -> new ArrayList(bridges));
    }

    private BridgeConfig fetchBridgeConfiguration(ObjectMapper objectMapper, String ip) {
        try {
            return objectMapper.readValue(new URL("http://" + ip + "/api/config"), BridgeConfig.class);
        }
        catch (IOException e) {
            logger.severe("Unable to connect to a found Bridge at " + ip + ": " + e);
            return null;
        }
    }

    private List<DiscoveryMethod> parseMethods(DiscoveryMethod[] discoveryMethods) {
        ArrayList<DiscoveryMethod> methods = new ArrayList<DiscoveryMethod>();
        if (discoveryMethods == null || discoveryMethods.length == 0 || Stream.of(discoveryMethods).allMatch(Objects::isNull)) {
            methods.addAll(Arrays.asList(DiscoveryMethod.values()));
        } else {
            Stream.of(discoveryMethods).filter(Objects::nonNull).forEach(methods::add);
        }
        return methods;
    }

    public static enum DiscoveryMethod {
        NUPNP(NUPnPDiscoverer::new),
        UPNP(UPnPDiscoverer::new);

        private final Function<Consumer<HueBridge>, HueBridgeDiscoverer> discovererCreator;

        private DiscoveryMethod(Function<Consumer<HueBridge>, HueBridgeDiscoverer> discovererCreator) {
            this.discovererCreator = discovererCreator;
        }

        Function<Consumer<HueBridge>, HueBridgeDiscoverer> getDiscovererCreator() {
            return this.discovererCreator;
        }
    }
}

