/*
 * Decompiled with CFR 0.152.
 */
package io.github.zeroone3010.yahueapi;

import io.github.zeroone3010.yahueapi.BasicSensor;
import io.github.zeroone3010.yahueapi.TemperatureSensor;
import io.github.zeroone3010.yahueapi.domain.SensorDto;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.net.URL;
import java.util.Map;
import java.util.function.Supplier;
import java.util.logging.Logger;

final class TemperatureSensorImpl
extends BasicSensor
implements TemperatureSensor {
    private static final Logger logger = Logger.getLogger("TemperatureSensorImpl");

    TemperatureSensorImpl(String id, SensorDto sensor, URL url, Supplier<Map<String, Object>> stateProvider) {
        super(id, sensor, url, stateProvider);
    }

    @Override
    public String toString() {
        return "TemperatureSensor{id='" + this.id + '\'' + ", name='" + this.name + '\'' + ", type=" + (Object)((Object)this.type) + '}';
    }

    @Override
    public BigDecimal getDegreesCelsius() {
        return TemperatureSensorImpl.convertCenticelsiusToCelsius(this.readStateValue("temperature", Integer.class));
    }

    private static BigDecimal convertCenticelsiusToCelsius(int centicelsius) {
        return BigDecimal.valueOf(centicelsius).divide(BigDecimal.valueOf(100L), 2, RoundingMode.HALF_UP);
    }
}

