/*
 * Decompiled with CFR 0.152.
 */
package io.github.zeroone3010.yahueapi;

import io.github.zeroone3010.yahueapi.BasicSensor;
import io.github.zeroone3010.yahueapi.Button;
import io.github.zeroone3010.yahueapi.ButtonEvent;
import io.github.zeroone3010.yahueapi.ButtonImpl;
import io.github.zeroone3010.yahueapi.Switch;
import io.github.zeroone3010.yahueapi.SwitchEvent;
import io.github.zeroone3010.yahueapi.domain.SensorCapabilities;
import io.github.zeroone3010.yahueapi.domain.SensorDto;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Collectors;

final class SwitchImpl
extends BasicSensor
implements Switch {
    private final List<Button> buttons;
    private final Map<Integer, Button> eventCodeToButton = new HashMap<Integer, Button>();

    SwitchImpl(String id, SensorDto sensor, URL url, Supplier<Map<String, Object>> stateProvider) {
        super(id, sensor, url, stateProvider);
        this.buttons = SwitchImpl.parseButtonsFromInputs(sensor.getCapabilities());
        this.buttons.forEach(button -> button.getPossibleEvents().forEach(event -> this.eventCodeToButton.put(event.getEventCode(), (Button)button)));
    }

    private static List<Button> parseButtonsFromInputs(SensorCapabilities capabilities) {
        if (capabilities == null || capabilities.getInputs() == null || capabilities.getInputs().isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<ButtonImpl> buttonList = new ArrayList<ButtonImpl>();
        for (int buttonIndex = 0; buttonIndex < capabilities.getInputs().size(); ++buttonIndex) {
            List<ButtonEvent> possibleEvents = capabilities.getInputs().get(buttonIndex).getEvents().stream().map(event -> new ButtonEvent(ButtonEvent.ButtonEventType.parseFromButtonEventType(event.getEventType()), event.getButtonEvent())).collect(Collectors.toList());
            buttonList.add(new ButtonImpl(buttonIndex + 1, possibleEvents));
        }
        return Collections.unmodifiableList(buttonList);
    }

    @Override
    public List<Button> getButtons() {
        return this.buttons;
    }

    @Override
    public String toString() {
        return "Switch{id='" + this.id + '\'' + ", name='" + this.name + '\'' + ", type=" + (Object)((Object)this.type) + '}';
    }

    @Override
    public SwitchEvent getLatestEvent() {
        Integer eventCode = this.readStateValue("buttonevent", Integer.class);
        Button button = this.eventCodeToButton.getOrDefault(eventCode, ButtonImpl.UNKNOWN);
        ButtonEvent.ButtonEventType eventType = button.getPossibleEvents().stream().filter(event -> Objects.equals(event.getEventCode(), eventCode)).findFirst().map(ButtonEvent::getEventType).orElse(ButtonEvent.ButtonEventType.UNKNOWN);
        ButtonEvent event2 = new ButtonEvent(eventType, eventCode);
        return new SwitchEvent(button, event2);
    }
}

