/*
 * Decompiled with CFR 0.152.
 */
package io.github.zeroone3010.yahueapi;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.github.zeroone3010.yahueapi.AlertType;
import io.github.zeroone3010.yahueapi.Color;
import io.github.zeroone3010.yahueapi.EffectType;
import io.github.zeroone3010.yahueapi.HueApiException;
import io.github.zeroone3010.yahueapi.MathUtil;
import io.github.zeroone3010.yahueapi.StateBuilderSteps;
import io.github.zeroone3010.yahueapi.domain.LightState;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.logging.Logger;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public final class State {
    private static final Logger logger = Logger.getLogger("State");
    private static final int DIMMABLE_LIGHT_COLOR_TEMPERATURE = 370;
    public static final State SHORT_ALERT = new State(AlertType.SHORT_ALERT);
    public static final State LONG_ALERT = new State(AlertType.LONG_ALERT);
    public static final State NO_ALERT = new State(AlertType.NONE);
    public static final State COLOR_LOOP_EFFECT = new State(EffectType.COLOR_LOOP);
    public static final State NO_EFFECTS = new State(EffectType.NONE);
    private final Boolean on;
    private final Integer hue;
    private final Integer sat;
    private final Integer bri;
    private final Integer ct;
    private final Integer transitiontime;
    private final List<Float> xy;
    private final String scene;
    private final AlertType alert;
    private final EffectType effect;

    private State(Builder builder) {
        this.on = builder.on;
        this.bri = builder.bri;
        this.xy = builder.xy;
        this.hue = builder.hue;
        this.sat = builder.sat;
        this.ct = builder.ct;
        this.transitiontime = builder.transitionTime;
        this.scene = builder.scene;
        this.alert = builder.alert;
        this.effect = builder.effect;
    }

    State(AlertType alertType) {
        this.on = null;
        this.bri = null;
        this.xy = null;
        this.hue = null;
        this.sat = null;
        this.ct = null;
        this.transitiontime = null;
        this.scene = null;
        this.alert = alertType;
        this.effect = null;
    }

    State(EffectType effect) {
        this.on = null;
        this.bri = null;
        this.xy = null;
        this.hue = null;
        this.sat = null;
        this.ct = null;
        this.transitiontime = null;
        this.scene = null;
        this.alert = null;
        this.effect = effect;
    }

    public Boolean getOn() {
        return this.on;
    }

    public Integer getBri() {
        return this.bri;
    }

    public List<Float> getXy() {
        return this.xy;
    }

    public Integer getHue() {
        return this.hue;
    }

    public Integer getSat() {
        return this.sat;
    }

    public Integer getCt() {
        return this.ct;
    }

    public Integer getTransitiontime() {
        return this.transitiontime;
    }

    public String getScene() {
        return this.scene;
    }

    public AlertType getAlert() {
        return this.alert;
    }

    public EffectType getEffect() {
        return this.effect;
    }

    public static StateBuilderSteps.InitialStep builder() {
        return new Builder();
    }

    static State build(LightState state) {
        logger.fine(state.toString());
        Builder builder = new Builder(AlertType.parseTypeString(state.getAlert()));
        if (state.getColorMode() == null) {
            return builder.colorTemperatureInMireks(370).brightness(state.getBrightness()).on(state.isOn());
        }
        switch (state.getColorMode()) {
            case "xy": {
                return builder.xy(state.getXy()).brightness(state.getBrightness()).on(state.isOn());
            }
            case "ct": {
                return builder.colorTemperatureInMireks(state.getCt()).brightness(state.getBrightness()).on(state.isOn());
            }
            case "hs": {
                return builder.hue(state.getHue()).saturation(state.getSaturation()).brightness(state.getBrightness()).on(state.isOn());
            }
        }
        throw new HueApiException("Unknown color mode '" + state.getColorMode() + "'.");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        State state = (State)o;
        return Objects.equals(this.on, state.on) && Objects.equals(this.hue, state.hue) && Objects.equals(this.sat, state.sat) && Objects.equals(this.bri, state.bri) && Objects.equals(this.ct, state.ct) && Objects.equals(this.xy, state.xy) && Objects.equals((Object)this.alert, (Object)state.alert) && Objects.equals((Object)this.effect, (Object)state.effect);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.on, this.hue, this.sat, this.bri, this.ct, this.xy, this.alert, this.effect});
    }

    public String toString() {
        return "State{on=" + this.on + ", hue=" + this.hue + ", sat=" + this.sat + ", bri=" + this.bri + ", ct=" + this.ct + ", transitiontime=" + this.transitiontime + ", xy=" + this.xy + ", scene='" + this.scene + '\'' + ", alert=" + (Object)((Object)this.alert) + ", effect=" + (Object)((Object)this.effect) + '}';
    }

    public static final class Builder
    implements StateBuilderSteps.InitialStep,
    StateBuilderSteps.HueStep,
    StateBuilderSteps.SaturationStep,
    StateBuilderSteps.BrightnessStep,
    StateBuilderSteps.XyStep,
    StateBuilderSteps.ColorStep,
    StateBuilderSteps.ColorTemperatureStep,
    StateBuilderSteps.TransitionTimeStep,
    StateBuilderSteps.BuildStep,
    StateBuilderSteps.OnOffStep,
    StateBuilderSteps.AlertStep {
        private Boolean on;
        private Integer hue;
        private Integer sat;
        private Integer bri;
        private Integer ct;
        private Integer transitionTime;
        private List<Float> xy;
        private String scene;
        private AlertType alert;
        private EffectType effect;

        public Builder() {
        }

        Builder(AlertType alert) {
            this.alert = alert;
        }

        Builder(EffectType effect) {
            this.effect = effect;
        }

        @Override
        public StateBuilderSteps.SaturationStep hue(int hue) {
            this.hue = hue;
            return this;
        }

        @Override
        public StateBuilderSteps.BrightnessStep saturation(int saturation) {
            this.sat = saturation;
            return this;
        }

        @Override
        public StateBuilderSteps.BuildStep brightness(int brightness) {
            this.bri = brightness;
            return this;
        }

        @Override
        public StateBuilderSteps.BrightnessStep xy(List<Float> xy) {
            if (xy == null || xy.size() != 2 || !MathUtil.isInRange(xy.get(0), 0.0f, 1.0f) || !MathUtil.isInRange(xy.get(1), 0.0f, 1.0f)) {
                throw new IllegalArgumentException("The xy list must contain exactly 2 values, between 0 and 1.");
            }
            ArrayList<Float> xyValues = new ArrayList<Float>();
            xyValues.addAll(xy);
            this.xy = Collections.unmodifiableList(xyValues);
            return this;
        }

        @Override
        public StateBuilderSteps.BuildStep color(Color color) {
            if (color == null) {
                throw new IllegalArgumentException("Color must not be null");
            }
            XAndYAndBrightness xAndYAndBrightness = Builder.rgbToXy(color);
            this.xy = xAndYAndBrightness.getXY();
            this.bri = xAndYAndBrightness.getBrightness();
            return this;
        }

        @Override
        public StateBuilderSteps.BrightnessStep colorTemperatureInMireks(int colorTemperature) {
            this.ct = colorTemperature;
            return this;
        }

        @Override
        public StateBuilderSteps.OnOffStep transitionTime(int tenths) {
            this.transitionTime = tenths;
            return this;
        }

        @Override
        public State on(Boolean on) {
            this.on = on;
            return this.build();
        }

        @Override
        public StateBuilderSteps.BuildStep scene(String scene) {
            this.scene = scene;
            return this;
        }

        @Override
        public State alert(AlertType alert) {
            return new State(alert);
        }

        @Override
        public State effect(EffectType effect) {
            return new State(effect);
        }

        private State build() {
            return new State(this);
        }

        private static XAndYAndBrightness rgbToXy(Color color) {
            float red = color.getRed();
            float green = color.getGreen();
            float blue = color.getBlue();
            double r = Builder.gammaCorrection(red);
            double g = Builder.gammaCorrection(green);
            double b = Builder.gammaCorrection(blue);
            double rgbX = r * (double)0.664511f + g * (double)0.154324f + b * (double)0.162028f;
            double rgbY = r * (double)0.283881f + g * (double)0.668433f + b * (double)0.047685f;
            double rgbZ = r * (double)8.8E-5f + g * (double)0.07231f + b * (double)0.986039f;
            float x = (float)(rgbX / (rgbX + rgbY + rgbZ));
            float y = (float)(rgbY / (rgbX + rgbY + rgbZ));
            return new XAndYAndBrightness(x, y, (int)(rgbY * 255.0));
        }

        private static double gammaCorrection(float component) {
            return component > 0.04045f ? Math.pow((component + 0.055f) / 1.055f, 2.4f) : (double)(component / 12.92f);
        }
    }

    private static final class XAndYAndBrightness {
        final float x;
        final float y;
        final int brightness;

        XAndYAndBrightness(float x, float y, int brightness) {
            this.x = x;
            this.y = y;
            this.brightness = brightness;
        }

        List<Float> getXY() {
            ArrayList<Float> xyColor = new ArrayList<Float>();
            xyColor.add(Float.valueOf(this.x));
            xyColor.add(Float.valueOf(this.y));
            return xyColor;
        }

        int getBrightness() {
            return this.brightness;
        }

        public String toString() {
            try {
                return new ObjectMapper().writeValueAsString(this);
            }
            catch (JsonProcessingException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

