/*
 * Decompiled with CFR 0.152.
 */
package io.github.zeroone3010.yahueapi;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.github.zeroone3010.yahueapi.AmbientLightSensorImpl;
import io.github.zeroone3010.yahueapi.BasicSensor;
import io.github.zeroone3010.yahueapi.DaylightSensorImpl;
import io.github.zeroone3010.yahueapi.Hue;
import io.github.zeroone3010.yahueapi.HueApiException;
import io.github.zeroone3010.yahueapi.PresenceSensorImpl;
import io.github.zeroone3010.yahueapi.Sensor;
import io.github.zeroone3010.yahueapi.SensorType;
import io.github.zeroone3010.yahueapi.SwitchImpl;
import io.github.zeroone3010.yahueapi.TemperatureSensorImpl;
import io.github.zeroone3010.yahueapi.domain.SensorDto;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import java.util.function.Supplier;

final class SensorFactory {
    private final Hue hue;
    private final ObjectMapper objectMapper;

    SensorFactory(Hue hue, ObjectMapper objectMapper) {
        this.hue = hue;
        this.objectMapper = objectMapper;
    }

    Sensor buildSensor(String id, SensorDto sensor, String bridgeUri) {
        if (sensor == null) {
            throw new HueApiException("Sensor " + id + " cannot be found.");
        }
        URL url = SensorFactory.buildSensorUrl(bridgeUri, id);
        SensorType type = SensorType.parseTypeString(sensor.getType());
        Supplier<Map<String, Object>> stateProvider = this.createStateProvider(url, id);
        switch (type) {
            case PRESENCE: {
                return new PresenceSensorImpl(id, sensor, url, stateProvider);
            }
            case TEMPERATURE: {
                return new TemperatureSensorImpl(id, sensor, url, stateProvider);
            }
            case DAYLIGHT: {
                return new DaylightSensorImpl(id, sensor, url, stateProvider);
            }
            case SWITCH: {
                return new SwitchImpl(id, sensor, url, stateProvider);
            }
            case AMBIENT_LIGHT: {
                return new AmbientLightSensorImpl(id, sensor, url, stateProvider);
            }
        }
        return new BasicSensor(id, sensor, url, stateProvider);
    }

    private Supplier<Map<String, Object>> createStateProvider(URL url, String id) {
        return () -> {
            if (this.hue.isCaching()) {
                return this.hue.getRaw().getSensors().get(id).getState();
            }
            try {
                return this.objectMapper.readValue(url, SensorDto.class).getState();
            }
            catch (IOException e) {
                throw new HueApiException(e);
            }
        };
    }

    private static URL buildSensorUrl(String bridgeUri, String sensorId) {
        try {
            return new URL(bridgeUri + "sensors/" + sensorId);
        }
        catch (MalformedURLException e) {
            throw new HueApiException(e);
        }
    }
}

