/*
 * Decompiled with CFR 0.152.
 */
package io.github.zeroone3010.yahueapi;

import io.github.zeroone3010.yahueapi.GroupType;
import io.github.zeroone3010.yahueapi.Light;
import io.github.zeroone3010.yahueapi.Room;
import io.github.zeroone3010.yahueapi.Scene;
import io.github.zeroone3010.yahueapi.State;
import io.github.zeroone3010.yahueapi.StateBuilderSteps;
import io.github.zeroone3010.yahueapi.domain.Group;
import io.github.zeroone3010.yahueapi.domain.GroupState;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.logging.Logger;

final class RoomImpl
implements Room {
    private static final Logger logger = Logger.getLogger("RoomImpl");
    private final String id;
    private final Set<Light> lights;
    private final Set<Scene> scenes;
    private final String name;
    private final Supplier<GroupState> stateProvider;
    private final Function<State, String> stateSetter;
    private final GroupType groupType;

    RoomImpl(String id, Group group, Set<Light> lights, Set<Scene> scenes, Supplier<GroupState> stateProvider, Function<State, String> stateSetter) {
        this.id = id;
        this.stateProvider = stateProvider;
        this.stateSetter = stateSetter;
        this.lights = lights;
        this.scenes = scenes;
        this.name = group.getName();
        this.groupType = GroupType.parseTypeString(group.getType());
    }

    public String getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Collection<Light> getLights() {
        return this.lights;
    }

    @Override
    public Optional<Light> getLightByName(String lightName) {
        return this.lights.stream().filter(light -> Objects.equals(light.getName(), lightName)).findFirst();
    }

    @Override
    public boolean isAnyOn() {
        return this.getGroupState().isAnyOn();
    }

    @Override
    public boolean isAllOn() {
        return this.getGroupState().isAllOn();
    }

    @Override
    public void turnOn() {
        this.setState(((StateBuilderSteps.OnOffStep)((Object)State.builder())).on());
    }

    @Override
    public void turnOff() {
        this.setState(((StateBuilderSteps.OnOffStep)((Object)State.builder())).off());
    }

    @Override
    public void setState(State state) {
        String result = this.stateSetter.apply(state);
        logger.fine(result);
    }

    @Override
    public void setBrightness(int brightness) {
        this.setState(((StateBuilderSteps.BrightnessStep)((Object)State.builder())).brightness(brightness).keepCurrentState());
    }

    @Override
    public GroupType getType() {
        return this.groupType;
    }

    @Override
    public Collection<Scene> getScenes() {
        return this.scenes;
    }

    @Override
    public Optional<Scene> getSceneByName(String sceneName) {
        return this.scenes.stream().filter(scene -> Objects.equals(scene.getName(), sceneName)).findFirst();
    }

    private GroupState getGroupState() {
        return this.stateProvider.get();
    }

    public String toString() {
        return "Group{name='" + this.name + '\'' + "type='" + (Object)((Object)this.groupType) + '\'' + '}';
    }
}

