/*
 * Decompiled with CFR 0.152.
 */
package io.github.zeroone3010.yahueapi;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.github.zeroone3010.yahueapi.HttpUtil;
import io.github.zeroone3010.yahueapi.Hue;
import io.github.zeroone3010.yahueapi.HueApiException;
import io.github.zeroone3010.yahueapi.Light;
import io.github.zeroone3010.yahueapi.Room;
import io.github.zeroone3010.yahueapi.RoomImpl;
import io.github.zeroone3010.yahueapi.SceneImpl;
import io.github.zeroone3010.yahueapi.State;
import io.github.zeroone3010.yahueapi.domain.Group;
import io.github.zeroone3010.yahueapi.domain.GroupState;
import io.github.zeroone3010.yahueapi.domain.Scene;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;

final class RoomFactory {
    private static final String ACTION_PATH = "/action";
    private final Hue hue;
    private final ObjectMapper objectMapper;
    private final String bridgeUri;

    RoomFactory(Hue hue, ObjectMapper objectMapper, String bridgeUri) {
        this.hue = hue;
        this.objectMapper = objectMapper;
        this.bridgeUri = bridgeUri;
    }

    Room buildRoom(String groupId, Group group, Map<String, Scene> scenes) {
        Set<Light> lights = group.getLights().stream().map(this.hue::getLightById).collect(Collectors.toSet());
        try {
            URL url = new URL(this.bridgeUri + "groups/" + groupId);
            Function<State, String> stateSetter = this.stateSetter(url);
            return new RoomImpl(groupId, group, lights, this.buildScenes(scenes, stateSetter), this.createStateProvider(url, groupId), stateSetter);
        }
        catch (MalformedURLException e) {
            throw new HueApiException(e);
        }
    }

    private Set<io.github.zeroone3010.yahueapi.Scene> buildScenes(Map<String, Scene> scenes, Function<State, String> stateSetter) {
        return scenes.entrySet().stream().map(e -> new SceneImpl((String)e.getKey(), ((Scene)e.getValue()).getName(), stateSetter)).collect(Collectors.toSet());
    }

    private Supplier<GroupState> createStateProvider(URL url, String id) {
        return () -> {
            if (this.hue.isCaching()) {
                return this.hue.getRaw().getGroups().get(id).getState();
            }
            try {
                return this.objectMapper.readValue(url, Group.class).getState();
            }
            catch (IOException e) {
                throw new HueApiException(e);
            }
        };
    }

    private Function<State, String> stateSetter(URL url) {
        return state -> {
            String body;
            try {
                body = this.objectMapper.writeValueAsString(state);
            }
            catch (JsonProcessingException e) {
                throw new HueApiException(e);
            }
            return HttpUtil.put(url, ACTION_PATH, body);
        };
    }
}

