/*
 * Decompiled with CFR 0.152.
 */
package io.github.zeroone3010.yahueapi;

import io.github.zeroone3010.yahueapi.HueApiException;
import io.github.zeroone3010.yahueapi.Light;
import io.github.zeroone3010.yahueapi.LightType;
import io.github.zeroone3010.yahueapi.State;
import io.github.zeroone3010.yahueapi.StateBuilderSteps;
import io.github.zeroone3010.yahueapi.domain.LightDto;
import io.github.zeroone3010.yahueapi.domain.LightState;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.logging.Logger;

final class LightImpl
implements Light {
    private static final Logger logger = Logger.getLogger("LightImpl");
    private final String id;
    private final String name;
    private final Supplier<LightState> stateProvider;
    private final Function<State, String> stateSetter;
    private final LightType type;

    LightImpl(String id, LightDto light, Supplier<LightState> stateProvider, Function<State, String> stateSetter) {
        this.id = id;
        if (light == null) {
            throw new HueApiException("Light " + id + " cannot be found.");
        }
        this.name = light.getName();
        this.stateProvider = stateProvider;
        this.stateSetter = stateSetter;
        this.type = LightType.parseTypeString(light.getType());
    }

    protected String getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void turnOn() {
        this.setState(((StateBuilderSteps.OnOffStep)((Object)State.builder())).on());
    }

    @Override
    public void turnOff() {
        this.setState(((StateBuilderSteps.OnOffStep)((Object)State.builder())).off());
    }

    @Override
    public boolean isOn() {
        return this.getLightState().isOn();
    }

    @Override
    public boolean isReachable() {
        return this.getLightState().isReachable();
    }

    private LightState getLightState() {
        LightState state = this.stateProvider.get();
        logger.fine(state.toString());
        return state;
    }

    @Override
    public void setBrightness(int brightness) {
        this.setState(((StateBuilderSteps.BrightnessStep)((Object)State.builder())).brightness(brightness).keepCurrentState());
    }

    @Override
    public void setState(State state) {
        String result = this.stateSetter.apply(state);
        logger.fine(result);
    }

    @Override
    public LightType getType() {
        return this.type;
    }

    @Override
    public State getState() {
        return State.build(this.getLightState());
    }

    public String toString() {
        return "Light{id='" + this.id + '\'' + ", name='" + this.name + '\'' + ", type=" + (Object)((Object)this.type) + '}';
    }
}

