/*
 * Decompiled with CFR 0.152.
 */
package io.github.zeroone3010.yahueapi;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.github.zeroone3010.yahueapi.HttpUtil;
import io.github.zeroone3010.yahueapi.Hue;
import io.github.zeroone3010.yahueapi.HueApiException;
import io.github.zeroone3010.yahueapi.LightImpl;
import io.github.zeroone3010.yahueapi.State;
import io.github.zeroone3010.yahueapi.domain.LightDto;
import io.github.zeroone3010.yahueapi.domain.LightState;
import io.github.zeroone3010.yahueapi.domain.Root;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.function.Function;
import java.util.function.Supplier;

final class LightFactory {
    private static final String ACTION_PATH = "/state";
    private final Hue hue;
    private final ObjectMapper objectMapper;

    LightFactory(Hue hue, ObjectMapper objectMapper) {
        this.hue = hue;
        this.objectMapper = objectMapper;
    }

    LightImpl buildLight(String lightId, Root root, String bridgeUri) {
        try {
            URL url = new URL(bridgeUri + "lights/" + lightId);
            return new LightImpl(lightId, root.getLights().get(lightId), this.createStateProvider(url, lightId), this.stateSetter(url));
        }
        catch (MalformedURLException e) {
            throw new HueApiException(e);
        }
    }

    private Supplier<LightState> createStateProvider(URL url, String id) {
        return () -> {
            if (this.hue.isCaching()) {
                return this.hue.getRaw().getLights().get(id).getState();
            }
            try {
                return this.objectMapper.readValue(url, LightDto.class).getState();
            }
            catch (IOException e) {
                throw new HueApiException(e);
            }
        };
    }

    private Function<State, String> stateSetter(URL url) {
        return state -> {
            String body;
            try {
                body = this.objectMapper.writeValueAsString(state);
            }
            catch (JsonProcessingException e) {
                throw new HueApiException(e);
            }
            return HttpUtil.put(url, ACTION_PATH, body);
        };
    }
}

