/*
 * Decompiled with CFR 0.152.
 */
package io.github.zeroone3010.yahueapi;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.github.zeroone3010.yahueapi.AmbientLightSensor;
import io.github.zeroone3010.yahueapi.DaylightSensor;
import io.github.zeroone3010.yahueapi.GroupType;
import io.github.zeroone3010.yahueapi.HttpUtil;
import io.github.zeroone3010.yahueapi.HueApiException;
import io.github.zeroone3010.yahueapi.HueBridgeProtocol;
import io.github.zeroone3010.yahueapi.Light;
import io.github.zeroone3010.yahueapi.LightFactory;
import io.github.zeroone3010.yahueapi.LightImpl;
import io.github.zeroone3010.yahueapi.PresenceSensor;
import io.github.zeroone3010.yahueapi.Room;
import io.github.zeroone3010.yahueapi.RoomFactory;
import io.github.zeroone3010.yahueapi.RoomImpl;
import io.github.zeroone3010.yahueapi.Sensor;
import io.github.zeroone3010.yahueapi.SensorFactory;
import io.github.zeroone3010.yahueapi.SensorType;
import io.github.zeroone3010.yahueapi.Switch;
import io.github.zeroone3010.yahueapi.TemperatureSensor;
import io.github.zeroone3010.yahueapi.TrustEverythingManager;
import io.github.zeroone3010.yahueapi.UnauthorizedUserHandler;
import io.github.zeroone3010.yahueapi.domain.ApiInitializationStatus;
import io.github.zeroone3010.yahueapi.domain.Group;
import io.github.zeroone3010.yahueapi.domain.Root;
import io.github.zeroone3010.yahueapi.domain.Scene;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public final class Hue {
    private final ObjectMapper objectMapper = new ObjectMapper();
    private final SensorFactory sensorFactory = new SensorFactory(this, this.objectMapper);
    private final RoomFactory roomFactory;
    private final LightFactory lightFactory;
    private final String uri;
    private Root root;
    private Map<String, Light> lights;
    private Map<String, Room> groups;
    private Map<String, Sensor> sensors;
    private boolean caching = false;
    private Collection<Light> unassignedLights;

    public Hue(String bridgeIp, String apiKey) {
        this(HueBridgeProtocol.HTTP, bridgeIp, apiKey);
    }

    public void setCaching(boolean enabled) {
        if (this.caching != enabled) {
            this.caching = enabled;
            this.refresh();
        }
    }

    public boolean isCaching() {
        return this.caching;
    }

    public Hue(HueBridgeProtocol protocol, String bridgeIp, String apiKey) {
        this.uri = protocol.getProtocol() + "://" + bridgeIp + "/api/" + apiKey + "/";
        if (HueBridgeProtocol.UNVERIFIED_HTTPS.equals((Object)protocol)) {
            TrustEverythingManager.trustAllSslConnectionsByDisablingCertificateVerification();
        }
        this.objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        this.objectMapper.addHandler(new UnauthorizedUserHandler());
        this.roomFactory = new RoomFactory(this, this.objectMapper, this.uri);
        this.lightFactory = new LightFactory(this, this.objectMapper);
    }

    private void doInitialDataLoadIfRequired() {
        if (this.root == null) {
            this.refresh();
        }
    }

    public void refresh() {
        try {
            this.root = this.objectMapper.readValue(new URL(this.uri), Root.class);
        }
        catch (IOException e) {
            throw new HueApiException(e);
        }
        this.lights = Collections.unmodifiableMap(Optional.ofNullable(this.root.getLights()).orElse(Collections.emptyMap()).entrySet().stream().map(light -> this.buildLight((String)light.getKey(), this.root)).collect(Collectors.toMap(LightImpl::getId, light -> light)));
        Collection tempGroups = Optional.ofNullable(this.root.getGroups()).orElse(Collections.emptyMap()).entrySet().stream().map(group -> this.buildRoom((String)group.getKey(), (Group)group.getValue(), this.findScenesOfGroup((String)group.getKey(), this.root.getScenes()))).collect(Collectors.toSet());
        Map<String, Long> groupNameCounts = tempGroups.stream().collect(Collectors.groupingBy(Room::getName, Collectors.counting()));
        this.groups = Collections.unmodifiableMap(tempGroups.stream().collect(Collectors.toMap(room -> (Long)groupNameCounts.get(room.getName()) > 1L ? ((RoomImpl)room).getId() + ": " + room.getName() : room.getName(), room -> room)));
        this.sensors = Collections.unmodifiableMap(Optional.ofNullable(this.root.getSensors()).orElse(Collections.emptyMap()).entrySet().stream().map(sensor -> this.buildSensor((String)sensor.getKey(), this.root)).collect(Collectors.toMap(Sensor::getId, sensor -> sensor)));
        Collection lightsInUse = Optional.ofNullable(this.getRaw().getGroups()).orElse(Collections.emptyMap()).values().stream().flatMap(group -> group.getLights().stream()).collect(Collectors.toSet());
        this.unassignedLights = this.lights.entrySet().stream().filter(light -> !lightsInUse.contains(light.getKey())).map(light -> this.buildLight((String)light.getKey(), this.root)).sorted(Comparator.comparing(Light::getName)).collect(Collectors.toList());
    }

    private Map<String, Scene> findScenesOfGroup(String groupId, Map<String, Scene> scenes) {
        return Optional.ofNullable(scenes).orElse(Collections.emptyMap()).entrySet().stream().filter(e -> Objects.equals(groupId, ((Scene)e.getValue()).getGroup())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public Collection<Room> getGroupsOfType(GroupType ... groupTypes) {
        this.doInitialDataLoadIfRequired();
        return Collections.unmodifiableCollection(this.groups.values().stream().filter(room -> Arrays.stream(groupTypes).filter(Objects::nonNull).anyMatch(type -> type.equals((Object)room.getType()))).collect(Collectors.toSet()));
    }

    Light getLightById(String id) {
        this.doInitialDataLoadIfRequired();
        return this.lights.get(id);
    }

    public Collection<Room> getRooms() {
        return this.getGroupsOfType(GroupType.ROOM);
    }

    public Collection<Room> getZones() {
        return this.getGroupsOfType(GroupType.ZONE);
    }

    public Optional<Room> getRoomByName(String roomName) {
        this.doInitialDataLoadIfRequired();
        return Optional.ofNullable(this.groups.get(roomName)).filter(g -> g.getType() == GroupType.ROOM);
    }

    public Optional<Room> getZoneByName(String zoneName) {
        this.doInitialDataLoadIfRequired();
        return Optional.ofNullable(this.groups.get(zoneName)).filter(g -> g.getType() == GroupType.ZONE);
    }

    private Room buildRoom(String groupId, Group group, Map<String, Scene> scenes) {
        return this.roomFactory.buildRoom(groupId, group, scenes);
    }

    private Sensor buildSensor(String sensorId, Root root) {
        return this.sensorFactory.buildSensor(sensorId, root.getSensors().get(sensorId), this.uri);
    }

    private LightImpl buildLight(String lightId, Root root) {
        return this.lightFactory.buildLight(lightId, root, this.uri);
    }

    public Root getRaw() {
        this.doInitialDataLoadIfRequired();
        return this.root;
    }

    public Collection<Sensor> getUnknownSensors() {
        return this.getSensorsByType(SensorType.UNKNOWN, Sensor.class);
    }

    public Collection<TemperatureSensor> getTemperatureSensors() {
        return this.getSensorsByType(SensorType.TEMPERATURE, TemperatureSensor.class);
    }

    public Collection<Switch> getSwitches() {
        return this.getSensorsByType(SensorType.SWITCH, Switch.class);
    }

    public Collection<PresenceSensor> getPresenceSensors() {
        return this.getSensorsByType(SensorType.PRESENCE, PresenceSensor.class);
    }

    public Collection<DaylightSensor> getDaylightSensors() {
        return this.getSensorsByType(SensorType.DAYLIGHT, DaylightSensor.class);
    }

    public Collection<AmbientLightSensor> getAmbientLightSensors() {
        return this.getSensorsByType(SensorType.AMBIENT_LIGHT, AmbientLightSensor.class);
    }

    private <T> Collection<T> getSensorsByType(SensorType type, Class<T> sensorClass) {
        this.doInitialDataLoadIfRequired();
        return Collections.unmodifiableCollection(this.sensors.values().stream().filter(s -> type.equals((Object)s.getType())).map(sensorClass::cast).collect(Collectors.toList()));
    }

    public Optional<TemperatureSensor> getTemperatureSensorByName(String sensorName) {
        this.doInitialDataLoadIfRequired();
        return this.getTemperatureSensors().stream().filter(sensor -> Objects.equals(sensor.getName(), sensorName)).map(TemperatureSensor.class::cast).findFirst();
    }

    public Optional<PresenceSensor> getPresenceSensorByName(String sensorName) {
        this.doInitialDataLoadIfRequired();
        return this.getPresenceSensors().stream().filter(sensor -> Objects.equals(sensor.getName(), sensorName)).map(PresenceSensor.class::cast).findFirst();
    }

    public Optional<AmbientLightSensor> getAmbientSensorByName(String sensorName) {
        this.doInitialDataLoadIfRequired();
        return this.getAmbientLightSensors().stream().filter(sensor -> Objects.equals(sensor.getName(), sensorName)).map(AmbientLightSensor.class::cast).findFirst();
    }

    public Optional<Switch> getSwitchByName(String switchName) {
        this.doInitialDataLoadIfRequired();
        return this.getSwitches().stream().filter(sensor -> Objects.equals(sensor.getName(), switchName)).map(Switch.class::cast).findFirst();
    }

    public Collection<Light> getUnassignedLights() {
        this.doInitialDataLoadIfRequired();
        return this.unassignedLights;
    }

    public Optional<Light> getUnassignedLightByName(String lightName) {
        this.doInitialDataLoadIfRequired();
        return this.getUnassignedLights().stream().filter(light -> Objects.equals(light.getName(), lightName)).findFirst();
    }

    public static HueBridgeConnectionBuilder hueBridgeConnectionBuilder(String bridgeIp) {
        return new HueBridgeConnectionBuilder(bridgeIp);
    }

    public static class HueBridgeConnectionBuilder {
        private static final int MAX_TRIES = 30;
        private String bridgeIp;

        private HueBridgeConnectionBuilder(String bridgeIp) {
            this.bridgeIp = bridgeIp;
        }

        public CompletableFuture<String> initializeApiConnection(String appName) {
            Supplier<String> apiKeySupplier = () -> {
                URL baseUrl;
                String body = "{\"devicetype\":\"yetanotherhueapi#" + appName + "\"}";
                try {
                    baseUrl = new URL("http://" + this.bridgeIp + "/api");
                }
                catch (MalformedURLException e) {
                    throw new HueApiException(e);
                }
                String latestError = null;
                for (int triesLeft = 30; triesLeft > 0; --triesLeft) {
                    try {
                        System.out.println("Please push the button on the Hue Bridge now (" + triesLeft + " seconds left).");
                        String result = HttpUtil.post(baseUrl, "", body);
                        System.out.println(result);
                        ApiInitializationStatus status = new ObjectMapper().readValue(result, new TypeReference<ArrayList<ApiInitializationStatus>>(){}).get(0);
                        if (status.getSuccess() != null) {
                            return status.getSuccess().getUsername();
                        }
                        latestError = status.getError().getDescription();
                        TimeUnit.SECONDS.sleep(1L);
                        continue;
                    }
                    catch (Exception e) {
                        throw new HueApiException(e);
                    }
                }
                throw new HueApiException(latestError);
            };
            return CompletableFuture.supplyAsync(apiKeySupplier);
        }
    }
}

