/*
 * Decompiled with CFR 0.152.
 */
package io.github.zeroone3010.yahueapi;

import io.github.zeroone3010.yahueapi.HueApiException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.stream.Collectors;

final class HttpUtil {
    private HttpUtil() {
    }

    static String put(URL baseUrl, String path, String body) {
        return HttpUtil.getString(baseUrl, path, body, "PUT");
    }

    static String post(URL baseUrl, String path, String body) {
        return HttpUtil.getString(baseUrl, path, body, "POST");
    }

    private static String getString(URL baseUrl, String path, String body, String method) {
        String string;
        HttpURLConnection connection = (HttpURLConnection)new URL(baseUrl.toString() + path).openConnection();
        connection.setDoOutput(true);
        connection.setRequestMethod(method);
        connection.setRequestProperty("Host", connection.getURL().getHost());
        try (OutputStream outputStream = connection.getOutputStream();
             OutputStreamWriter writer = new OutputStreamWriter(outputStream, "UTF-8");){
            writer.write(body);
            writer.flush();
        }
        connection.connect();
        BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));
        try {
            string = reader.lines().collect(Collectors.joining("\n"));
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new HueApiException(e);
            }
        }
        reader.close();
        return string;
    }
}

