/*
 * Decompiled with CFR 0.152.
 */
package io.github.zeroone3010.yahueapi;

import io.github.zeroone3010.yahueapi.MathUtil;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;

public final class Color {
    private final float red;
    private final float green;
    private final float blue;

    private Color(int color) {
        this((float)((color & 0xFF0000) >> 16) / 255.0f, (float)((color & 0xFF00) >> 8) / 255.0f, (float)(color & 0xFF) / 255.0f);
    }

    private Color(float red, float green, float blue) {
        if (Stream.of(Float.valueOf(red), Float.valueOf(green), Float.valueOf(blue)).anyMatch(value -> !MathUtil.isInRange(value, 0.0f, 1.0f))) {
            throw new IllegalArgumentException("Color value out of range");
        }
        this.red = red;
        this.green = green;
        this.blue = blue;
    }

    public float getRed() {
        return this.red;
    }

    public float getGreen() {
        return this.green;
    }

    public float getBlue() {
        return this.blue;
    }

    public static Color of(float red, float green, float blue) {
        return new Color(red, green, blue);
    }

    public static Color of(int red, int green, int blue) {
        return new Color((float)red / 255.0f, (float)green / 255.0f, (float)blue / 255.0f);
    }

    public static Color of(int redGreenBlue) {
        return new Color(redGreenBlue & 0xFFFFFF);
    }

    public static Color of(Integer redGreenBlue) {
        if (redGreenBlue == null) {
            throw new IllegalArgumentException("Null is not an acceptable color value.");
        }
        return Color.of(redGreenBlue & 0xFFFFFF);
    }

    public static Color of(String hexRgb) {
        return Optional.ofNullable(hexRgb).map(string -> string.replaceAll("[# ]", "")).filter(string -> string.length() == 6).map(hex -> {
            try {
                return Integer.parseInt(hex, 16);
            }
            catch (NumberFormatException e) {
                return null;
            }
        }).map(integer -> Color.of((int)integer)).orElseThrow(() -> new IllegalArgumentException(String.format("'%s' could not be parsed as a color", hexRgb)));
    }

    public static Color of(Object otherColorObject) {
        if (otherColorObject == null) {
            throw new IllegalArgumentException("null cannot be parsed as a color.");
        }
        Optional<Method> redMethod = Color.findMethod(otherColorObject, "red", "getRed");
        Optional<Method> greenMethod = Color.findMethod(otherColorObject, "green", "getGreen");
        Optional<Method> blueMethod = Color.findMethod(otherColorObject, "blue", "getBlue");
        if (!(redMethod.isPresent() && greenMethod.isPresent() && blueMethod.isPresent())) {
            throw new IllegalArgumentException("The given object cannot be parsed as a color.");
        }
        Class<?> returnType = redMethod.get().getReturnType();
        if (!returnType.equals(blueMethod.get().getReturnType()) || !returnType.equals(greenMethod.get().getReturnType())) {
            throw new IllegalArgumentException("The given object cannot be parsed as a color: mismatching getter method return types.");
        }
        try {
            Number red = (Number)redMethod.get().invoke(otherColorObject, new Object[0]);
            Number green = (Number)greenMethod.get().invoke(otherColorObject, new Object[0]);
            Number blue = (Number)blueMethod.get().invoke(otherColorObject, new Object[0]);
            if (red instanceof Integer) {
                return Color.of(red.intValue(), green.intValue(), blue.intValue());
            }
            if (red instanceof Double || red instanceof Float) {
                return Color.of(red.floatValue(), green.floatValue(), blue.floatValue());
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("The given object cannot be parsed as a color.", e);
        }
        return null;
    }

    private static Optional<Method> findMethod(Object target, String name1, String name2) {
        Method[] methods = target.getClass().getMethods();
        return ((Stream)Arrays.stream(methods).sequential()).filter(m -> name1.equals(m.getName()) || name2.equals(m.getName())).findFirst();
    }

    public String toString() {
        return "Color{red=" + this.red + ", green=" + this.green + ", blue=" + this.blue + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Color color = (Color)o;
        return Float.compare(color.red, this.red) == 0 && Float.compare(color.green, this.green) == 0 && Float.compare(color.blue, this.blue) == 0;
    }

    public int hashCode() {
        return Objects.hash(Float.valueOf(this.red), Float.valueOf(this.green), Float.valueOf(this.blue));
    }
}

