/*
 * Decompiled with CFR 0.152.
 */
package io.github.zeroone3010.yahueapi;

import java.util.Objects;
import java.util.stream.Stream;

public final class ButtonEvent {
    private final ButtonEventType eventType;
    private final int eventCode;

    ButtonEvent(ButtonEventType eventType, int eventCode) {
        this.eventType = eventType;
        this.eventCode = eventCode;
    }

    public ButtonEventType getEventType() {
        return this.eventType;
    }

    public int getEventCode() {
        return this.eventCode;
    }

    public String toString() {
        return "ButtonEvent{eventType=" + (Object)((Object)this.eventType) + ", eventCode=" + this.eventCode + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ButtonEvent that = (ButtonEvent)o;
        return this.eventCode == that.eventCode && this.eventType == that.eventType;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.eventType, this.eventCode});
    }

    public static enum ButtonEventType {
        UNKNOWN(null),
        INITIAL_PRESS("initial_press"),
        HOLD("repeat"),
        SHORT_RELEASED("short_release"),
        LONG_RELEASED("long_release");

        private final String eventType;

        private ButtonEventType(String eventType) {
            this.eventType = eventType;
        }

        private String getEventType() {
            return this.eventType;
        }

        public static ButtonEventType parseFromButtonEventType(String eventType) {
            return Stream.of(ButtonEventType.values()).filter(value -> Objects.equals(value.getEventType(), eventType)).findFirst().orElse(UNKNOWN);
        }
    }
}

