/*
 * Decompiled with CFR 0.152.
 */
package io.github.zeroone3010.yahueapi;

import io.github.zeroone3010.yahueapi.AmbientLightSensor;
import io.github.zeroone3010.yahueapi.BasicSensor;
import io.github.zeroone3010.yahueapi.domain.SensorDto;
import java.net.URL;
import java.util.Map;
import java.util.function.Supplier;

public class AmbientLightSensorImpl
extends BasicSensor
implements AmbientLightSensor {
    AmbientLightSensorImpl(String id, SensorDto sensor, URL url, Supplier<Map<String, Object>> stateProvider) {
        super(id, sensor, url, stateProvider);
    }

    @Override
    public String toString() {
        return "AmbientLightSensor{id='" + this.id + '\'' + ", name='" + this.name + '\'' + ", type=" + (Object)((Object)this.type) + '}';
    }

    @Override
    public int getLightLevel() {
        return AmbientLightSensorImpl.calculateLux(this.readStateValue("lightlevel", Integer.class));
    }

    static int calculateLux(int lightLevel) {
        return (int)Math.round(Math.pow(10.0, (double)(lightLevel - 1) / 10000.0));
    }

    @Override
    public boolean isDaylight() {
        return this.readStateValue("daylight", Boolean.class);
    }

    @Override
    public boolean isDark() {
        return this.readStateValue("dark", Boolean.class);
    }
}

