/*
 * Decompiled with CFR 0.152.
 */
package io.github.zeroone3010.yahueapi;

import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Objects;
import java.util.stream.Stream;

public enum AlertType {
    SHORT_ALERT("select"),
    LONG_ALERT("lselect"),
    NONE("none"),
    UNKNOWN(null);

    private String apiString;

    private AlertType(String apiString) {
        this.apiString = apiString;
    }

    public static AlertType parseTypeString(String type) {
        if (type == null) {
            return null;
        }
        return Stream.of(AlertType.values()).filter(alertType -> Objects.equals(alertType.getApiString(), type)).findFirst().orElse(UNKNOWN);
    }

    @JsonValue
    public String getApiString() {
        return this.apiString;
    }
}

