/*
 * Decompiled with CFR 0.152.
 */
package com.hueambiance.overrides;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.hueambiance.AmbianceOverride;
import com.hueambiance.HueAmbianceConfig;
import com.hueambiance.helpers.HueHelper;
import io.github.zeroone3010.yahueapi.Room;
import java.awt.Color;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.runelite.api.Client;
import net.runelite.api.NPC;
import net.runelite.api.coords.LocalPoint;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.events.NpcChanged;
import net.runelite.api.events.NpcSpawned;

@Singleton
public class ZulrahOverride
implements AmbianceOverride {
    private static final Set<Integer> ZULRAH_REGIONS = ImmutableSet.of((Object)9007, (Object)9008);
    private static final Map<Integer, Color> ZULRAH_COLORS = ImmutableMap.of((Object)2042, (Object)Color.GREEN, (Object)2043, (Object)Color.RED, (Object)2044, (Object)Color.CYAN);
    @Inject
    private Client client;
    @Inject
    private HueAmbianceConfig config;
    @Inject
    private HueHelper hueHelper;

    @Override
    public boolean doesOverride(Room room) {
        return this.config.zulrahEnabled() && this.atZulrah();
    }

    @Override
    public void handleNpcSpawned(NpcSpawned npcSpawned, Room room) {
        NPC npc;
        if (this.config.zulrahEnabled() && 2042 == (npc = npcSpawned.getNpc()).getId()) {
            this.hueHelper.setColor(room, ZULRAH_COLORS.get(2042));
        }
    }

    @Override
    public void handleNpcChanged(NpcChanged npcChanged, Room room) {
        if (this.config.zulrahEnabled() && ZULRAH_COLORS.containsKey(npcChanged.getNpc().getId())) {
            this.hueHelper.setColor(room, ZULRAH_COLORS.get(npcChanged.getNpc().getId()));
        }
    }

    private boolean atZulrah() {
        return this.client.isInInstancedRegion() && ZULRAH_REGIONS.contains(WorldPoint.fromLocalInstance((Client)this.client, (LocalPoint)this.client.getLocalPlayer().getLocalLocation()).getRegionID());
    }
}

