/*
 * Decompiled with CFR 0.152.
 */
package com.hueambiance.overrides;

import com.hueambiance.AmbianceOverride;
import com.hueambiance.HueAmbianceConfig;
import com.hueambiance.helpers.HueHelper;
import io.github.zeroone3010.yahueapi.Room;
import java.time.Duration;
import java.util.Arrays;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.runelite.api.Client;
import net.runelite.api.events.GameObjectSpawned;

@Singleton
public class TobOverride
implements AmbianceOverride {
    private static final List<Integer> REWARD_CHEST_IDS = Arrays.asList(33086, 33087, 33088, 33089, 33090);
    private static final int OWN_TOB_PURPLE_CHEST = 32993;
    private static final int OTHER_TOB_PURPLE_CHEST = 32991;
    private boolean active = false;
    @Inject
    private Client client;
    @Inject
    private HueAmbianceConfig config;
    @Inject
    private HueHelper hueHelper;

    @Override
    public boolean doesOverride(Room room) {
        return this.active;
    }

    @Override
    public void handleGameObjectSpawned(GameObjectSpawned event, Room room) {
        int objId = event.getGameObject().getId();
        if (REWARD_CHEST_IDS.contains(objId)) {
            int impostorId = this.client.getObjectDefinition(objId).getImpostor().getId();
            if (impostorId == 32993) {
                this.active = true;
                this.hueHelper.setColorForDuration(room, this.config.tobColor(), Duration.ofSeconds(15L), () -> {
                    this.active = false;
                });
            } else if (impostorId == 32991 && this.config.tobShowOthersPurple()) {
                this.active = true;
                this.hueHelper.setColorForDuration(room, this.config.tobOthersColor(), Duration.ofSeconds(15L), () -> {
                    this.active = false;
                });
            }
        }
    }
}

