/*
 * Decompiled with CFR 0.152.
 */
package com.hueambiance.overrides;

import com.hueambiance.AmbianceOverride;
import com.hueambiance.HueAmbianceConfig;
import com.hueambiance.helpers.HueHelper;
import io.github.zeroone3010.yahueapi.Room;
import java.time.Duration;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.runelite.api.Client;
import net.runelite.api.coords.LocalPoint;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.events.GameTick;

@Singleton
public class ToaOverride
implements AmbianceOverride {
    private static final int TOA_TOMB_REGION = 14672;
    private static final int[] VARBIT_MULTILOC_IDS_CHEST = new int[]{14356, 14357, 14358, 14359, 14360, 14370, 14371, 14372};
    private static final int VARBIT_VALUE_CHEST_KEY = 2;
    private static final int VARBIT_ID_SARCOPHAGUS = 14373;
    private boolean active = false;
    private boolean activatedBefore = false;
    @Inject
    private Client client;
    @Inject
    private HueAmbianceConfig config;
    @Inject
    private HueHelper hueHelper;

    @Override
    public boolean doesOverride(Room room) {
        return this.active;
    }

    @Override
    public void handleGameTick(GameTick gameTick, Room room) {
        int region;
        LocalPoint lp = this.client.getLocalPlayer().getLocalLocation();
        int n = region = lp == null ? -1 : WorldPoint.fromLocalInstance((Client)this.client, (LocalPoint)lp).getRegionID();
        if (region == 14672 && !this.activatedBefore) {
            boolean sarcophagusIsPurple;
            boolean bl = sarcophagusIsPurple = this.client.getVarbitValue(14373) % 2 != 0;
            if (sarcophagusIsPurple) {
                boolean purpleIsMine = true;
                for (int varbitId : VARBIT_MULTILOC_IDS_CHEST) {
                    if (this.client.getVarbitValue(varbitId) != 2) continue;
                    purpleIsMine = false;
                    break;
                }
                if (purpleIsMine) {
                    this.active = true;
                    this.activatedBefore = true;
                    this.hueHelper.setColorForDuration(room, this.config.toaColor(), Duration.ofSeconds(15L), () -> {
                        this.active = false;
                    });
                } else if (this.config.toaShowOthersPurple()) {
                    this.active = true;
                    this.activatedBefore = true;
                    this.hueHelper.setColorForDuration(room, this.config.toaOthersColor(), Duration.ofSeconds(15L), () -> {
                        this.active = false;
                    });
                }
            }
        } else if (region != 14672 && this.activatedBefore) {
            this.activatedBefore = false;
        }
    }
}

