/*
 * Decompiled with CFR 0.152.
 */
package com.hueambiance.overrides;

import com.hueambiance.AmbianceOverride;
import com.hueambiance.HueAmbianceConfig;
import com.hueambiance.helpers.HueHelper;
import io.github.zeroone3010.yahueapi.Room;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.runelite.api.Client;
import net.runelite.api.Skill;
import net.runelite.api.events.GameTick;

@Singleton
public class PrayerOverride
implements AmbianceOverride {
    @Inject
    private HueAmbianceConfig config;
    @Inject
    private Client client;
    @Inject
    private HueHelper hueHelper;
    private boolean currentlyAlerting = false;
    private long lastAlert = 0L;

    @Override
    public boolean doesOverride(Room room) {
        boolean lowPrayer = this.checkLowPrayer();
        if (!lowPrayer) {
            if (this.currentlyAlerting) {
                this.hueHelper.stopAlert(room);
            }
            this.currentlyAlerting = false;
        }
        return lowPrayer;
    }

    @Override
    public void handleGameTick(GameTick gameTick, Room room) {
        long currentTime = System.currentTimeMillis();
        if (!this.currentlyAlerting || currentTime - this.lastAlert > 10000L) {
            this.currentlyAlerting = true;
            this.lastAlert = currentTime;
            this.hueHelper.setAlert(room, this.config.lowPrayerColor());
        }
    }

    private boolean checkLowPrayer() {
        return this.config.prayerThreshold() > 0 && this.client.getRealSkillLevel(Skill.PRAYER) > this.config.prayerThreshold() && this.client.getBoostedSkillLevel(Skill.PRAYER) <= this.config.prayerThreshold();
    }
}

