/*
 * Decompiled with CFR 0.152.
 */
package com.hueambiance.overrides;

import com.hueambiance.AmbianceOverride;
import com.hueambiance.HueAmbianceConfig;
import com.hueambiance.helpers.HueHelper;
import io.github.zeroone3010.yahueapi.Room;
import java.time.Duration;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.runelite.api.Client;
import net.runelite.api.events.ChatMessage;
import net.runelite.client.util.Text;

@Singleton
public class MessageOverride
implements AmbianceOverride {
    @Inject
    private Client client;
    @Inject
    private HueAmbianceConfig config;
    @Inject
    private HueHelper hueHelper;
    private boolean active = false;

    @Override
    public boolean doesOverride(Room room) {
        return this.active;
    }

    @Override
    public void handleChatMessage(ChatMessage chatMessage, Room room) {
        switch (chatMessage.getType()) {
            case GAMEMESSAGE: {
                this.handleGameMessage(Text.removeTags((String)chatMessage.getMessage()), room);
                break;
            }
            case FRIENDSCHATNOTIFICATION: {
                this.handleFriendsChatNotification(Text.removeTags((String)chatMessage.getMessage()), room);
            }
        }
    }

    private void handleGameMessage(String message, Room room) {
        if (message.contains("Congratulations, you've just advanced")) {
            if (this.config.levelUpEnabled()) {
                this.startAction();
                this.hueHelper.performFireWorks(room, this.stopAction());
            }
        } else if (this.client.getLocalPlayer().getName() != null && message.contains(this.client.getLocalPlayer().getName())) {
            if (message.contains("Enhanced crystal weapon seed")) {
                this.startAction();
                this.hueHelper.setColorForDuration(room, this.config.cgEnhanced(), Duration.ofSeconds(5L), this.stopAction());
            } else if (message.contains("Crystal armour seed")) {
                this.startAction();
                this.hueHelper.setColorForDuration(room, this.config.cgArmour(), Duration.ofSeconds(5L), this.stopAction());
            }
        }
    }

    private void handleFriendsChatNotification(String message, Room room) {
        if (message.contains("Special loot")) {
            if (this.client.getLocalPlayer().getName() != null && message.contains(this.client.getLocalPlayer().getName())) {
                this.startAction();
                this.hueHelper.setColorForDuration(room, this.config.coxColor(), Duration.ofSeconds(15L), this.stopAction());
            } else if (this.config.coxShowOthersPurple()) {
                this.startAction();
                this.hueHelper.setColorForDuration(room, this.config.coxOthersColor(), Duration.ofSeconds(15L), this.stopAction());
            }
        }
    }

    private void startAction() {
        this.active = true;
    }

    private Runnable stopAction() {
        return () -> {
            this.active = false;
        };
    }
}

