/*
 * Decompiled with CFR 0.152.
 */
package com.hueambiance.overrides;

import com.hueambiance.AmbianceOverride;
import com.hueambiance.HueAmbianceConfig;
import com.hueambiance.helpers.HueHelper;
import io.github.zeroone3010.yahueapi.Room;
import java.time.Duration;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.runelite.api.events.ItemSpawned;
import net.runelite.client.game.ItemManager;

@Singleton
public class ItemOverride
implements AmbianceOverride {
    @Inject
    private HueAmbianceConfig config;
    @Inject
    private ItemManager itemManager;
    @Inject
    private HueHelper hueHelper;
    private boolean active = false;

    @Override
    public boolean doesOverride(Room room) {
        return this.active;
    }

    @Override
    public void handleItemSpawned(ItemSpawned itemSpawned, Room room) {
        if (this.config.lowItemPriceThreshold() > 0 || this.config.mediumItemPriceThreshold() > 0 || this.config.highItemPriceThreshold() > 0) {
            int price = this.itemManager.getItemPrice(itemSpawned.getItem().getId());
            if (this.config.highItemPriceThreshold() > 0 && price >= this.config.highItemPriceThreshold()) {
                this.active = true;
                this.hueHelper.setColorForDuration(room, this.config.itemHighColor(), Duration.ofSeconds(5L), () -> {
                    this.active = false;
                });
            } else if (this.config.mediumItemPriceThreshold() > 0 && price >= this.config.mediumItemPriceThreshold()) {
                this.active = true;
                this.hueHelper.setColorForDuration(room, this.config.itemMediumColor(), Duration.ofSeconds(5L), () -> {
                    this.active = false;
                });
            } else if (this.config.lowItemPriceThreshold() > 0 && price >= this.config.lowItemPriceThreshold()) {
                this.active = true;
                this.hueHelper.setColorForDuration(room, this.config.itemLowColor(), Duration.ofSeconds(5L), () -> {
                    this.active = false;
                });
            }
        }
    }
}

