/*
 * Decompiled with CFR 0.152.
 */
package com.hueambiance.overrides;

import com.hueambiance.AmbianceOverride;
import com.hueambiance.HueAmbianceConfig;
import com.hueambiance.helpers.HueHelper;
import io.github.zeroone3010.yahueapi.Room;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.runelite.api.Client;
import net.runelite.api.Skill;
import net.runelite.api.events.GameTick;

@Singleton
public class HpOverride
implements AmbianceOverride {
    @Inject
    private HueAmbianceConfig config;
    @Inject
    private Client client;
    @Inject
    private HueHelper hueHelper;
    private boolean currentlyAlerting = false;
    private long lastAlert = 0L;

    @Override
    public boolean doesOverride(Room room) {
        boolean lowHP = this.checkLowHP();
        if (!lowHP) {
            if (this.currentlyAlerting) {
                this.hueHelper.stopAlert(room);
            }
            this.currentlyAlerting = false;
        }
        return lowHP;
    }

    @Override
    public void handleGameTick(GameTick gameTick, Room room) {
        long currentTime = System.currentTimeMillis();
        if (!this.currentlyAlerting || currentTime - this.lastAlert > 10000L) {
            this.currentlyAlerting = true;
            this.lastAlert = currentTime;
            this.hueHelper.setAlert(room, this.config.lowHpColor());
        }
    }

    private boolean checkLowHP() {
        return this.config.hpThreshold() > 0 && this.client.getRealSkillLevel(Skill.HITPOINTS) > this.config.hpThreshold() && this.client.getBoostedSkillLevel(Skill.HITPOINTS) + this.client.getVarbitValue(3956) <= this.config.hpThreshold();
    }
}

