/*
 * Decompiled with CFR 0.152.
 */
package com.hueambiance.helpers;

import com.hueambiance.HueAmbianceConfig;
import com.hueambiance.helpers.Colors;
import com.hueambiance.helpers.ThreadHelper;
import io.github.zeroone3010.yahueapi.Room;
import io.github.zeroone3010.yahueapi.State;
import java.awt.Color;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class HueHelper {
    private static final int MAX_BRIGHTNESS = 254;
    @Inject
    private HueAmbianceConfig config;

    public void performFireWorks(Room room, Runnable callback) {
        this.executeForDuration(() -> Colors.FIRE_WORKS_COLORS.forEach(color -> {
            this.setColor(room, (Color)color);
            try {
                Thread.sleep(250L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }), Duration.ofSeconds(5L), callback);
    }

    public void setColor(Room room, Color color) {
        ThreadHelper.executeOnBackGround(() -> room.setState(State.builder().xy(this.toXY(color)).brightness(this.getBrightness()).keepCurrentState()));
    }

    public void setAlert(Room room, Color color) {
        ThreadHelper.executeOnBackGround(() -> {
            room.setState(State.LONG_ALERT);
            this.setColor(room, color);
        });
    }

    public void stopAlert(Room room) {
        ThreadHelper.executeOnBackGround(() -> room.setState(State.NO_ALERT));
    }

    public void setColorForDuration(Room room, Color color, Duration duration, Runnable callback) {
        ThreadHelper.executeOnBackGround(() -> {
            this.setColor(room, color);
            try {
                Thread.sleep(duration.toMillis());
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }, callback);
    }

    private void executeForDuration(Runnable task, Duration duration, Runnable callback) {
        ThreadHelper.executeOnBackGround(() -> {
            long endTime = System.nanoTime() + duration.toNanos();
            while (endTime > System.nanoTime()) {
                task.run();
            }
        }, callback);
    }

    private int getBrightness() {
        return (int)((double)this.config.brightness() / 100.0 * 254.0);
    }

    private List<Float> toXY(Color color) {
        double r = this.gammaCorrection(color.getRed());
        double g = this.gammaCorrection(color.getGreen());
        double b = this.gammaCorrection(color.getBlue());
        double rgbX = r * (double)0.664511f + g * (double)0.154324f + b * (double)0.162028f;
        double rgbY = r * (double)0.283881f + g * (double)0.668433f + b * (double)0.047685f;
        double rgbZ = r * (double)8.8E-5f + g * (double)0.07231f + b * (double)0.986039f;
        final float x = (float)(rgbX / (rgbX + rgbY + rgbZ));
        final float y = (float)(rgbY / (rgbX + rgbY + rgbZ));
        return new ArrayList<Float>(){
            {
                this.add(Float.valueOf(x));
                this.add(Float.valueOf(y));
            }
        };
    }

    private double gammaCorrection(float component) {
        return component > 0.04045f ? Math.pow((component + 0.055f) / 1.055f, 2.4f) : (double)(component / 12.92f);
    }
}

