/*
 * Decompiled with CFR 0.152.
 */
package com.hueambiance;

import com.google.inject.Inject;
import com.google.inject.Provides;
import com.hueambiance.AmbianceOverride;
import com.hueambiance.HueAmbianceConfig;
import com.hueambiance.helpers.HueHelper;
import com.hueambiance.overrides.AmbianceOverrides;
import io.github.zeroone3010.yahueapi.Hue;
import io.github.zeroone3010.yahueapi.Room;
import java.awt.Color;
import java.util.Optional;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.events.ChatMessage;
import net.runelite.api.events.CommandExecuted;
import net.runelite.api.events.GameObjectSpawned;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.ItemSpawned;
import net.runelite.api.events.NpcChanged;
import net.runelite.api.events.NpcSpawned;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Hue Ambiance")
public class HueAmbiancePlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(HueAmbiancePlugin.class);
    @Inject
    private Client client;
    @Inject
    private HueAmbianceConfig config;
    @Inject
    private AmbianceOverrides ambianceOverrides;
    @Inject
    private HueHelper hueHelper;
    private Hue hue;
    private Optional<Room> room = Optional.empty();
    private long lastSkyboxUpdate;
    private boolean colorChanged = false;
    private static final long NANO_SECOND_MULTIPLIER = 1000000L;

    protected void startUp() {
        this.initHue();
    }

    protected void shutDown() {
        this.hue = null;
        this.room = Optional.empty();
    }

    @Subscribe
    public void onGameTick(GameTick tick) {
        this.room.ifPresent(r -> {
            Optional<AmbianceOverride> override = this.ambianceOverrides.getAll().stream().filter(o -> o.doesOverride((Room)r)).findFirst();
            if (override.isPresent()) {
                override.get().handleGameTick(tick, (Room)r);
                this.colorChanged = true;
            } else {
                this.updateSkybox();
            }
        });
    }

    private void updateSkybox() {
        this.room.ifPresent(r -> {
            long skyboxRefreshRate = this.config.skyboxRefreshRate();
            if (skyboxRefreshRate > 0L) {
                this.colorChanged = true;
                if (System.nanoTime() - this.lastSkyboxUpdate > skyboxRefreshRate * 1000000L) {
                    this.lastSkyboxUpdate = System.nanoTime();
                    int skyboxColor = this.client.getSkyboxColor();
                    this.hueHelper.setColor((Room)r, new Color(skyboxColor));
                }
            } else if (this.colorChanged) {
                this.setDefaultHueColor();
            }
        });
    }

    @Subscribe
    public void onNpcSpawned(NpcSpawned npcSpawned) {
        this.room.ifPresent(r -> this.ambianceOverrides.getAll().stream().filter(o -> o.doesOverride((Room)r)).findFirst().ifPresent(override -> override.handleNpcSpawned(npcSpawned, (Room)r)));
    }

    @Subscribe
    public void onNpcChanged(NpcChanged npcChanged) {
        this.room.ifPresent(r -> this.ambianceOverrides.getAll().stream().filter(o -> o.doesOverride((Room)r)).findFirst().ifPresent(override -> override.handleNpcChanged(npcChanged, (Room)r)));
    }

    @Subscribe
    public void onChatMessage(ChatMessage chatMessage) {
        this.room.ifPresent(r -> this.ambianceOverrides.getAll().forEach(override -> override.handleChatMessage(chatMessage, (Room)r)));
    }

    @Subscribe
    public void onItemSpawned(ItemSpawned itemSpawned) {
        this.room.ifPresent(r -> this.ambianceOverrides.getAll().forEach(override -> override.handleItemSpawned(itemSpawned, (Room)r)));
    }

    @Subscribe
    public void onGameObjectSpawned(GameObjectSpawned gameObjectSpawned) {
        this.room.ifPresent(r -> this.ambianceOverrides.getAll().forEach(override -> override.handleGameObjectSpawned(gameObjectSpawned, (Room)r)));
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged configChanged) {
        String key;
        switch (key = configChanged.getKey()) {
            case "ip": 
            case "token": {
                this.initHue();
                break;
            }
            case "room": {
                this.initRoom();
                break;
            }
            case "defaultColor": 
            case "brightness": {
                this.colorChanged = true;
            }
        }
    }

    @Subscribe
    public void onCommandExecuted(CommandExecuted commandExecuted) {
        if (commandExecuted.getCommand().equals("testlights")) {
            if (this.room.isPresent()) {
                this.client.addChatMessage(ChatMessageType.GAMEMESSAGE, "", "Your smart lights are currently connected.", "");
            } else {
                this.client.addChatMessage(ChatMessageType.GAMEMESSAGE, "", "Your smart lights are not connected.", "");
            }
        }
    }

    @Provides
    HueAmbianceConfig provideConfig(ConfigManager configManager) {
        return (HueAmbianceConfig)configManager.getConfig(HueAmbianceConfig.class);
    }

    private void initHue() {
        if (this.config.bridgeIp() != null && this.config.bridgeToken() != null) {
            this.hue = new Hue(this.config.bridgeIp(), this.config.bridgeToken());
            this.initRoom();
        }
    }

    private void initRoom() {
        if (this.config.room() != null) {
            this.room = this.hue.getRoomByName(this.config.room());
            this.setDefaultHueColor();
        }
    }

    private void setDefaultHueColor() {
        this.colorChanged = false;
        this.room.ifPresent(r -> this.hueHelper.setColor((Room)r, this.config.defaultHueColor()));
    }
}

