/*
 * Decompiled with CFR 0.152.
 */
package com.nyloer;

import com.google.inject.Provides;
import com.nyloer.CustomFontConfig;
import com.nyloer.NyloerConfig;
import com.nyloer.NyloerOverlay;
import java.awt.Color;
import java.awt.Font;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import javax.inject.Inject;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.NPC;
import net.runelite.api.coords.LocalPoint;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.events.ChatMessage;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.NpcSpawned;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.game.NpcUtil;
import net.runelite.client.input.KeyListener;
import net.runelite.client.input.KeyManager;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Nyloer")
public class NyloerPlugin
extends Plugin
implements KeyListener {
    @Inject
    public Client client;
    @Inject
    public NyloerConfig config;
    @Inject
    public CustomFontConfig customFontConfig;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private NpcUtil npcUtil;
    @Inject
    private NyloerOverlay nyloerOverlay;
    @Inject
    private KeyManager keyManager;
    private static final int NYLOCAS_REGION_ID = 13122;
    private final int[] NYLOCAS_PILLAR_IDS = new int[]{8358, 10811, 10790};
    private final int[] NYLOCAS_NPC_IDS = new int[]{8342, 8348, 8345, 8351, 8343, 8349, 8346, 8352, 8344, 8350, 8347, 8353, 10791, 10792, 10793, 10797, 10798, 10799, 10794, 10795, 10796, 10800, 10801, 10802, 10774, 10777, 10780, 10783, 10775, 10778, 10781, 10784, 10776, 10779, 10782, 10785};
    private final int[] MELEE_NYLOCAS_IDS = new int[]{8342, 8345, 8348, 8351, 10774, 10777, 10780, 10783, 10791, 10794, 10797, 10800};
    private final int[] RANGE_NYLOCAS_IDS = new int[]{8343, 8346, 8349, 8352, 10775, 10778, 10781, 10784, 10792, 10795, 10798, 10801};
    private final int[] MAGE_NYLOCAS_IDS = new int[]{8344, 8347, 8350, 8353, 10776, 10779, 10782, 10785, 10793, 10796, 10799, 10802};
    private boolean isNylocasRegion = false;
    private boolean isNylocasRegionLast = false;
    private boolean pillarsSpawned;
    private int waveNumber;
    private int lastWaveTickSpawned;
    ArrayList<NyloerNpc> nyloers = new ArrayList();
    private static final Logger log = LoggerFactory.getLogger(NyloerPlugin.class);

    protected void startUp() throws Exception {
        this.start();
        this.keyManager.registerKeyListener((KeyListener)this);
    }

    protected void shutDown() throws Exception {
        this.stop();
        this.keyManager.unregisterKeyListener((KeyListener)this);
    }

    public void keyTyped(KeyEvent e) {
    }

    public void keyPressed(KeyEvent e) {
        if (this.config.makeDarkerHotkey().matches(e)) {
            log.debug("Making nylos darker...");
            for (NyloerNpc nyloer : this.nyloers) {
                if (nyloer.colorDarker) continue;
                nyloer.color = nyloer.color.darker().darker();
                nyloer.colorDarker = true;
            }
        }
    }

    public void keyReleased(KeyEvent e) {
    }

    @Provides
    NyloerConfig provideConfig(ConfigManager configManager) {
        return (NyloerConfig)configManager.getConfig(NyloerConfig.class);
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged configChanged) {
        if (!configChanged.getGroup().equals("nyloer")) {
            return;
        }
        this.customFontConfig.getColorSettings().clear();
        this.customFontConfig.parse(this.config);
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged event) {
        if (event.getGameState() == GameState.LOGIN_SCREEN || event.getGameState() == GameState.HOPPING) {
            this.stop();
        }
    }

    @Subscribe
    public void onGameTick(GameTick event) {
        if (this.client.getTickCount() % 5 == 0) {
            this.updateNylocasRegion();
        }
        if (this.isNylocasRegion && !this.isNylocasRegionLast) {
            this.start();
        } else if (!this.isNylocasRegion && this.isNylocasRegionLast) {
            this.stop();
        }
        this.isNylocasRegionLast = this.isNylocasRegion;
        if (this.isNylocasRegion) {
            for (NyloerNpc nyloer : this.nyloers) {
                if (nyloer.npc.isDead()) {
                    nyloer.setAlive(false);
                    continue;
                }
                if (!nyloer.isAlive) continue;
                nyloer.incrementTicks();
            }
        }
    }

    @Subscribe
    public void onNpcSpawned(NpcSpawned event) {
        if (!this.isNylocasRegion) {
            return;
        }
        NPC npc = event.getNpc();
        String npcName = npc.getName();
        if (npcName == null) {
            return;
        }
        if (!this.pillarsSpawned && ArrayUtils.contains((int[])this.NYLOCAS_PILLAR_IDS, (int)npc.getId())) {
            this.reset();
            this.pillarsSpawned = true;
            return;
        }
        if (ArrayUtils.contains((int[])this.NYLOCAS_NPC_IDS, (int)npc.getId())) {
            NyloerNpc nyloer = new NyloerNpc(npc);
            if (!nyloer.spawn.equals("SPLIT") && this.lastWaveTickSpawned != this.client.getTickCount()) {
                ++this.waveNumber;
                this.lastWaveTickSpawned = this.client.getTickCount();
                ++nyloer.waveSpawned;
                nyloer.updateStyle(nyloer.id);
            }
            this.nyloers.add(nyloer);
        }
    }

    @Subscribe
    public void onChatMessage(ChatMessage event) {
        if (this.isNylocasRegion && event.getType().equals((Object)ChatMessageType.GAMEMESSAGE) && event.getMessage().equals("You have failed. The vampyres take pity on you and allow you to try again...")) {
            this.reset();
        }
    }

    private void start() {
        log.debug("Starting Nyloer.");
        this.customFontConfig.parse(this.config);
        this.overlayManager.add((Overlay)this.nyloerOverlay);
    }

    private void stop() {
        log.debug("Stopping Nyloer.");
        this.customFontConfig.getColorSettings().clear();
        this.overlayManager.remove((Overlay)this.nyloerOverlay);
        this.reset();
    }

    private void reset() {
        log.debug("Resetting Nyloer.");
        this.waveNumber = 0;
        this.pillarsSpawned = false;
        this.nyloers.clear();
        this.nyloerOverlay.nyloers.clear();
    }

    private void updateNylocasRegion() {
        this.isNylocasRegion = ArrayUtils.contains((int[])this.client.getMapRegions(), (int)13122);
    }

    public boolean isNylocasRegion() {
        return this.isNylocasRegion;
    }

    public boolean isNylocasRegionLast() {
        return this.isNylocasRegionLast;
    }

    public boolean isPillarsSpawned() {
        return this.pillarsSpawned;
    }

    public int getWaveNumber() {
        return this.waveNumber;
    }

    public ArrayList<NyloerNpc> getNyloers() {
        return this.nyloers;
    }

    public class NyloerNpc {
        private NPC npc;
        private int id;
        private int lastId;
        private int index;
        private String size;
        private boolean isAlive;
        private boolean isSplit;
        private String spawn;
        private int waveSpawned;
        public int tickSpawned;
        private int ticksAlive;
        private String nyloerSymbol;
        private Color color;
        private Color outlineColor;
        private boolean colorDarker;
        private Font font;

        public void incrementTicks() {
            ++this.ticksAlive;
            if (this.ticksAlive == 52) {
                this.isAlive = false;
            }
            if (this.lastId != this.npc.getId()) {
                this.lastId = this.npc.getId();
                this.updateStyle(this.npc.getId());
            }
        }

        private void updateStyle(int id) {
            String fontConfigKey;
            if (ArrayUtils.contains((int[])NyloerPlugin.this.MELEE_NYLOCAS_IDS, (int)id)) {
                fontConfigKey = this.waveSpawned + "-melee";
                this.color = NyloerPlugin.this.config.meleeNylocasColor();
                this.outlineColor = NyloerPlugin.this.config.meleeNylocasOutlineColor();
                this.nyloerSymbol = NyloerPlugin.this.config.meleeNylocasSymbol();
            } else if (ArrayUtils.contains((int[])NyloerPlugin.this.RANGE_NYLOCAS_IDS, (int)id)) {
                fontConfigKey = this.waveSpawned + "-range";
                this.color = NyloerPlugin.this.config.rangeNylocasColor();
                this.outlineColor = NyloerPlugin.this.config.rangeNylocasOutlineColor();
                this.nyloerSymbol = NyloerPlugin.this.config.rangeNylocasSymbol();
            } else if (ArrayUtils.contains((int[])NyloerPlugin.this.MAGE_NYLOCAS_IDS, (int)id)) {
                fontConfigKey = this.waveSpawned + "-mage";
                this.color = NyloerPlugin.this.config.mageNylocasColor();
                this.outlineColor = NyloerPlugin.this.config.mageNylocasOutlineColor();
                this.nyloerSymbol = NyloerPlugin.this.config.mageNylocasSymbol();
            } else {
                fontConfigKey = null;
                this.color = Color.WHITE;
                this.outlineColor = Color.BLACK;
                this.isAlive = false;
            }
            Color customColor = NyloerPlugin.this.customFontConfig.getColor(fontConfigKey);
            if (customColor != null) {
                this.color = customColor;
            }
            if (this.colorDarker) {
                this.color = this.color.darker().darker();
            }
        }

        private void configureFonts() {
            if (this.isSplit) {
                int style = NyloerPlugin.this.config.splitFontsBold() ? 1 : 0;
                this.font = new Font(NyloerPlugin.this.config.splitFontsType().toString(), style, NyloerPlugin.this.config.splitFontsSize());
            } else {
                int style = NyloerPlugin.this.config.fontsBold() ? 1 : 0;
                this.font = new Font(NyloerPlugin.this.config.fontsType().toString(), style, NyloerPlugin.this.config.fontsSize());
            }
        }

        private String findSpawn(NPC npc) {
            int x = WorldPoint.fromLocalInstance((Client)NyloerPlugin.this.client, (LocalPoint)npc.getLocalLocation()).getRegionX();
            int y = WorldPoint.fromLocalInstance((Client)NyloerPlugin.this.client, (LocalPoint)npc.getLocalLocation()).getRegionY();
            if (x == 17 && y == 25) {
                return "WEST NORTH";
            }
            if (x == 17 && y == 24) {
                return "WEST SOUTH";
            }
            if (x == 31 && y == 9) {
                return "SOUTH WEST";
            }
            if (x == 32 && y == 9) {
                return "SOUTH EAST";
            }
            if (x == 46 && y == 24) {
                return "EAST SOUTH";
            }
            if (x == 46 && y == 25) {
                if (npc.getComposition().getSize() == 1) {
                    return "EAST NORTH";
                }
                return "EAST BIG";
            }
            if (x == 18 && y == 25) {
                return "WEST BIG";
            }
            if (x == 32 && y == 10) {
                return "SOUTH BIG";
            }
            if (x == 47 && y == 25) {
                return "EAST BIG 30";
            }
            return "SPLIT";
        }

        public NyloerNpc(NPC npc) {
            this.npc = npc;
            this.id = npc.getId();
            this.lastId = npc.getId();
            this.index = npc.getIndex();
            this.isAlive = true;
            this.spawn = this.findSpawn(npc);
            this.isSplit = this.spawn.equals("SPLIT");
            this.tickSpawned = NyloerPlugin.this.client.getTickCount();
            this.colorDarker = false;
            this.waveSpawned = this.isSplit && NyloerPlugin.this.config.splitsAsNextWave() && this.tickSpawned > NyloerPlugin.this.lastWaveTickSpawned ? NyloerPlugin.this.waveNumber + 1 : NyloerPlugin.this.waveNumber;
            this.ticksAlive = 0;
            this.updateStyle(this.id);
            this.configureFonts();
            this.size = npc.getComposition().getSize() == 1 ? "SMALL" : "BIG";
        }

        public NPC getNpc() {
            return this.npc;
        }

        public int getId() {
            return this.id;
        }

        public int getLastId() {
            return this.lastId;
        }

        public int getIndex() {
            return this.index;
        }

        public String getSize() {
            return this.size;
        }

        public boolean isAlive() {
            return this.isAlive;
        }

        public void setAlive(boolean isAlive) {
            this.isAlive = isAlive;
        }

        public boolean isSplit() {
            return this.isSplit;
        }

        public String getSpawn() {
            return this.spawn;
        }

        public int getWaveSpawned() {
            return this.waveSpawned;
        }

        public int getTickSpawned() {
            return this.tickSpawned;
        }

        public int getTicksAlive() {
            return this.ticksAlive;
        }

        public String getNyloerSymbol() {
            return this.nyloerSymbol;
        }

        public Color getColor() {
            return this.color;
        }

        public Color getOutlineColor() {
            return this.outlineColor;
        }

        public boolean isColorDarker() {
            return this.colorDarker;
        }

        public Font getFont() {
            return this.font;
        }
    }
}

