/*
 * Decompiled with CFR 0.152.
 */
package com.nyloer;

import com.google.common.collect.ArrayListMultimap;
import com.nyloer.NyloerConfig;
import com.nyloer.NyloerPlugin;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.util.stream.IntStream;
import javax.inject.Inject;
import net.runelite.api.Point;
import net.runelite.api.coords.WorldPoint;
import net.runelite.client.game.NpcUtil;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.OverlayPriority;

public class NyloerOverlay
extends Overlay {
    public ArrayListMultimap<WorldPoint, NyloerPlugin.NyloerNpc> nyloers;
    private final NyloerConfig config;
    private final NyloerPlugin plugin;
    private final NpcUtil npcUtil;

    @Inject
    private NyloerOverlay(NyloerPlugin plugin, NyloerConfig config, NpcUtil npcUtil) {
        this.setPosition(OverlayPosition.DYNAMIC);
        this.setPriority(OverlayPriority.HIGH);
        this.setLayer(OverlayLayer.ABOVE_SCENE);
        this.npcUtil = npcUtil;
        this.plugin = plugin;
        this.config = config;
        this.nyloers = ArrayListMultimap.create();
    }

    public Dimension render(Graphics2D graphics) {
        this.nyloers.clear();
        if (this.plugin.nyloers.isEmpty()) {
            return null;
        }
        this.nyloers = ArrayListMultimap.create();
        int length = this.plugin.nyloers.size();
        for (int i = length - 1; i >= 0; --i) {
            NyloerPlugin.NyloerNpc nyloer = this.plugin.nyloers.get(i);
            if (!nyloer.isAlive() || this.npcUtil.isDying(nyloer.getNpc())) continue;
            this.nyloers.put((Object)nyloer.getNpc().getWorldLocation(), (Object)nyloer);
        }
        if (!this.nyloers.isEmpty()) {
            graphics.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            this.nyloers.asMap().forEach((worldPoint, npcs) -> {
                int offset = 0;
                for (NyloerPlugin.NyloerNpc nyloer : npcs) {
                    graphics.setFont(nyloer.getFont());
                    this.draw(graphics, nyloer, offset);
                    offset += graphics.getFontMetrics().getHeight();
                }
            });
        }
        return null;
    }

    private void draw(Graphics2D graphics, NyloerPlugin.NyloerNpc nyloer, int offset) {
        String prefix = nyloer.isSplit() ? this.config.splitPrefix() : this.config.wavePrefix();
        Object text = this.config.showNylocasWave() ? prefix + nyloer.getWaveSpawned() : (this.config.showNylocasSymbol() ? prefix + nyloer.getNyloerSymbol() : prefix);
        Point canvasTextLocation = nyloer.getNpc().getCanvasTextLocation(graphics, (String)text, 0);
        if (canvasTextLocation == null) {
            return;
        }
        int x = canvasTextLocation.getX();
        int y = canvasTextLocation.getY() + offset;
        graphics.setColor(nyloer.getOutlineColor());
        IntStream.range(-1, 2).forEachOrdered(arg_0 -> NyloerOverlay.lambda$draw$2(graphics, (String)text, x, y, arg_0));
        graphics.setColor(nyloer.getColor());
        graphics.drawString((String)text, x, y);
    }

    private static /* synthetic */ void lambda$draw$2(Graphics2D graphics, String text, int x, int y, int ex) {
        IntStream.range(-1, 2).forEachOrdered(ey -> {
            if (ex != 0 && ey != 0) {
                graphics.drawString(text, x + ex, y + ey);
            }
        });
    }
}

