/*
 * Decompiled with CFR 0.152.
 */
package com.nyloer;

import com.nyloer.NyloerConfig;
import java.awt.Color;
import java.util.HashMap;
import java.util.List;
import net.runelite.client.util.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomFontConfig {
    private static final Logger log = LoggerFactory.getLogger(CustomFontConfig.class);
    private static final CustomFontConfig INSTANCE = new CustomFontConfig();
    private final HashMap<String, Color> colorSettings = new HashMap();

    public Color getColor(String fontConfigKey) {
        return this.colorSettings.get(fontConfigKey);
    }

    public List<Color> parse(NyloerConfig config) {
        String input = config.customFontConfig();
        if (input == null || input.isEmpty()) {
            return null;
        }
        for (String entry : Text.fromCSV((String)input)) {
            try {
                String[] parts = entry.split(":");
                log.info(Integer.parseInt(parts[0].trim()) + "-" + parts[1].trim() + " -> " + Color.decode(parts[2].trim()).toString());
                this.colorSettings.put(Integer.parseInt(parts[0].trim()) + "-" + parts[1].trim(), Color.decode(parts[2].trim()));
            }
            catch (Exception e) {
                log.warn("Parse exception: \"" + entry + "\"\n" + e.getMessage());
            }
        }
        return null;
    }

    public static CustomFontConfig getInstance() {
        return INSTANCE;
    }

    public HashMap<String, Color> getColorSettings() {
        return this.colorSettings;
    }
}

