/*
 * Decompiled with CFR 0.152.
 */
package com.vardorvishealth;

import com.google.inject.Provides;
import com.vardorvishealth.VardorvisHealTrackerOverlay;
import com.vardorvishealth.VardorvisHealthConfig;
import javax.inject.Inject;
import net.runelite.api.Actor;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.Hitsplat;
import net.runelite.api.NPC;
import net.runelite.api.events.HitsplatApplied;
import net.runelite.api.events.NpcDespawned;
import net.runelite.client.chat.ChatColorType;
import net.runelite.client.chat.ChatMessageBuilder;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Vardorvis Health Tracker", description="Tracks how much Vardorvis heals over the fight")
public class VardorvisHealTrackerPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(VardorvisHealTrackerPlugin.class);
    @Inject
    private Client client;
    @Inject
    private VardorvisHealTrackerOverlay overlay;
    @Inject
    private OverlayManager overlayManager;
    private int totalHealing = 0;
    @Inject
    private VardorvisHealthConfig config;
    @Inject
    private ConfigManager configManager;

    public void sendChatMessage(String message) {
        ChatMessageBuilder messageBuilder = new ChatMessageBuilder();
        messageBuilder.append(ChatColorType.NORMAL).append(message);
        String builtMessage = messageBuilder.build();
        this.client.addChatMessage(ChatMessageType.GAMEMESSAGE, "", builtMessage, null);
    }

    @Subscribe
    public void onNpcDespawned(NpcDespawned event) {
        if (event.getNpc().getId() == 12223 && this.getTotalHealing() != 0) {
            this.sendChatMessage("Vardorvis healed for " + this.getTotalHealing() + " health in total that fight.");
            this.resetHealing();
        }
    }

    public void resetHealing() {
        this.totalHealing = 0;
    }

    @Subscribe
    public void onHitsplatApplied(HitsplatApplied event) {
        try {
            Hitsplat hitsplat;
            NPC npc;
            Actor actor = event.getActor();
            if (actor instanceof NPC && (npc = (NPC)actor).getId() == 12223 && (hitsplat = event.getHitsplat()).getHitsplatType() == 6) {
                this.totalHealing += hitsplat.getAmount();
            }
        }
        catch (Exception e) {
            log.error("Error processing HitsplatApplied event", (Throwable)e);
        }
    }

    protected void startUp() throws Exception {
        log.info("Starting up Vardorvis Heal Tracker Plugin");
        this.overlayManager.add((Overlay)this.overlay);
    }

    protected void shutDown() throws Exception {
        this.overlayManager.remove((Overlay)this.overlay);
    }

    @Provides
    VardorvisHealthConfig provideConfig(ConfigManager configManager) {
        return (VardorvisHealthConfig)configManager.getConfig(VardorvisHealthConfig.class);
    }

    public int getTotalHealing() {
        return this.totalHealing;
    }
}

