/*
 * Decompiled with CFR 0.152.
 */
package com.kittentracker;

import com.google.inject.Provides;
import com.kittentracker.Felines;
import com.kittentracker.FollowerKind;
import com.kittentracker.KittenAttentionTimer;
import com.kittentracker.KittenAttentionType;
import com.kittentracker.KittenConfig;
import com.kittentracker.KittenGrowthTimer;
import com.kittentracker.KittenHungryTimer;
import com.kittentracker.KittenOverlay;
import java.awt.image.BufferedImage;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.HashMap;
import javax.inject.Inject;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.events.ChatMessage;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.VarbitChanged;
import net.runelite.api.widgets.Widget;
import net.runelite.client.Notifier;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.game.ItemManager;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import net.runelite.client.ui.overlay.infobox.InfoBoxManager;
import net.runelite.client.ui.overlay.infobox.Timer;
import net.runelite.client.util.Text;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Kitten Tracker")
public class KittenPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(KittenPlugin.class);
    private static final int VAR_PLAYER_FOLLOWER = 447;
    private static final int WIDGET_ID_DIALOG_NOTIFICATION_GROUP_ID = 229;
    private static final int WIDGET_ID_DIALOG_PLAYER_TEXT = 6;
    private static final int WIDGET_ID_DIALOG_NOTIFICATION_TEXT = 1;
    private static final String DIALOG_CAT_STROKE = "That cat sure loves to be stroked.";
    private static final String DIALOG_CAT_BALL_OF_WOOL = "That kitten loves to play with that ball of wool. I think itis its favourite.";
    private static final String DIALOG_CAT_GROWN = "Your kitten has grown into a healthy cat that can hunt for itself.";
    private static final String DIALOG_CAT_OVERGROWN = "Your cat has grown into a mighty feline, but it will no longer be able to chase vermin.";
    private static final String DIALOG_AFTER_TAKING_A_GOOD_LOOK = "After taking a good look at your kitten you guess that its age is: ";
    private static final String DIALOG_HAND_OVER_CAT_CIVILIAN = "You hand over the cat.You are given";
    private static final String DIALOG_GERTRUDE_GIVES_YOU_ANOTHER_KITTEN = "Gertrude gives you another kitten.";
    private static final String CHAT_STROKE_CAT = "You softly stroke your cat.";
    private static final String CHAT_THE_KITTEN_GOBBLES_UP_THE_FISH = "The kitten gobbles up the fish.";
    private static final String CHAT_THE_KITTEN_LAPS_UP_THE_MILK = "The kitten laps up the milk.";
    private static final String CHAT_YOUR_KITTEN_IS_HUNGRY = "Your kitten is hungry.";
    private static final String CHAT_YOUR_KITTEN_IS_VERY_HUNGRY = "Your kitten is very hungry.";
    private static final String CHAT_YOUR_KITTEN_WANTS_ATTENTION = "Your kitten wants attention.";
    private static final String CHAT_YOUR_KITTEN_REALLY_WANTS_ATTENTION = "Your kitten really wants attention.";
    private static final String CHAT_YOUR_KITTEN_GOT_LONELY_AND_RAN_OFF = "Your kitten got lonely and ran off.";
    private static final String CHAT_THE_CAT_HAS_RUN_AWAY = "The cat has run away.";
    private static final String NOTIFICATION_KITTEN_WILL_RUN_AWAY_IN_1_MINUTE = "Kitten will run away in 1 minute!";
    private static final String TOOLTIP_APPROXIMATE_TIME_LEFT_TO_GROW_INTO_A_CAT = "Approximate time left to grow into a cat";
    private static final String TOOLTIP_APPROXIMATE_TIME_LEFT_TO_TRANSFORM_INTO_AN_OVERGROWN_CAT = "Approximate time left to transform into an overgrown cat";
    private static final String TOOLTIP_TIME_UNTIL_YOUR_KITTEN_LEAVES_YOU_FOR_BEING_UNDERFED = "Time until your kitten leaves you for being underfed";
    private static final String TOOLTIP_APPROXIMATE_TIME_UNTIL_YOUR_KITTEN_LEAVES_YOU_FOR_BEING_NEGLECTFUL = "Approximate time until your kitten leaves you for being neglectful";
    public static final int HUNGRY_FIRST_WARNING_TIME_LEFT_IN_SECONDS = 360;
    public static final int HUNGRY_FINAL_WARNING_TIME_LEFT_IN_SECONDS = 180;
    public static final long HUNGRY_TIME_ONE_MINUTE_WARNING_MS = 60000L;
    private static final int HUNGRY_TIME_BEFORE_FIRST_WARNING_IN_MINUTES = 24;
    private static final int HUNGRY_TIME_BEFORE_FINAL_WARNING_IN_MINUTES = 27;
    private static final int HUNGRY_TIME_BEFORE_KITTEN_RUNS_AWAY_IN_SECONDS = 1800;
    public static final int ATTENTION_FIRST_WARNING_TIME_LEFT_IN_SECONDS = 840;
    public static final int ATTENTION_FINAL_WARNING_TIME_LEFT_IN_SECONDS = 420;
    public static final long ATTENTION_TIME_ONE_MINUTE_WARNING_MS = 60000L;
    public static final int ATTENTION_TIME_NEW_KITTEN_IN_SECONDS = 1500;
    public static final int ATTENTION_TIME_SINGLE_STROKE_IN_SECONDS = 1080;
    public static final int ATTENTION_TIME_MULTIPLE_STROKES_IN_SECONDS = 1500;
    public static final int ATTENTION_TIME_BALL_OF_WOOL_IN_SECONDS = 3060;
    public static final int ATTENTION_TIME_FROM_WARNING_TO_RUNNING_AWAY_IN_SECONDS = 840;
    private static final int ATTENTION_TIME_BEFORE_KITTEN_RUNS_AWAY_NEW_KITTEN_IN_SECONDS = 2340;
    private static final int ATTENTION_TIME_BEFORE_KITTEN_RUNS_AWAY_SINGLE_STROKE_IN_SECONDS = 1920;
    private static final int ATTENTION_TIME_BEFORE_KITTEN_RUNS_AWAY_MULTIPLE_STROKES_IN_SECONDS = 2340;
    private static final int ATTENTION_TIME_BEFORE_KITTEN_RUNS_AWAY_BALL_OF_WOOL_IN_SECONDS = 3900;
    private static final int TIME_TO_ADULTHOOD_IN_SECONDS = 10800;
    private static final int TIME_TILL_OVERGROWN_IN_SECONDS = 9000;
    private boolean ready;
    private Instant kittenSpawnedTime;
    private Instant catSpawnedTime;
    private Instant kittenLastFedTime;
    private Instant kittenLastAttentionTime;
    private int timeSpendGrowing = 0;
    private int timeNeglected = 0;
    private int timeHungry = 0;
    private int followerID = 0;
    private int previousFollowerId = 0;
    private KittenAttentionType lastAttentionType = KittenAttentionType.NEW_KITTEN;
    private Timer kittenAttentionTimer;
    private Timer growthTimer;
    private Timer kittenHungryTimer;
    private FollowerKind followerKind = FollowerKind.NON_FELINE;
    private boolean attentionNotificationSend = false;
    private boolean hungryNotificationSend = false;
    private HashMap<Integer, Instant> openedWidgets = new HashMap();
    @Inject
    private Client client;
    @Inject
    private Notifier notifier;
    @Inject
    private KittenConfig config;
    @Inject
    private ClientThread clientThread;
    @Inject
    private ItemManager itemManager;
    @Inject
    private InfoBoxManager infoBoxManager;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private KittenOverlay overlay;

    @Provides
    KittenConfig provideConfig(ConfigManager configManager) {
        return (KittenConfig)configManager.getConfig(KittenConfig.class);
    }

    public void startUp() {
        this.clientThread.invokeLater(this::checkForFollower);
        this.previousFollowerId = this.config.felineId();
        this.overlayManager.add((Overlay)this.overlay);
    }

    protected void shutDown() {
        this.overlayManager.remove((Overlay)this.overlay);
        this.byeFollower();
    }

    private void checkForFollower() {
        if (this.client.getGameState() != GameState.LOGGED_IN) {
            return;
        }
        if (this.playerHasFollower()) {
            this.newFollower();
        }
    }

    @Subscribe
    public void onVarbitChanged(VarbitChanged event) {
        if (this.playerHasFollower() && this.followerID != this.getCurrentFollowerId()) {
            this.checkForNewFollower();
        }
        if (!this.playerHasFollower() && this.followerID != 0) {
            this.byeFollower();
        }
    }

    private void checkForNewFollower() {
        this.followerID = this.getCurrentFollowerId();
        if (this.followerID > 0) {
            this.previousFollowerId = this.followerID;
            this.newFollower();
        }
    }

    private int getCurrentFollowerId() {
        int followerVarPlayerValue = this.client.getVarpValue(447);
        return followerVarPlayerValue >> 16;
    }

    private void newFollower() {
        this.attentionNotificationSend = false;
        this.hungryNotificationSend = false;
        this.followerKind = FollowerKind.getFromFollowerId(this.followerID);
        switch (this.followerKind) {
            case KITTEN: {
                if (this.followerID == this.previousFollowerId) {
                    this.timeSpendGrowing = this.config.secondsAlive();
                    this.timeNeglected = this.config.secondsNeglected();
                    this.timeHungry = this.config.secondsHungry();
                    this.kittenSpawnedTime = Instant.now();
                    this.lastAttentionType = this.config.lastAttentionType();
                    this.addKittenGrowthBox(10800 - this.timeSpendGrowing);
                    this.addHungryTimer(1800 - this.timeHungry);
                    this.addAttentionTimer(1920 - this.timeNeglected);
                    break;
                }
                this.config.secondsAlive(0);
                this.config.secondsHungry(0);
                this.config.secondsNeglected(0);
                this.config.lastAttentionType(KittenAttentionType.NEW_KITTEN);
                this.kittenSpawnedTime = Instant.now();
                this.kittenLastFedTime = Instant.now();
                this.kittenLastAttentionTime = Instant.now();
                this.addKittenGrowthBox(10800);
                this.addHungryTimer(1800);
                this.addAttentionTimer(2340);
                break;
            }
            case NORMAL_CAT: {
                if (this.followerID == this.previousFollowerId) {
                    this.timeSpendGrowing = this.config.secondsAlive();
                    this.addKittenGrowthBox(19800 - this.timeSpendGrowing);
                    break;
                }
                this.catSpawnedTime = Instant.now();
                this.addKittenGrowthBox(9000);
                break;
            }
        }
    }

    private void byeFollower() {
        switch (this.followerKind) {
            case KITTEN: {
                this.saveGrowthProgress();
                this.kittenSpawnedTime = null;
                this.kittenLastFedTime = null;
                this.kittenLastAttentionTime = null;
                break;
            }
            case NORMAL_CAT: {
                this.saveGrowthProgress();
                this.catSpawnedTime = null;
                break;
            }
            case LAZY_CAT: 
            case WILY_CAT: 
            case OVERGROWN_CAT: 
            case NON_FELINE: {
                this.kittenSpawnedTime = null;
                this.kittenLastFedTime = null;
                this.kittenLastAttentionTime = null;
                this.catSpawnedTime = null;
            }
        }
        this.infoBoxManager.removeIf(t -> t instanceof KittenGrowthTimer);
        this.infoBoxManager.removeIf(t -> t instanceof KittenHungryTimer);
        this.infoBoxManager.removeIf(t -> t instanceof KittenAttentionTimer);
        this.followerID = 0;
    }

    private void saveGrowthProgress() {
        switch (this.followerKind) {
            case KITTEN: {
                int secondsSinceSpawn;
                Duration timeSinceSpawn;
                this.config.felineId(this.followerID);
                if (this.kittenSpawnedTime != null) {
                    Duration timeAlive = Duration.between(this.kittenSpawnedTime, Instant.now());
                    int secondsAlive = Math.toIntExact(timeAlive.getSeconds());
                    this.config.secondsAlive(this.timeSpendGrowing + secondsAlive);
                } else {
                    log.debug("TimeAlive is null, no follower...");
                }
                if (this.kittenLastFedTime != null) {
                    Duration timeFed = Duration.between(this.kittenLastFedTime, Instant.now());
                    int secondsFed = Math.toIntExact(timeFed.getSeconds());
                    this.config.secondsHungry(secondsFed);
                } else if (this.kittenSpawnedTime != null) {
                    timeSinceSpawn = Duration.between(this.kittenSpawnedTime, Instant.now());
                    secondsSinceSpawn = Math.toIntExact(timeSinceSpawn.getSeconds());
                    this.config.secondsHungry(this.timeHungry + secondsSinceSpawn);
                }
                if (this.kittenLastAttentionTime != null) {
                    Duration timeAttention = Duration.between(this.kittenLastAttentionTime, Instant.now());
                    int secondsAttention = Math.toIntExact(timeAttention.getSeconds());
                    this.config.secondsNeglected(secondsAttention);
                } else if (this.kittenSpawnedTime != null) {
                    timeSinceSpawn = Duration.between(this.kittenSpawnedTime, Instant.now());
                    secondsSinceSpawn = Math.toIntExact(timeSinceSpawn.getSeconds());
                    this.config.secondsNeglected(this.timeNeglected + secondsSinceSpawn);
                }
                this.config.lastAttentionType(this.lastAttentionType);
                break;
            }
            case NORMAL_CAT: {
                this.config.felineId(this.followerID);
                if (this.kittenSpawnedTime != null) {
                    Duration timeAlive = Duration.between(this.catSpawnedTime, Instant.now());
                    int secondsAlive = Math.toIntExact(timeAlive.getSeconds());
                    this.config.secondsAlive(this.timeSpendGrowing + secondsAlive);
                    break;
                }
                log.debug("TimeAlive is null, no follower...");
                break;
            }
        }
    }

    private void addKittenGrowthBox(int seconds) {
        if (seconds <= 0) {
            return;
        }
        Felines feline = Felines.find(this.followerID);
        if (feline == null) {
            return;
        }
        this.growthTimer = new KittenGrowthTimer(feline, (BufferedImage)this.itemManager.getImage(feline.getItemSpriteId()), this, Duration.ofSeconds(seconds));
    }

    private void addHungryTimer(int seconds) {
        if (seconds <= 0) {
            return;
        }
        this.kittenHungryTimer = new KittenHungryTimer((BufferedImage)this.itemManager.getImage(1552), this, Duration.ofSeconds(seconds));
    }

    private void addAttentionTimer(int seconds) {
        if (seconds <= 0) {
            return;
        }
        this.kittenAttentionTimer = new KittenAttentionTimer((BufferedImage)this.itemManager.getImage(1759), this, Duration.ofSeconds(seconds));
    }

    @Subscribe
    public void onChatMessage(ChatMessage event) {
        String message;
        if (event.getType() != ChatMessageType.GAMEMESSAGE) {
            return;
        }
        switch (message = Text.removeTags((String)event.getMessage())) {
            case "You softly stroke your cat.": {
                if (this.kittenLastAttentionTime != null) {
                    long timeSinceLastAttentionSeconds = Duration.between(this.kittenLastAttentionTime, Instant.now()).toMillis() / 1000L + (long)this.timeNeglected;
                    int maxTimePastForMultiStrokeSeconds = -1;
                    if (this.lastAttentionType != null) {
                        switch (this.lastAttentionType) {
                            case SINGLE_STROKE: 
                            case MULTIPLE_STROKES: {
                                maxTimePastForMultiStrokeSeconds = this.lastAttentionType.getAttentionTime();
                            }
                        }
                    }
                    if (timeSinceLastAttentionSeconds < (long)maxTimePastForMultiStrokeSeconds) {
                        if (this.config.kittenAttentionOverlay()) {
                            this.addAttentionTimer(2340);
                        }
                        this.lastAttentionType = KittenAttentionType.MULTIPLE_STROKES;
                    } else {
                        if (this.config.kittenAttentionOverlay()) {
                            this.addAttentionTimer(1920);
                        }
                        this.lastAttentionType = KittenAttentionType.SINGLE_STROKE;
                    }
                } else {
                    if (this.config.kittenAttentionOverlay()) {
                        this.addAttentionTimer(1920);
                    }
                    this.lastAttentionType = KittenAttentionType.SINGLE_STROKE;
                }
                this.kittenLastAttentionTime = Instant.now();
                this.timeNeglected = 0;
                break;
            }
            case "The kitten gobbles up the fish.": 
            case "The kitten laps up the milk.": {
                this.kittenLastFedTime = Instant.now();
                if (this.config.kittenHungryOverlay()) {
                    this.addHungryTimer(1800);
                }
                this.timeHungry = 0;
                break;
            }
            case "Your kitten is hungry.": {
                if (this.config.kittenNotifications()) {
                    this.notifier.notify(message);
                }
                if (this.config.kittenHungryOverlay()) {
                    this.addHungryTimer(360);
                }
                this.kittenLastFedTime = Instant.now().minus(24L, ChronoUnit.MINUTES);
                break;
            }
            case "Your kitten is very hungry.": {
                if (this.config.kittenNotifications()) {
                    this.notifier.notify(message);
                }
                if (this.config.kittenHungryOverlay()) {
                    this.addHungryTimer(180);
                }
                this.kittenLastFedTime = Instant.now().minus(27L, ChronoUnit.MINUTES);
                break;
            }
            case "Your kitten wants attention.": {
                if (this.config.kittenNotifications()) {
                    this.notifier.notify(message);
                }
                if (this.config.kittenAttentionOverlay()) {
                    this.addAttentionTimer(840);
                }
                this.kittenLastAttentionTime = Instant.now().minus(1920L, ChronoUnit.MINUTES);
                break;
            }
            case "Your kitten really wants attention.": {
                if (this.config.kittenNotifications()) {
                    this.notifier.notify(message);
                }
                if (this.config.kittenAttentionOverlay()) {
                    this.addAttentionTimer(420);
                }
                this.kittenLastAttentionTime = Instant.now().minus(1920L, ChronoUnit.MINUTES);
                break;
            }
            case "Your kitten got lonely and ran off.": 
            case "The cat has run away.": {
                if (this.config.kittenNotifications()) {
                    this.notifier.notify(message);
                }
                this.kittenSpawnedTime = null;
                this.kittenLastFedTime = null;
                this.kittenLastAttentionTime = null;
                this.previousFollowerId = 0;
                this.config.felineId(0);
                this.infoBoxManager.removeIf(t -> t instanceof KittenGrowthTimer);
                this.infoBoxManager.removeIf(t -> t instanceof KittenHungryTimer);
                this.infoBoxManager.removeIf(t -> t instanceof KittenAttentionTimer);
                this.followerID = 0;
            }
        }
    }

    @Subscribe
    public void onGameTick(GameTick tick) {
        String notificationText;
        Widget dialog;
        Widget notificationDialog;
        String playerText;
        Widget playerDialog;
        long timeBeforeNeedingAttention = this.getTimeBeforeNeedingAttention();
        if (!this.attentionNotificationSend && timeBeforeNeedingAttention != 0L && timeBeforeNeedingAttention < 60000L) {
            this.notifier.notify(NOTIFICATION_KITTEN_WILL_RUN_AWAY_IN_1_MINUTE);
            this.attentionNotificationSend = true;
        }
        long timeBeforeHungry = this.getTimeBeforeHungry();
        if (!this.hungryNotificationSend && timeBeforeHungry != 0L && timeBeforeHungry < 60000L) {
            this.notifier.notify(NOTIFICATION_KITTEN_WILL_RUN_AWAY_IN_1_MINUTE);
            this.hungryNotificationSend = true;
        }
        if ((playerDialog = this.client.getWidget(217, 6)) != null && (playerText = Text.removeTags((String)playerDialog.getText())).equals(DIALOG_CAT_BALL_OF_WOOL)) {
            this.kittenLastAttentionTime = Instant.now();
            if (this.config.kittenAttentionOverlay()) {
                this.addAttentionTimer(3900);
            }
            this.timeNeglected = 0;
            this.lastAttentionType = KittenAttentionType.BALL_OF_WOOL;
        }
        if ((notificationDialog = this.client.getWidget(229, 1)) != null) {
            String notificationText2 = Text.removeTags((String)notificationDialog.getText());
            if (notificationText2.equals(DIALOG_GERTRUDE_GIVES_YOU_ANOTHER_KITTEN)) {
                this.config.secondsAlive(0);
                this.config.secondsHungry(0);
                this.config.secondsNeglected(0);
                this.config.lastAttentionType(KittenAttentionType.NEW_KITTEN);
                this.kittenSpawnedTime = Instant.now();
                this.kittenLastFedTime = Instant.now();
                this.kittenLastAttentionTime = Instant.now();
                this.addKittenGrowthBox(10800);
                this.addHungryTimer(1800);
                this.addAttentionTimer(2340);
            } else if (notificationText2.equals(DIALOG_CAT_GROWN)) {
                this.followerKind = FollowerKind.NORMAL_CAT;
                this.checkForNewFollower();
                this.infoBoxManager.removeIf(t -> t instanceof KittenAttentionTimer);
                this.infoBoxManager.removeIf(t -> t instanceof KittenHungryTimer);
            } else if (notificationText2.equals(DIALOG_CAT_OVERGROWN)) {
                this.followerKind = FollowerKind.OVERGROWN_CAT;
                this.checkForNewFollower();
            } else if (notificationText2.startsWith(DIALOG_AFTER_TAKING_A_GOOD_LOOK)) {
                int minutesIndex;
                String ageStr = notificationText2.substring(DIALOG_AFTER_TAKING_A_GOOD_LOOK.length());
                int end = ageStr.indexOf("And approximate time until");
                int hoursIndex = (ageStr = ageStr.substring(0, end)).indexOf("hours");
                if (hoursIndex < 0) {
                    hoursIndex = ageStr.indexOf("hour");
                }
                String hoursStr = "";
                if (hoursIndex > 0) {
                    hoursStr = ageStr.substring(0, hoursIndex);
                    hoursStr = hoursStr.trim();
                }
                if ((minutesIndex = ageStr.indexOf("minutes")) < 0) {
                    minutesIndex = ageStr.indexOf("minute");
                }
                String minutesStr = "";
                if (minutesIndex > 0) {
                    if (hoursIndex > 0) {
                        minutesStr = ageStr.substring(hoursIndex + "hours".length(), minutesIndex);
                        minutesStr = minutesStr.trim();
                    } else {
                        minutesStr = ageStr.substring(0, minutesIndex);
                        minutesStr = minutesStr.trim();
                    }
                }
                int hours = 0;
                int minutes = 0;
                if (StringUtils.isNotEmpty((CharSequence)hoursStr)) {
                    try {
                        hours = Integer.parseInt(hoursStr);
                    }
                    catch (NumberFormatException ex) {
                        log.debug(ex.getMessage());
                    }
                }
                if (StringUtils.isNotEmpty((CharSequence)minutesStr)) {
                    try {
                        minutes = Integer.parseInt(minutesStr);
                    }
                    catch (NumberFormatException ex) {
                        log.debug(ex.getMessage());
                    }
                }
                Duration timeSinceSpawn = Duration.between(this.kittenSpawnedTime, Instant.now());
                int secondsSinceSpawn = Math.toIntExact(timeSinceSpawn.getSeconds());
                int age = hours * 3600 + minutes * 60;
                this.timeSpendGrowing = age - secondsSinceSpawn;
                this.addKittenGrowthBox(10800 - age);
            }
        }
        if ((dialog = this.client.getWidget(193, 2)) != null && (notificationText = Text.removeTags((String)dialog.getText())).startsWith(DIALOG_HAND_OVER_CAT_CIVILIAN)) {
            this.kittenSpawnedTime = null;
            this.kittenLastFedTime = null;
            this.kittenLastAttentionTime = null;
            this.previousFollowerId = 0;
            this.config.felineId(0);
            this.infoBoxManager.removeIf(t -> t instanceof KittenGrowthTimer);
            this.infoBoxManager.removeIf(t -> t instanceof KittenHungryTimer);
            this.infoBoxManager.removeIf(t -> t instanceof KittenAttentionTimer);
            this.followerID = 0;
        }
    }

    @Subscribe
    private void onConfigChanged(ConfigChanged event) {
        int secondsSinceSpawn;
        Duration timeSinceSpawn;
        int secondsAlive;
        Duration timeAlive;
        if (!event.getGroup().equals("kittenConfig")) {
            return;
        }
        if (event.getKey().equals("kittenInfoBox")) {
            if (event.getNewValue().equals("true") && this.isKitten()) {
                this.timeSpendGrowing = this.config.secondsAlive();
                timeAlive = Duration.between(this.kittenSpawnedTime, Instant.now());
                secondsAlive = Math.toIntExact(timeAlive.getSeconds());
                this.addKittenGrowthBox(10800 - secondsAlive - this.timeSpendGrowing);
            }
            if (event.getNewValue().equals("false") && this.isKitten()) {
                this.infoBoxManager.removeIf(t -> t instanceof KittenGrowthTimer);
            }
        }
        if (event.getKey().equals("catInfoBox")) {
            if (event.getNewValue().equals("true") && this.isCat()) {
                this.timeSpendGrowing = this.config.secondsAlive();
                timeAlive = Duration.between(this.catSpawnedTime, Instant.now());
                secondsAlive = Math.toIntExact(timeAlive.getSeconds());
                this.addKittenGrowthBox(19800 - secondsAlive - this.timeSpendGrowing);
            }
            if (event.getNewValue().equals("false") && this.isCat()) {
                this.infoBoxManager.removeIf(t -> t instanceof KittenGrowthTimer);
            }
        }
        if (event.getKey().equals("kittenAttentionBox")) {
            if (event.getNewValue().equals("true")) {
                if (this.kittenLastAttentionTime != null) {
                    Duration timeAttention = Duration.between(this.kittenLastAttentionTime, Instant.now());
                    int secondsAttention = Math.toIntExact(timeAttention.getSeconds());
                    this.addAttentionTimer(1920 - secondsAttention);
                }
                if (this.kittenLastAttentionTime == null) {
                    this.timeNeglected = this.config.secondsNeglected();
                    timeSinceSpawn = Duration.between(this.kittenSpawnedTime, Instant.now());
                    secondsSinceSpawn = Math.toIntExact(timeSinceSpawn.getSeconds());
                    this.addAttentionTimer(1920 - this.timeNeglected - secondsSinceSpawn);
                }
            }
            if (event.getNewValue().equals("false")) {
                this.infoBoxManager.removeIf(t -> t instanceof KittenAttentionTimer);
            }
        }
        if (event.getKey().equals("kittenHungryBox")) {
            if (event.getNewValue().equals("true")) {
                if (this.kittenLastFedTime != null) {
                    Duration timeHungry = Duration.between(this.kittenLastFedTime, Instant.now());
                    int secondsHungry = Math.toIntExact(timeHungry.getSeconds());
                    this.addHungryTimer(1800 - secondsHungry);
                }
                if (this.kittenLastFedTime == null) {
                    this.timeHungry = this.config.secondsHungry();
                    timeSinceSpawn = Duration.between(this.kittenSpawnedTime, Instant.now());
                    secondsSinceSpawn = Math.toIntExact(timeSinceSpawn.getSeconds());
                    this.addHungryTimer(1800 - this.timeHungry - secondsSinceSpawn);
                }
            }
            if (event.getNewValue().equals("false")) {
                this.infoBoxManager.removeIf(t -> t instanceof KittenHungryTimer);
            }
        }
    }

    private void addDurationToTimers(Duration duration) {
        Duration timerDuration;
        if (duration == null) {
            return;
        }
        if (this.growthTimer != null) {
            timerDuration = this.growthTimer.getDuration();
            if (this.growthTimer != null && timerDuration != null) {
                this.growthTimer.setDuration(timerDuration.plus(duration));
            }
        }
        if (this.kittenAttentionTimer != null) {
            timerDuration = this.kittenAttentionTimer.getDuration();
            if (this.kittenAttentionTimer != null && timerDuration != null) {
                this.kittenAttentionTimer.setDuration(timerDuration.plus(duration));
            }
        }
        if (this.kittenHungryTimer != null) {
            timerDuration = this.kittenHungryTimer.getDuration();
            if (this.kittenHungryTimer != null && timerDuration != null) {
                this.kittenHungryTimer.setDuration(timerDuration.plus(duration));
            }
        }
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged event) {
        GameState state = event.getGameState();
        switch (state) {
            case LOGGING_IN: 
            case HOPPING: 
            case CONNECTION_LOST: {
                this.ready = true;
                break;
            }
            case LOGGED_IN: {
                if (!this.ready) break;
                this.ready = false;
                break;
            }
            case LOGIN_SCREEN: {
                this.byeFollower();
            }
        }
    }

    @Inject
    public boolean playerHasFollower() {
        return this.client.getVarpValue(447) > 0;
    }

    public boolean isKitten() {
        return this.followerKind.equals((Object)FollowerKind.KITTEN);
    }

    public Long getTimeUntilFullyGrown() {
        if (this.growthTimer == null) {
            return 0L;
        }
        if (this.isKitten()) {
            if (this.growthTimer.cull()) {
                return 0L;
            }
            return Math.abs(this.growthTimer.getEndTime().until(Instant.now(), ChronoUnit.MILLIS));
        }
        return 0L;
    }

    public boolean isCat() {
        return this.followerKind.equals((Object)FollowerKind.NORMAL_CAT);
    }

    public boolean isOverGrown() {
        return this.followerKind.equals((Object)FollowerKind.OVERGROWN_CAT);
    }

    public Long getTimeUntilOvergrown() {
        if (this.growthTimer == null) {
            return 0L;
        }
        long ret = Math.abs(this.growthTimer.getEndTime().until(Instant.now(), ChronoUnit.MILLIS));
        if (this.isCat()) {
            return ret;
        }
        return ret + 9000L;
    }

    public Long getTimeBeforeHungry() {
        if (this.kittenHungryTimer == null) {
            return 0L;
        }
        if (this.isKitten()) {
            if (this.kittenHungryTimer.cull()) {
                return 0L;
            }
            return Math.abs(this.kittenHungryTimer.getEndTime().until(Instant.now(), ChronoUnit.MILLIS));
        }
        return 0L;
    }

    public Long getTimeBeforeNeedingAttention() {
        if (this.kittenAttentionTimer == null) {
            return 0L;
        }
        if (this.isKitten()) {
            if (this.kittenAttentionTimer.cull()) {
                return 0L;
            }
            return Math.abs(this.kittenAttentionTimer.getEndTime().until(Instant.now(), ChronoUnit.MILLIS));
        }
        return 0L;
    }
}

