/*
 * Decompiled with CFR 0.152.
 */
package com.kittentracker;

import com.kittentracker.KittenConfig;
import com.kittentracker.KittenPlugin;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.font.TextAttribute;
import java.time.Duration;
import java.time.Instant;
import java.util.Collections;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.MenuAction;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.ui.overlay.OverlayMenuEntry;
import net.runelite.client.ui.overlay.OverlayPanel;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.components.LineComponent;
import org.apache.commons.lang3.time.DurationFormatUtils;

public class KittenOverlay
extends OverlayPanel {
    private final Client client;
    private final KittenPlugin kittenPlugin;
    private final KittenConfig kittenConfig;
    private Instant blinkHunger = null;
    private Instant blinkAttention = null;
    private static final int blinkPeriod = 1000;

    @Inject
    private KittenOverlay(Client client, KittenPlugin kittenPlugin, KittenConfig kittenConfig) {
        super((Plugin)kittenPlugin);
        this.setPosition(OverlayPosition.BOTTOM_LEFT);
        this.client = client;
        this.kittenPlugin = kittenPlugin;
        this.kittenConfig = kittenConfig;
        this.getMenuEntries().add(new OverlayMenuEntry(MenuAction.RUNELITE_OVERLAY_CONFIG, "Configure", "Kitten Tracker Overlay"));
        this.setPreferredSize(new Dimension(162, 88));
    }

    public Dimension render(Graphics2D graphics) {
        if (this.kittenPlugin.playerHasFollower() && (this.kittenPlugin.isKitten() || this.kittenPlugin.isCat())) {
            if (this.kittenPlugin.isKitten() && (this.kittenConfig.kittenOverlay() || this.kittenConfig.kittenHungryOverlay() || this.kittenConfig.kittenAttentionOverlay()) || this.kittenPlugin.isCat() && this.kittenConfig.catOverlay()) {
                this.panelComponent.getChildren().add(LineComponent.builder().leftFont(graphics.getFont().deriveFont(Collections.singletonMap(TextAttribute.WEIGHT, TextAttribute.WEIGHT_BOLD))).left(this.kittenPlugin.isKitten() ? "Kitten status" : "Cat status").build());
            }
            if (this.kittenPlugin.isKitten()) {
                Duration timeSinceLastBlink;
                Color color;
                if (this.kittenConfig.kittenOverlay()) {
                    LineComponent lineComponent = LineComponent.builder().left("Grown up in: ").right(DurationFormatUtils.formatDuration((long)this.kittenPlugin.getTimeUntilFullyGrown(), (String)this.getFormatForTime(), (boolean)true)).build();
                    this.panelComponent.getChildren().add(lineComponent);
                }
                if (this.kittenConfig.kittenHungryOverlay()) {
                    color = Color.WHITE;
                    Long timeUntilHungryMs = this.kittenPlugin.getTimeBeforeHungry();
                    if (timeUntilHungryMs < 60000L) {
                        if (this.blinkHunger == null) {
                            this.blinkHunger = Instant.now();
                        } else {
                            timeSinceLastBlink = Duration.between(this.blinkHunger, Instant.now());
                            if (timeSinceLastBlink.toMillis() > 2000L) {
                                this.blinkHunger = Instant.now();
                                color = Color.ORANGE;
                            } else {
                                color = timeSinceLastBlink.toMillis() > 1000L ? Color.ORANGE : Color.RED;
                            }
                        }
                    } else if (timeUntilHungryMs < 180000L) {
                        color = Color.RED;
                    } else if (timeUntilHungryMs < 360000L) {
                        color = Color.ORANGE;
                    }
                    this.panelComponent.getChildren().add(LineComponent.builder().left("Hungry in: ").rightColor(color).right(DurationFormatUtils.formatDuration((long)timeUntilHungryMs, (String)this.getFormatForTime(), (boolean)true)).build());
                }
                if (this.kittenConfig.kittenAttentionOverlay()) {
                    color = Color.WHITE;
                    Long timeBeforeNeedingAttention = this.kittenPlugin.getTimeBeforeNeedingAttention();
                    if (timeBeforeNeedingAttention < 60000L) {
                        if (this.blinkAttention == null) {
                            this.blinkAttention = Instant.now();
                        } else {
                            timeSinceLastBlink = Duration.between(this.blinkAttention, Instant.now());
                            if (timeSinceLastBlink.toMillis() > 2000L) {
                                this.blinkAttention = Instant.now();
                                color = Color.ORANGE;
                            } else {
                                color = timeSinceLastBlink.toMillis() > 1000L ? Color.ORANGE : Color.RED;
                            }
                        }
                    } else if (timeBeforeNeedingAttention < 420000L) {
                        color = Color.RED;
                    } else if (timeBeforeNeedingAttention < 840000L) {
                        color = Color.ORANGE;
                    }
                    this.panelComponent.getChildren().add(LineComponent.builder().left("Needs attention in: ").rightColor(color).right(DurationFormatUtils.formatDuration((long)timeBeforeNeedingAttention, (String)this.getFormatForTime(), (boolean)true)).build());
                }
            } else if (this.kittenPlugin.isOverGrown()) {
                if (this.kittenConfig.catOverlay()) {
                    this.panelComponent.getChildren().add(LineComponent.builder().left("You have an overgrown cat.").build());
                }
            } else if (this.kittenConfig.catOverlay()) {
                this.panelComponent.getChildren().add(LineComponent.builder().left("Overgrown in: ").right(DurationFormatUtils.formatDuration((long)this.kittenPlugin.getTimeUntilOvergrown(), (String)this.getFormatForTime(), (boolean)true)).build());
            }
        }
        return super.render(graphics);
    }

    private String getFormatForTime() {
        if (this.kittenConfig.displaySeconds()) {
            return "H:mm:ss";
        }
        return "H:mm";
    }
}

