/*
 * Decompiled with CFR 0.152.
 */
package thestonedturtle.bosshpreorder;

import com.google.inject.Provides;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.events.ScriptPostFired;
import net.runelite.api.events.VarbitChanged;
import net.runelite.api.widgets.Widget;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import thestonedturtle.bosshpreorder.BossHpReorderConfig;

@PluginDescriptor(name="Boss HP Reorder")
public class BossHpReorderPlugin
extends Plugin {
    private static final String RUNELITE_GROUP_KEY = "runelite";
    private static final String POSITION_KEY = "_preferredPosition";
    private static final String LOCATION_KEY = "_preferredLocation";
    private static final String HP_BAR_NAME = "HEALTH_OVERLAY_BAR";
    private static final int XP_DROPS_SHOWN_VARBIT = 4702;
    private static final int HP_BAR_TEXT_UPDATE_SCRIPT_ID = 2102;
    @Inject
    private Client client;
    @Inject
    private ClientThread clientThread;
    @Inject
    private ConfigManager configManager;
    @Inject
    private BossHpReorderConfig config;

    @Provides
    BossHpReorderConfig provideConfig(ConfigManager configManager) {
        return (BossHpReorderConfig)configManager.getConfig(BossHpReorderConfig.class);
    }

    protected void startUp() throws Exception {
        String position = this.configManager.getConfiguration(RUNELITE_GROUP_KEY, "HEALTH_OVERLAY_BAR_preferredPosition");
        String location = this.configManager.getConfiguration(RUNELITE_GROUP_KEY, "HEALTH_OVERLAY_BAR_preferredLocation");
        if (location != null) {
            return;
        }
        this.clientThread.invoke(() -> this.adjustHealthBarLocation(position));
    }

    protected void shutDown() throws Exception {
        this.resetWidgetPositions();
    }

    @Subscribe
    public void onVarbitChanged(VarbitChanged e) {
        if (this.client.getGameState() != GameState.LOGGED_IN) {
            return;
        }
        if (this.configManager.getConfiguration(RUNELITE_GROUP_KEY, "HEALTH_OVERLAY_BAR_preferredLocation") != null) {
            return;
        }
        if (e.getVarbitId() == 4702 || e.getVarbitId() == 4692 || e.getVarbitId() == 12389) {
            this.clientThread.invoke(() -> this.adjustHealthBarLocation(this.configManager.getConfiguration(RUNELITE_GROUP_KEY, "HEALTH_OVERLAY_BAR_preferredPosition")));
        }
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged e) {
        if (e.getGroup().equals("bosshpreorder")) {
            if (this.configManager.getConfiguration(RUNELITE_GROUP_KEY, "HEALTH_OVERLAY_BAR_preferredLocation") != null) {
                return;
            }
            this.clientThread.invoke(() -> this.adjustHealthBarLocation(this.configManager.getConfiguration(RUNELITE_GROUP_KEY, "HEALTH_OVERLAY_BAR_preferredPosition")));
            return;
        }
        if (!e.getGroup().equals(RUNELITE_GROUP_KEY)) {
            return;
        }
        if (e.getKey().equals("HEALTH_OVERLAY_BAR_preferredPosition")) {
            this.clientThread.invoke(() -> this.adjustHealthBarLocation(e.getNewValue()));
        } else if (e.getKey().equals("HEALTH_OVERLAY_BAR_preferredLocation") && e.getNewValue() != null) {
            this.resetWidgetPositions();
        }
    }

    @Subscribe
    private void onScriptPostFired(ScriptPostFired e) {
        if (e.getScriptId() != 2102) {
            return;
        }
        if (this.configManager.getConfiguration(RUNELITE_GROUP_KEY, "HEALTH_OVERLAY_BAR_preferredLocation") != null) {
            return;
        }
        this.clientThread.invoke(() -> this.adjustHealthBarLocation(this.configManager.getConfiguration(RUNELITE_GROUP_KEY, "HEALTH_OVERLAY_BAR_preferredPosition")));
    }

    private void adjustHealthBarLocation(String newVal) {
        if (this.client.getVarbitValue(4702) == 0 || this.client.getVarbitValue(12389) == 1) {
            this.resetWidgetPositions();
            return;
        }
        int xpLoc = this.client.getVarbitValue(4692);
        if (xpLoc != 1) {
            this.resetWidgetPositions();
            return;
        }
        Widget hpContainer = this.client.getWidget(303, 4);
        Widget hpBar = this.client.getWidget(WidgetInfo.HEALTH_OVERLAY_BAR);
        if (hpContainer == null || hpBar == null) {
            this.resetWidgetPositions();
            return;
        }
        Widget xpTrackerContainer = this.client.getWidget(122, 3);
        Widget xpTracker = this.client.getWidget(122, 4);
        if (xpTrackerContainer == null || xpTracker == null) {
            this.resetWidgetPositions();
            return;
        }
        if (newVal == null || newVal.equals("TOP_RIGHT") || newVal.equals("TOP_LEFT")) {
            xpTrackerContainer.setForcedPosition(xpTrackerContainer.getRelativeX(), this.config.barOffset());
            hpContainer.setForcedPosition(hpContainer.getRelativeX(), this.config.barOffset());
            if (newVal == null) {
                xpTracker.setForcedPosition(xpTracker.getRelativeX(), hpBar.getHeight());
            } else {
                xpTracker.setForcedPosition(-1, -1);
            }
        } else {
            this.resetWidgetPositions();
        }
    }

    private void resetWidgetPositions() {
        Widget xpTrackerContainer = this.client.getWidget(122, 3);
        Widget xpTracker = this.client.getWidget(122, 4);
        Widget hpContainer = this.client.getWidget(303, 4);
        this.resetWidgetForcedPosition(xpTrackerContainer);
        this.resetWidgetForcedPosition(xpTracker);
        this.resetWidgetForcedPosition(hpContainer);
    }

    private void resetWidgetForcedPosition(Widget w) {
        if (w == null) {
            return;
        }
        w.setForcedPosition(-1, -1);
    }
}

