/*
 * Decompiled with CFR 0.152.
 */
package codepanter.anotherbronzemanmode;

import codepanter.anotherbronzemanmode.AnotherBronzemanModeConfig;
import codepanter.anotherbronzemanmode.AnotherBronzemanModeOverlay;
import com.google.common.collect.ImmutableSet;
import com.google.common.reflect.TypeToken;
import com.google.common.util.concurrent.Runnables;
import com.google.inject.Provides;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Scanner;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import net.runelite.api.ChatMessageType;
import net.runelite.api.ChatPlayer;
import net.runelite.api.Client;
import net.runelite.api.FriendContainer;
import net.runelite.api.FriendsChatManager;
import net.runelite.api.FriendsChatMember;
import net.runelite.api.GameState;
import net.runelite.api.IconID;
import net.runelite.api.IndexedSprite;
import net.runelite.api.InventoryID;
import net.runelite.api.Item;
import net.runelite.api.ItemComposition;
import net.runelite.api.ItemContainer;
import net.runelite.api.MessageNode;
import net.runelite.api.Player;
import net.runelite.api.ScriptEvent;
import net.runelite.api.WorldType;
import net.runelite.api.events.ChatMessage;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.ItemContainerChanged;
import net.runelite.api.events.MenuOptionClicked;
import net.runelite.api.events.ScriptCallbackEvent;
import net.runelite.api.events.ScriptPostFired;
import net.runelite.api.events.WidgetLoaded;
import net.runelite.api.widgets.Widget;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.client.Notifier;
import net.runelite.client.RuneLite;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.chat.ChatColorType;
import net.runelite.client.chat.ChatCommandManager;
import net.runelite.client.chat.ChatMessageBuilder;
import net.runelite.client.chat.ChatMessageManager;
import net.runelite.client.chat.QueuedMessage;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.events.PluginChanged;
import net.runelite.client.game.ItemManager;
import net.runelite.client.game.WorldService;
import net.runelite.client.game.chatbox.ChatboxPanelManager;
import net.runelite.client.game.chatbox.ChatboxTextInput;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import net.runelite.client.util.ImageUtil;
import net.runelite.client.util.Text;
import net.runelite.http.api.RuneLiteAPI;
import net.runelite.http.api.worlds.World;
import net.runelite.http.api.worlds.WorldResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Another Bronzeman Mode", description="Limits access to buying an item on the Grand Exchange until it is obtained otherwise.", tags={"overlay", "bronzeman"})
public class AnotherBronzemanModePlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(AnotherBronzemanModePlugin.class);
    static final String CONFIG_GROUP = "anotherbronzemanmode";
    private static final String BM_UNLOCKS_STRING = "!bmunlocks";
    private static final String BM_COUNT_STRING = "!bmcount";
    private static final String BM_RESET_STRING = "!bmreset";
    private static final String BM_BACKUP_STRING = "!bmbackup";
    final int COMBAT_ACHIEVEMENT_BUTTON = 20;
    final int COLLECTION_LOG_GROUP_ID = 621;
    final int COLLECTION_VIEW = 36;
    final int COLLECTION_VIEW_SCROLLBAR = 37;
    final int COLLECTION_VIEW_HEADER = 19;
    final int COLLECTION_VIEW_CATEGORIES_CONTAINER = 28;
    final int COLLECTION_VIEW_CATEGORIES_RECTANGLE = 33;
    final int COLLECTION_VIEW_CATEGORIES_TEXT = 34;
    final int COLLECTION_VIEW_CATEGORIES_SCROLLBAR = 28;
    final int MENU_INSPECT = 2;
    final int MENU_DELETE = 3;
    final int SELECTED_OPACITY = 200;
    final int UNSELECTED_OPACITY = 235;
    private static final int GE_SEARCH_RESULTS = 50;
    private static final int GE_SEARCH_BUILD_SCRIPT = 751;
    private static final int COLLECTION_LOG_OPEN_OTHER = 2728;
    private static final int COLLECTION_LOG_DRAW_LIST = 2730;
    private static final int COLLECTION_LOG_ITEM_CLICK = 2733;
    static final Set<Integer> OWNED_INVENTORY_IDS = ImmutableSet.of((Object)0, (Object)93, (Object)94, (Object)95, (Object)141, (Object)390, (Object[])new Integer[]{581, 612, 626});
    @Inject
    private Client client;
    @Inject
    private ChatboxPanelManager chatboxPanelManager;
    @Inject
    private Notifier notifier;
    @Inject
    private ClientThread clientThread;
    @Inject
    private ItemManager itemManager;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private WorldService worldService;
    @Inject
    private ConfigManager configManager;
    @Inject
    private ChatMessageManager chatMessageManager;
    @Inject
    private ChatCommandManager chatCommandManager;
    @Inject
    private AnotherBronzemanModeConfig config;
    @Inject
    private AnotherBronzemanModeOverlay AnotherBronzemanModeOverlay;
    private List<Integer> unlockedItems;
    private BufferedImage unlockImage = null;
    private static final String SCRIPT_EVENT_SET_CHATBOX_INPUT = "setChatboxInput";
    private ChatboxTextInput searchInput;
    private Widget searchButton;
    private Collection<Widget> itemEntries;
    private List<String> namesBronzeman = new ArrayList<String>();
    private int bronzemanIconOffset = -1;
    private boolean onSeasonalWorld;
    private boolean deleteConfirmed = false;
    private File legacyFile;
    private File legacyFolder;
    private File profileFile;
    private File profileFolder;
    private String profileKey;

    @Provides
    AnotherBronzemanModeConfig provideConfig(ConfigManager configManager) {
        return (AnotherBronzemanModeConfig)configManager.getConfig(AnotherBronzemanModeConfig.class);
    }

    protected void startUp() throws Exception {
        super.startUp();
        this.onSeasonalWorld = false;
        this.updateNamesBronzeman();
        this.updateScreenshotUnlock();
        this.loadResources();
        this.unlockedItems = new ArrayList<Integer>();
        this.overlayManager.add((Overlay)this.AnotherBronzemanModeOverlay);
        this.chatCommandManager.registerCommand(BM_UNLOCKS_STRING, this::OnUnlocksCountCommand);
        this.chatCommandManager.registerCommand(BM_COUNT_STRING, this::OnUnlocksCountCommand);
        this.chatCommandManager.registerCommand(BM_BACKUP_STRING, this::OnUnlocksBackupCommand);
        if (this.config.resetCommand()) {
            this.chatCommandManager.registerCommand(BM_RESET_STRING, this::OnUnlocksResetCommand);
        }
        this.clientThread.invoke(() -> {
            if (this.client.getGameState() == GameState.LOGGED_IN) {
                this.onSeasonalWorld = this.isSeasonalWorld(this.client.getWorld());
                if (!this.onSeasonalWorld) {
                    this.setChatboxName(this.getNameChatbox());
                }
            }
        });
    }

    protected void shutDown() throws Exception {
        super.shutDown();
        this.itemEntries = null;
        this.unlockedItems = null;
        this.overlayManager.remove((Overlay)this.AnotherBronzemanModeOverlay);
        this.chatCommandManager.unregisterCommand(BM_UNLOCKS_STRING);
        this.chatCommandManager.unregisterCommand(BM_COUNT_STRING);
        this.chatCommandManager.unregisterCommand(BM_BACKUP_STRING);
        if (this.config.resetCommand()) {
            this.chatCommandManager.unregisterCommand(BM_RESET_STRING);
        }
        this.clientThread.invoke(() -> {
            if (this.client.getGameState() == GameState.LOGGED_IN && !this.onSeasonalWorld) {
                this.setChatboxName(this.getNameDefault());
            }
        });
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged e) {
        if (e.getGameState() == GameState.LOGGED_IN) {
            this.setupUnlockHistory();
            this.loadPlayerUnlocks();
            this.loadResources();
            this.onSeasonalWorld = this.isSeasonalWorld(this.client.getWorld());
        }
        if (e.getGameState() == GameState.LOGIN_SCREEN) {
            this.itemEntries = null;
        }
    }

    @Subscribe
    public void onPluginChanged(PluginChanged e) {
        if (e.getPlugin() == this && this.client.getGameState() == GameState.LOGGED_IN) {
            this.setupUnlockHistory();
            this.loadPlayerUnlocks();
        }
    }

    @Subscribe
    public void onWidgetLoaded(WidgetLoaded e) {
        if (e.getGroupId() != 621 || this.config.moveCollectionLogUnlocks()) {
            return;
        }
        Widget collectionViewHeader = this.client.getWidget(621, 19);
        this.openBronzemanCategory(collectionViewHeader);
    }

    @Subscribe
    public void onItemContainerChanged(ItemContainerChanged e) {
        if (OWNED_INVENTORY_IDS.contains(e.getContainerId())) {
            this.unlockItemContainerItems(e.getItemContainer());
        }
    }

    @Subscribe
    public void onScriptPostFired(ScriptPostFired event) {
        if (event.getScriptId() == 751) {
            this.killSearchResults();
        }
        if ((event.getScriptId() == 2728 || event.getScriptId() == 2733 || event.getScriptId() == 2730) && this.config.moveCollectionLogUnlocks()) {
            this.addBronzemanCategory();
        }
    }

    @Subscribe
    public void onMenuOptionClicked(MenuOptionClicked event) {
        if ((event.getMenuOption().equals("Trade with") || event.getMenuOption().equals("Accept trade")) && !this.config.allowTrading()) {
            event.consume();
            this.sendChatMessage("You are a bronzeman. You stand alone...Sort of.");
            return;
        }
    }

    @Subscribe
    public void onScriptCallbackEvent(ScriptCallbackEvent scriptCallbackEvent) {
        if (scriptCallbackEvent.getEventName().equals(SCRIPT_EVENT_SET_CHATBOX_INPUT) && !this.onSeasonalWorld) {
            this.setChatboxName(this.getNameChatbox());
        }
    }

    @Subscribe
    public void onChatMessage(ChatMessage chatMessage) {
        if (this.client.getGameState() != GameState.LOADING && this.client.getGameState() != GameState.LOGGED_IN) {
            return;
        }
        String name = Text.removeTags((String)chatMessage.getName());
        switch (chatMessage.getType()) {
            case PRIVATECHAT: 
            case MODPRIVATECHAT: 
            case FRIENDSCHAT: {
                if (!this.isChatPlayerOnNormalWorld(name) || !this.isChatPlayerBronzeman(name)) break;
                this.addBronzemanIconToMessage(chatMessage);
                break;
            }
            case PUBLICCHAT: 
            case MODCHAT: {
                if (this.onSeasonalWorld || !this.isChatPlayerBronzeman(name)) break;
                this.addBronzemanIconToMessage(chatMessage);
            }
        }
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged event) {
        if (event.getGroup().equals(CONFIG_GROUP)) {
            if (event.getKey().equals("namesBronzeman")) {
                this.updateNamesBronzeman();
            } else if (event.getKey().equals("screenshotUnlock") || event.getKey().equals("includeFrame")) {
                this.updateScreenshotUnlock();
            } else if (event.getKey().equals("resetCommand")) {
                if (this.config.resetCommand()) {
                    this.chatCommandManager.registerCommand(BM_RESET_STRING, this::OnUnlocksResetCommand);
                } else {
                    this.chatCommandManager.unregisterCommand(BM_RESET_STRING);
                }
            }
        }
    }

    private void openBronzemanCategory(Widget widget) {
        widget.setOpacity(200);
        this.itemEntries = null;
        this.clientThread.invokeLater(() -> {
            Widget collectionViewHeader = this.client.getWidget(621, 19);
            Widget combatAchievementsButton = this.client.getWidget(621, 20);
            combatAchievementsButton.setHidden(true);
            Widget[] headerComponents = collectionViewHeader.getDynamicChildren();
            headerComponents[0].setText("Bronzeman Unlocks");
            headerComponents[1].setText("Unlocks: <col=ff0000>" + Integer.toString(this.unlockedItems.size()));
            if (headerComponents.length > 2) {
                headerComponents[2].setText("");
            }
            this.createSearchButton(collectionViewHeader);
            Widget collectionView = this.client.getWidget(621, 36);
            Widget scrollbar = this.client.getWidget(621, 37);
            collectionView.deleteAllChildren();
            int index = 0;
            int x = 0;
            int y = 0;
            int yIncrement = 40;
            int xIncrement = 42;
            for (Integer itemId : this.unlockedItems) {
                boolean tradeable = this.itemManager.getItemComposition(itemId.intValue()).isTradeable();
                if (this.config.hideUntradeables() && !tradeable) continue;
                this.addItemToCollectionLog(collectionView, itemId, x, y, index);
                ++index;
                if ((x += xIncrement) <= 210) continue;
                x = 0;
                y += yIncrement;
            }
            collectionView.setScrollHeight(y + 43);
            int scrollHeight = collectionView.getScrollY() * y / collectionView.getScrollHeight();
            collectionView.revalidateScroll();
            this.client.runScript(new Object[]{72, scrollbar.getId(), collectionView.getId(), scrollHeight});
            collectionView.setScrollY(0);
            scrollbar.setScrollY(0);
        });
    }

    private void createSearchButton(Widget header) {
        this.searchButton = header.createChild(-1, 5);
        this.searchButton.setSpriteId(1113);
        this.searchButton.setOriginalWidth(18);
        this.searchButton.setOriginalHeight(17);
        this.searchButton.setXPositionMode(2);
        this.searchButton.setOriginalX(5);
        this.searchButton.setOriginalY(20);
        this.searchButton.setHasListener(true);
        this.searchButton.setAction(1, "Open");
        this.searchButton.setOnOpListener(new Object[]{e -> this.openSearch()});
        this.searchButton.setName("Search");
        this.searchButton.revalidate();
    }

    private void openSearch() {
        this.updateFilter("");
        this.client.playSoundEffect(2266);
        this.searchButton.setAction(1, "Close");
        this.searchButton.setOnOpListener(new Object[]{e -> this.closeSearch()});
        this.searchInput = this.chatboxPanelManager.openTextInput("Search unlock list").onChanged(s -> this.clientThread.invokeLater(() -> this.updateFilter(s.trim()))).onClose(() -> {
            this.clientThread.invokeLater(() -> this.updateFilter(""));
            this.searchButton.setOnOpListener(new Object[]{e -> this.openSearch()});
            this.searchButton.setAction(1, "Open");
        }).build();
    }

    private void closeSearch() {
        this.updateFilter("");
        this.chatboxPanelManager.close();
        this.client.playSoundEffect(2266);
    }

    private void updateFilter(String input) {
        Widget collectionView = this.client.getWidget(621, 36);
        if (collectionView == null) {
            return;
        }
        String filter = input.toLowerCase();
        this.updateList(collectionView, filter);
    }

    private void updateList(Widget collectionView, String filter) {
        if (this.itemEntries == null) {
            this.itemEntries = Arrays.stream(collectionView.getDynamicChildren()).sorted(Comparator.comparing(Widget::getRelativeY)).collect(Collectors.toList());
        }
        this.itemEntries.forEach(w -> w.setHidden(true));
        Collection matchingItems = this.itemEntries.stream().filter(w -> w.getName().toLowerCase().contains(filter)).collect(Collectors.toList());
        int x = 0;
        int y = 0;
        for (Widget entry : matchingItems) {
            entry.setHidden(false);
            entry.setOriginalY(y);
            entry.setOriginalX(x);
            entry.revalidate();
            if ((x += 42) <= 210) continue;
            x = 0;
            y += 40;
        }
        y += 43;
        int newHeight = 0;
        if (collectionView.getScrollHeight() > 0) {
            newHeight = collectionView.getScrollY() * y / collectionView.getScrollHeight();
        }
        collectionView.setScrollHeight(y);
        collectionView.revalidateScroll();
        Widget scrollbar = this.client.getWidget(621, 37);
        this.client.runScript(new Object[]{72, scrollbar.getId(), collectionView.getId(), newHeight});
    }

    private void addItemToCollectionLog(Widget collectionView, Integer itemId, int x, int y, int index) {
        String itemName = this.itemManager.getItemComposition(itemId.intValue()).getName();
        Widget newItem = collectionView.createChild(index, 5);
        newItem.setContentType(0);
        newItem.setItemId(itemId.intValue());
        newItem.setItemQuantity(1);
        newItem.setItemQuantityMode(0);
        newItem.setModelId(-1);
        newItem.setModelType(1);
        newItem.setSpriteId(-1);
        newItem.setBorderType(1);
        newItem.setFilled(false);
        newItem.setOriginalX(x);
        newItem.setOriginalY(y);
        newItem.setOriginalWidth(36);
        newItem.setOriginalHeight(32);
        newItem.setHasListener(true);
        newItem.setAction(1, "Inspect");
        newItem.setAction(2, "Remove");
        newItem.setOnOpListener(new Object[]{e -> this.handleItemAction(itemId, itemName, e)});
        newItem.setName(itemName);
        newItem.revalidate();
    }

    private void makeBronzemanWidget(Widget categories, Widget template, int position, int originalY) {
        Widget bronzemanUnlocks = categories.createChild(position, template.getType());
        bronzemanUnlocks.setText("Bronzeman Unlocks");
        bronzemanUnlocks.setName("<col=ff9040>Bronzeman Unlocks</col>");
        bronzemanUnlocks.setOpacity(235);
        if (template.hasListener()) {
            bronzemanUnlocks.setHasListener(true);
            bronzemanUnlocks.setAction(1, "View");
            bronzemanUnlocks.setOnOpListener(new Object[]{e -> this.openBronzemanCategory(bronzemanUnlocks)});
        }
        bronzemanUnlocks.setBorderType(template.getBorderType());
        bronzemanUnlocks.setItemId(template.getItemId());
        bronzemanUnlocks.setSpriteId(template.getSpriteId());
        bronzemanUnlocks.setOriginalHeight(template.getOriginalHeight());
        bronzemanUnlocks.setOriginalWidth(template.getOriginalWidth());
        bronzemanUnlocks.setOriginalX(template.getOriginalX());
        bronzemanUnlocks.setOriginalY(originalY);
        bronzemanUnlocks.setXPositionMode(template.getXPositionMode());
        bronzemanUnlocks.setYPositionMode(template.getYPositionMode());
        bronzemanUnlocks.setContentType(template.getContentType());
        bronzemanUnlocks.setItemQuantity(template.getItemQuantity());
        bronzemanUnlocks.setItemQuantityMode(template.getItemQuantityMode());
        bronzemanUnlocks.setModelId(template.getModelId());
        bronzemanUnlocks.setModelType(template.getModelType());
        bronzemanUnlocks.setBorderType(template.getBorderType());
        bronzemanUnlocks.setFilled(template.isFilled());
        bronzemanUnlocks.setTextColor(template.getTextColor());
        bronzemanUnlocks.setFontId(template.getFontId());
        bronzemanUnlocks.setTextShadowed(template.getTextShadowed());
        bronzemanUnlocks.setWidthMode(template.getWidthMode());
        bronzemanUnlocks.setYTextAlignment(template.getYTextAlignment());
        bronzemanUnlocks.revalidate();
    }

    private void handleItemAction(Integer itemId, String itemName, ScriptEvent event) {
        switch (event.getOp()) {
            case 2: {
                ChatMessageBuilder examination = new ChatMessageBuilder().append(ChatColorType.NORMAL).append("This is an unlocked item called '" + itemName + "'.");
                this.chatMessageManager.queue(QueuedMessage.builder().type(ChatMessageType.ITEM_EXAMINE).runeLiteFormattedMessage(examination.build()).build());
                break;
            }
            case 3: {
                this.clientThread.invokeLater(() -> this.confirmDeleteItem(itemId, itemName));
            }
        }
    }

    private void confirmDeleteItem(Integer itemId, String itemName) {
        this.chatboxPanelManager.openTextMenuInput("Do you want to re-lock: " + itemName).option("1. Confirm re-locking of item", () -> this.clientThread.invoke(() -> {
            this.deleteConfirmed = true;
            this.queueItemDelete(itemId);
            this.sendChatMessage("Item '" + itemName + "' is no longer unlocked.");
            this.deleteConfirmed = false;
        })).option("2. Cancel", Runnables::doNothing).build();
    }

    public void unlockItemContainerItems(ItemContainer itemContainer) {
        for (Item i : itemContainer.getItems()) {
            int itemId = i.getId();
            int realItemId = this.itemManager.canonicalize(itemId);
            ItemComposition itemComposition = this.itemManager.getItemComposition(itemId);
            int noteId = itemComposition.getNote();
            boolean tradeable = itemComposition.isTradeable();
            if (itemId != realItemId && noteId != 799 || i.getId() <= 1 || i.getQuantity() <= 0 || this.unlockedItems.contains(realItemId)) continue;
            this.queueItemUnlock(realItemId);
            if (this.config.hideUntradeables() && !tradeable) continue;
            if (this.config.sendNotification()) {
                this.notifier.notify("You have unlocked a new item: " + this.client.getItemDefinition(realItemId).getName() + ".");
                continue;
            }
            if (!this.config.sendChatMessage()) continue;
            this.sendChatMessage("You have unlocked a new item: " + this.client.getItemDefinition(realItemId).getName() + ".");
        }
    }

    public void queueItemUnlock(int itemId) {
        this.unlockedItems.add(itemId);
        boolean tradeable = this.itemManager.getItemComposition(itemId).isTradeable();
        if (!this.config.hideUntradeables() || tradeable) {
            this.AnotherBronzemanModeOverlay.addItemUnlock(itemId);
        }
        this.savePlayerUnlocks();
    }

    public void queueItemDelete(int itemId) {
        this.unlockedItems.remove((Object)itemId);
        this.savePlayerUnlocks();
    }

    private void unlockDefaultItems() {
        this.queueItemUnlock(995);
        this.queueItemUnlock(13190);
    }

    private void sendChatMessage(String chatMessage) {
        String message = new ChatMessageBuilder().append(ChatColorType.HIGHLIGHT).append(chatMessage).build();
        this.chatMessageManager.queue(QueuedMessage.builder().type(ChatMessageType.CONSOLE).runeLiteFormattedMessage(message).build());
    }

    void addBronzemanWidget(int widgetId) {
        Widget logCategories = this.client.getWidget(621, widgetId);
        Widget[] categoryElements = logCategories.getDynamicChildren();
        if (categoryElements.length == 0) {
            return;
        }
        Widget aerialFishing = categoryElements[0];
        if (!aerialFishing.getText().contains("Aerial Fishing") && !aerialFishing.getName().contains("Aerial Fishing")) {
            return;
        }
        if (categoryElements[categoryElements.length - 1].getText().contains("Bronzeman Unlocks")) {
            categoryElements[categoryElements.length - 1].setOpacity(235);
            return;
        }
        int originalY = categoryElements.length * 15;
        this.makeBronzemanWidget(logCategories, aerialFishing, categoryElements.length, originalY);
        logCategories.setHeightMode(0);
        logCategories.setOriginalHeight(originalY + 18);
        logCategories.revalidate();
    }

    void updateContainerScroll() {
        Widget categoryContainer = this.client.getWidget(621, 28);
        Widget logCategories = this.client.getWidget(621, 33);
        Widget[] categoryElements = logCategories.getDynamicChildren();
        int originalHeight = 315;
        int scrollHeight = categoryElements.length * 18;
        int newHeight = 0;
        if (categoryContainer.getScrollHeight() > 0 && categoryContainer.getScrollHeight() != scrollHeight) {
            newHeight = categoryContainer.getScrollY() * scrollHeight / categoryContainer.getScrollHeight();
        }
        categoryContainer.setHeightMode(0);
        categoryContainer.setOriginalHeight(originalHeight);
        categoryContainer.setScrollHeight(scrollHeight);
        categoryContainer.revalidate();
        categoryContainer.revalidateScroll();
        Widget scrollbar = this.client.getWidget(621, 28);
        this.client.runScript(new Object[]{72, scrollbar.getId(), categoryContainer.getId(), newHeight});
    }

    void addBronzemanCategory() {
        this.clientThread.invokeLater(() -> {
            this.addBronzemanWidget(34);
            this.addBronzemanWidget(33);
            this.updateContainerScroll();
        });
    }

    void killSearchResults() {
        Widget grandExchangeSearchResults = this.client.getWidget(162, 50);
        if (grandExchangeSearchResults == null) {
            return;
        }
        Widget[] children = grandExchangeSearchResults.getDynamicChildren();
        if (children == null || children.length < 2 || children.length % 3 != 0) {
            return;
        }
        for (int i = 0; i < children.length; i += 3) {
            if (this.unlockedItems.contains(children[i + 2].getItemId())) continue;
            children[i].setHidden(true);
            children[i + 1].setOpacity(70);
            children[i + 2].setOpacity(70);
        }
    }

    private void savePlayerUnlocks() {
        try {
            PrintWriter w = new PrintWriter(this.profileFile);
            String json = RuneLiteAPI.GSON.toJson(this.unlockedItems);
            w.println(json);
            w.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void loadPlayerUnlocks() {
        this.unlockedItems.clear();
        try {
            String json = new Scanner(this.profileFile).useDelimiter("\\Z").next();
            this.unlockedItems.addAll((Collection)RuneLiteAPI.GSON.fromJson(json, new TypeToken<List<Integer>>(){}.getType()));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void updateNamesBronzeman() {
        this.namesBronzeman = Text.fromCSV((String)this.config.namesBronzeman());
    }

    private void updateScreenshotUnlock() {
        boolean screenshotUnlock = this.config.screenshotUnlock();
        boolean includeFrame = this.config.includeFrame();
        this.AnotherBronzemanModeOverlay.updateScreenshotUnlock(screenshotUnlock, includeFrame);
    }

    private void addBronzemanIconToMessage(ChatMessage chatMessage) {
        String name = chatMessage.getName();
        if (!name.equals(Text.removeTags((String)name))) {
            return;
        }
        MessageNode messageNode = chatMessage.getMessageNode();
        messageNode.setName(AnotherBronzemanModePlugin.getNameWithIcon(this.bronzemanIconOffset, name));
        this.client.refreshChat();
    }

    private boolean isSeasonalWorld(int worldNumber) {
        WorldResult worlds = this.worldService.getWorlds();
        if (worlds == null) {
            return false;
        }
        World world = worlds.findWorld(worldNumber);
        return world != null && world.getTypes().contains(WorldType.SEASONAL);
    }

    private boolean sentByPlayer(ChatMessage chatMessage) {
        MessageNode messageNode = chatMessage.getMessageNode();
        return Text.sanitize((String)messageNode.getName()).equals(Text.sanitize((String)this.client.getLocalPlayer().getName()));
    }

    private void setChatboxName(String name) {
        String text;
        int idx;
        Widget chatboxInput = this.client.getWidget(WidgetInfo.CHATBOX_INPUT);
        if (chatboxInput != null && (idx = (text = chatboxInput.getText()).indexOf(58)) != -1) {
            String newText = name + text.substring(idx);
            chatboxInput.setText(newText);
        }
    }

    private String getNameChatbox() {
        Player player = this.client.getLocalPlayer();
        if (player != null) {
            return AnotherBronzemanModePlugin.getNameWithIcon(this.bronzemanIconOffset, player.getName());
        }
        return null;
    }

    private String getNameDefault() {
        int iconIndex;
        Player player = this.client.getLocalPlayer();
        if (player == null) {
            return null;
        }
        switch (this.client.getAccountType()) {
            case IRONMAN: {
                iconIndex = IconID.IRONMAN.getIndex();
                break;
            }
            case HARDCORE_IRONMAN: {
                iconIndex = IconID.HARDCORE_IRONMAN.getIndex();
                break;
            }
            case ULTIMATE_IRONMAN: {
                iconIndex = IconID.ULTIMATE_IRONMAN.getIndex();
                break;
            }
            default: {
                return player.getName();
            }
        }
        return AnotherBronzemanModePlugin.getNameWithIcon(iconIndex, player.getName());
    }

    private static String getNameWithIcon(int iconIndex, String name) {
        String icon = "<img=" + iconIndex + ">";
        return icon + name;
    }

    private ChatPlayer getChatPlayerFromName(String name) {
        FriendsChatMember friendsChatMember;
        FriendsChatManager friendsChatManager = this.client.getFriendsChatManager();
        if (friendsChatManager != null && (friendsChatMember = (FriendsChatMember)friendsChatManager.findByName(name)) != null) {
            return friendsChatMember;
        }
        FriendContainer friendContainer = this.client.getFriendContainer();
        return (ChatPlayer)friendContainer.findByName(name);
    }

    private boolean isChatPlayerBronzeman(String name) {
        return this.isChatPlayerOnNormalWorld(name) && (this.namesBronzeman.contains(name) || this.namesBronzeman.contains(name.replace('\u00a0', ' ')));
    }

    private boolean isChatPlayerOnNormalWorld(String name) {
        ChatPlayer player = this.getChatPlayerFromName(name);
        if (player == null) {
            return true;
        }
        int world = player.getWorld();
        return !this.isSeasonalWorld(world);
    }

    private void setupUnlockHistory() {
        this.profileKey = this.configManager.getRSProfileKey();
        if (this.profileKey == null) {
            this.setupLegacyFile();
        } else {
            this.setupProfileFile();
        }
    }

    private void setupLegacyFile() {
        this.profileFolder = new File(RuneLite.RUNELITE_DIR, "profiles/" + this.client.getUsername());
        if (!this.profileFolder.exists()) {
            this.profileFolder.mkdirs();
        }
        this.profileFile = new File(this.profileFolder, "another-bronzeman-mode-unlocks.txt");
        if (!this.profileFile.exists()) {
            try {
                this.profileFile.createNewFile();
                this.unlockDefaultItems();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void setupProfileFile() {
        this.legacyFolder = new File(RuneLite.RUNELITE_DIR, "profiles/" + this.client.getUsername());
        this.legacyFile = new File(this.legacyFolder, "another-bronzeman-mode-unlocks.txt");
        this.profileFolder = new File(RuneLite.RUNELITE_DIR, "profiles/" + this.profileKey);
        if (!this.profileFolder.exists()) {
            this.profileFolder.mkdirs();
        }
        this.profileFile = new File(this.profileFolder, "another-bronzeman-mode-unlocks.txt");
        if (!this.profileFile.exists()) {
            if (this.legacyFile.exists()) {
                try {
                    Files.copy(this.legacyFile.toPath(), this.profileFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return;
                }
            }
            try {
                this.profileFile.createNewFile();
                this.unlockDefaultItems();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void OnUnlocksCountCommand(ChatMessage chatMessage, String message) {
        if (!this.sentByPlayer(chatMessage)) {
            return;
        }
        ChatMessageBuilder builder = new ChatMessageBuilder().append(ChatColorType.HIGHLIGHT).append("You have unlocked ").append(ChatColorType.NORMAL).append(Integer.toString(this.unlockedItems.size())).append(ChatColorType.HIGHLIGHT).append(" items.");
        String response = builder.build();
        MessageNode messageNode = chatMessage.getMessageNode();
        messageNode.setRuneLiteFormatMessage(response);
        this.client.refreshChat();
    }

    private void OnUnlocksResetCommand(ChatMessage chatMessage, String message) {
        if (!this.sentByPlayer(chatMessage)) {
            return;
        }
        this.resetItemUnlocks();
        this.sendChatMessage("Unlocks successfully reset!");
    }

    private void resetItemUnlocks() {
        try {
            this.profileFile.delete();
            this.unlockedItems.clear();
            this.savePlayerUnlocks();
            this.unlockDefaultItems();
            this.unlockItemContainerItems(this.client.getItemContainer(InventoryID.INVENTORY));
            this.unlockItemContainerItems(this.client.getItemContainer(InventoryID.EQUIPMENT));
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
    }

    private void OnUnlocksBackupCommand(ChatMessage chatMessage, String message) {
        if (!this.sentByPlayer(chatMessage)) {
            return;
        }
        this.backupItemUnlocks();
        this.sendChatMessage("Successfully backed up file!");
    }

    private void backupItemUnlocks() {
        Path originalPath = this.profileFile.toPath();
        try {
            Calendar cal = Calendar.getInstance();
            SimpleDateFormat sdf = new SimpleDateFormat("MM_WW_HH_mm_ss");
            Files.copy(originalPath, Paths.get(this.profileFolder.getPath() + "_" + sdf.format(cal.getTime()) + ".backup", new String[0]), StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
    }

    private void loadResources() {
        IndexedSprite[] modIcons = this.client.getModIcons();
        if (this.bronzemanIconOffset != -1 || modIcons == null) {
            return;
        }
        this.unlockImage = ImageUtil.getResourceStreamFromClass(((Object)((Object)this)).getClass(), (String)"/item-unlocked.png");
        BufferedImage image = ImageUtil.getResourceStreamFromClass(((Object)((Object)this)).getClass(), (String)"/bronzeman_icon.png");
        IndexedSprite indexedSprite = ImageUtil.getImageIndexedSprite((BufferedImage)image, (Client)this.client);
        this.bronzemanIconOffset = modIcons.length;
        IndexedSprite[] newModIcons = Arrays.copyOf(modIcons, modIcons.length + 1);
        newModIcons[newModIcons.length - 1] = indexedSprite;
        this.client.setModIcons(newModIcons);
    }

    public BufferedImage getUnlockImage() {
        return this.unlockImage;
    }
}

