/*
 * Decompiled with CFR 0.152.
 */
package codepanter.anotherbronzemanmode;

import codepanter.anotherbronzemanmode.AnotherBronzemanModePlugin;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Consumer;
import javax.inject.Inject;
import javax.swing.SwingUtilities;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.ItemComposition;
import net.runelite.api.Point;
import net.runelite.client.game.ItemManager;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.ui.ClientUI;
import net.runelite.client.ui.DrawManager;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.util.ImageCapture;
import net.runelite.client.util.ImageUploadStyle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnotherBronzemanModeOverlay
extends Overlay {
    private static final Logger log = LoggerFactory.getLogger(AnotherBronzemanModeOverlay.class);
    private final Client client;
    private final AnotherBronzemanModePlugin plugin;
    private Integer currentUnlock;
    private long displayTime;
    private int displayY;
    private final List<Integer> itemUnlockList;
    private boolean screenshotUnlock;
    private boolean includeFrame;
    @Inject
    private ItemManager itemManager;
    @Inject
    private ImageCapture imageCapture;
    @Inject
    private ClientUI clientUi;
    @Inject
    private ScheduledExecutorService executor;
    @Inject
    private DrawManager drawManager;

    @Inject
    public AnotherBronzemanModeOverlay(Client client, AnotherBronzemanModePlugin plugin) {
        super((Plugin)plugin);
        this.client = client;
        this.plugin = plugin;
        this.itemUnlockList = new ArrayList<Integer>();
        this.screenshotUnlock = false;
        this.includeFrame = false;
        this.setPosition(OverlayPosition.TOP_CENTER);
    }

    public void addItemUnlock(int itemId) {
        this.itemUnlockList.add(itemId);
    }

    public void updateScreenshotUnlock(boolean doScreenshotUnlock, boolean doIncludeFrame) {
        this.screenshotUnlock = doScreenshotUnlock;
        this.includeFrame = doIncludeFrame;
    }

    public Dimension render(Graphics2D graphics) {
        if (this.client.getGameState() != GameState.LOGGED_IN || this.itemUnlockList.isEmpty()) {
            return null;
        }
        if (this.itemManager == null) {
            System.out.println("Item-manager is null");
            return null;
        }
        if (this.currentUnlock == null) {
            this.currentUnlock = this.itemUnlockList.get(0);
            this.displayTime = System.currentTimeMillis();
            this.displayY = -20;
            return null;
        }
        graphics.drawImage((Image)this.plugin.getUnlockImage(), -62, this.displayY, null);
        graphics.drawImage((Image)this.itemManager.getImage(this.currentUnlock.intValue(), 1, false), -50, this.displayY + 7, null);
        if (this.displayY < 10) {
            ++this.displayY;
        }
        if (System.currentTimeMillis() > this.displayTime + 5000L) {
            if (this.screenshotUnlock) {
                int itemID = this.currentUnlock;
                ItemComposition itemComposition = this.itemManager.getItemComposition(itemID);
                String itemName = itemComposition.getName();
                String fileName = "ItemUnlocked " + itemName + " ";
                this.takeScreenshot(fileName);
            }
            this.itemUnlockList.remove(this.currentUnlock);
            this.currentUnlock = null;
        }
        return null;
    }

    private void takeScreenshot(String fileName) {
        Consumer<Image> imageCallback = img -> this.executor.submit(() -> this.takeScreenshot(fileName, (Image)img));
        this.drawManager.requestNextFrameListener(imageCallback);
    }

    private void takeScreenshot(String fileName, Image image) {
        BufferedImage screenshot = this.includeFrame ? new BufferedImage(this.clientUi.getWidth(), this.clientUi.getHeight(), 2) : new BufferedImage(image.getWidth(null), image.getHeight(null), 2);
        Graphics graphics = screenshot.getGraphics();
        int gameOffsetX = 0;
        int gameOffsetY = 0;
        if (this.includeFrame) {
            try {
                SwingUtilities.invokeAndWait(() -> this.clientUi.paint(graphics));
            }
            catch (InterruptedException | InvocationTargetException e) {
                log.warn("unable to paint client UI on screenshot", (Throwable)e);
            }
            Point canvasOffset = this.clientUi.getCanvasOffset();
            gameOffsetX = canvasOffset.getX();
            gameOffsetY = canvasOffset.getY();
        }
        graphics.drawImage(image, gameOffsetX, gameOffsetY, null);
        this.imageCapture.takeScreenshot(screenshot, fileName, "Item Unlocks", false, ImageUploadStyle.NEITHER);
    }
}

