/*
 * Decompiled with CFR 0.152.
 */
package io.hydrox.subtlevirtuallevels;

import com.google.common.collect.Sets;
import com.google.inject.Provides;
import io.hydrox.subtlevirtuallevels.SubtleVirtualLevelsConfig;
import java.awt.FontMetrics;
import java.awt.Toolkit;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.Experience;
import net.runelite.api.GameState;
import net.runelite.api.Skill;
import net.runelite.api.events.ScriptPostFired;
import net.runelite.api.events.ScriptPreFired;
import net.runelite.api.widgets.Widget;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.FontManager;

@PluginDescriptor(name="Subtle Virtual Levels", description="View your virtual levels in a more subtle way that doesn't mess with your stats.", tags={"skill", "126", "max", "200m", "99"})
public class SubtleVirtualLevelsPlugin
extends Plugin {
    private static final FontMetrics FONT_METRICS = Toolkit.getDefaultToolkit().getFontMetrics(FontManager.getRunescapeSmallFont());
    private static final int SCRIPTID_STATS_INIT = 393;
    private static final int BACKGROUND_CAP_WIDTH = 4;
    private static final int BACKGROUND_HEIGHT = 12;
    private static final int BACKGROUND_PADDING = 1;
    private static final int TEXT_OFFSET_X = 12;
    private static final int TEXT_OFFSET_Y = 2;
    private static final int SPRITE_BACKGROUND_CAP_LEFT = 1123;
    private static final int SPRITE_BACKGROUND_TILE = 1124;
    private static final int SPRITE_BACKGROUND_CAP_RIGHT = 1125;
    private static final int ICON_POSITION = 4;
    private static final int ICON_SIZE = 25;
    private static final Skill[] SKILLS = new Skill[]{Skill.ATTACK, Skill.STRENGTH, Skill.DEFENCE, Skill.RANGED, Skill.PRAYER, Skill.MAGIC, Skill.RUNECRAFT, Skill.CONSTRUCTION, Skill.HITPOINTS, Skill.AGILITY, Skill.HERBLORE, Skill.THIEVING, Skill.CRAFTING, Skill.FLETCHING, Skill.SLAYER, Skill.HUNTER, Skill.MINING, Skill.SMITHING, Skill.FISHING, Skill.COOKING, Skill.FIREMAKING, Skill.WOODCUTTING, Skill.FARMING};
    @Inject
    private Client client;
    @Inject
    private ClientThread clientThread;
    @Inject
    private SubtleVirtualLevelsConfig config;
    private final Map<Skill, Set<Widget>> trackedWidgets = new HashMap<Skill, Set<Widget>>();
    private Widget currentWidget;

    @Provides
    SubtleVirtualLevelsConfig provideConfig(ConfigManager configManager) {
        return (SubtleVirtualLevelsConfig)configManager.getConfig(SubtleVirtualLevelsConfig.class);
    }

    public void startUp() {
        if (this.client.getGameState() == GameState.LOGGED_IN) {
            this.clientThread.invoke(this::createWidgets);
        }
    }

    public void shutDown() {
        this.clientThread.invoke(this::removeWidgets);
    }

    @Subscribe
    public void onScriptPreFired(ScriptPreFired event) {
        if (event.getScriptId() != 393) {
            return;
        }
        this.currentWidget = event.getScriptEvent().getSource();
    }

    @Subscribe
    public void onScriptPostFired(ScriptPostFired event) {
        if (event.getScriptId() != 393 || this.currentWidget == null) {
            return;
        }
        this.buildWidget(this.currentWidget);
    }

    private void createWidgets() {
        Widget skillsContainer = this.client.getWidget(WidgetInfo.SKILLS_CONTAINER);
        if (skillsContainer == null) {
            return;
        }
        for (int i = 0; i < SKILLS.length; ++i) {
            Widget current = skillsContainer.getStaticChildren()[i];
            if (current == null) continue;
            this.buildWidget(current);
        }
    }

    private void removeWidgets() {
        Widget skillsContainer = this.client.getWidget(WidgetInfo.SKILLS_CONTAINER);
        if (skillsContainer == null) {
            return;
        }
        for (int i = 0; i < SKILLS.length; ++i) {
            Widget current = skillsContainer.getStaticChildren()[i];
            Skill skill = SKILLS[i];
            Set tracked = this.trackedWidgets.getOrDefault(skill, null);
            if (current == null || tracked == null) continue;
            Widget[] children = current.getChildren();
            for (int j = 0; j < children.length; ++j) {
                Widget child = children[j];
                if (child == null || !tracked.contains(child)) continue;
                children[j] = null;
            }
        }
        this.trackedWidgets.clear();
    }

    private void buildWidget(Widget parent) {
        Skill skill = SKILLS[WidgetInfo.TO_CHILD((int)parent.getId()) - 1];
        int bgY = 18;
        Widget bgCapLeft = parent.createChild(-1, 5);
        bgCapLeft.setSpriteId(1123);
        bgCapLeft.setOriginalWidth(4);
        bgCapLeft.setOriginalHeight(12);
        bgCapLeft.setOriginalY(bgY);
        Widget bgCapRight = parent.createChild(-1, 5);
        bgCapRight.setSpriteId(1125);
        bgCapRight.setOriginalWidth(4);
        bgCapRight.setOriginalHeight(12);
        bgCapRight.setOriginalX(38);
        bgCapRight.setOriginalY(bgY);
        Widget bgTile = parent.createChild(-1, 5);
        bgTile.setSpriteId(1124);
        bgTile.setSpriteTiling(true);
        bgTile.setOriginalHeight(12);
        bgTile.setOriginalY(bgY);
        Widget virtualLevel = parent.createChild(-1, 4);
        virtualLevel.setFontId(494);
        virtualLevel.setTextShadowed(true);
        virtualLevel.setOriginalX(4);
        virtualLevel.setOriginalY(4);
        virtualLevel.setOriginalWidth(37);
        virtualLevel.setOriginalHeight(27);
        virtualLevel.setXTextAlignment(2);
        virtualLevel.setYTextAlignment(2);
        virtualLevel.setOnVarTransmitListener(new Object[]{ev -> this.updateVirtualLevel(skill, virtualLevel, bgCapLeft, bgCapRight, bgTile)});
        virtualLevel.setHasListener(true);
        this.updateVirtualLevel(skill, virtualLevel, bgCapLeft, bgCapRight, bgTile);
        bgCapLeft.revalidate();
        bgCapRight.revalidate();
        bgTile.revalidate();
        virtualLevel.revalidate();
        parent.revalidate();
        this.trackedWidgets.put(skill, Sets.newHashSet((Object[])new Widget[]{bgCapLeft, bgCapRight, bgTile, virtualLevel}));
    }

    private String getVirtualLevelText(Skill skill) {
        int xp = this.client.getSkillExperience(skill);
        if (xp == 200000000) {
            return "Max";
        }
        int level = Experience.getLevelForXp((int)xp);
        return level < this.getLowestVisibleLevel() ? "" : Integer.toString(level);
    }

    private int getLowestVisibleLevel() {
        return this.config.showFor99() ? 99 : 100;
    }

    private void updateVirtualLevel(Skill skill, Widget text, Widget bgCapLeft, Widget bgCapRight, Widget bgTile) {
        String virtualLevel = this.getVirtualLevelText(skill);
        text.setText(virtualLevel);
        text.setTextColor(this.config.textColour().getRGB());
        int stringWidth = FONT_METRICS.stringWidth(virtualLevel);
        bgCapLeft.setOriginalX(text.getOriginalX() + text.getWidth() + 1 - stringWidth - 2);
        bgTile.setOriginalX(text.getOriginalX() + text.getWidth() + 1 - stringWidth + 2);
        bgTile.setOriginalWidth(stringWidth - 4);
        bgCapLeft.setHidden(virtualLevel.isEmpty());
        bgCapRight.setHidden(virtualLevel.isEmpty());
        bgTile.setHidden(virtualLevel.isEmpty());
        text.revalidate();
        bgCapLeft.revalidate();
        bgCapRight.revalidate();
        bgTile.revalidate();
    }
}

