/*
 * Decompiled with CFR 0.152.
 */
package spudjb.bankvalue;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import net.runelite.client.ui.FontManager;
import net.runelite.client.util.QuantityFormatter;
import spudjb.bankvalue.CachedItem;

class BankValueTableRow
extends JPanel {
    static final int ITEM_NAME_COLUMN_WIDTH = 60;
    static final int ITEM_COUNT_COLUMN_WIDTH = 45;
    static final int ITEM_VALUE_COLUMN_WIDTH = 45;
    private static final Color CURRENT_WORLD = new Color(66, 227, 17);
    private static final Color UNAVAILABLE_WORLD = Color.GRAY.darker().darker();
    private static final Color DANGEROUS_WORLD = new Color(251, 62, 62);
    private static final Color TOURNAMENT_WORLD = new Color(79, 145, 255);
    private static final Color MEMBERS_WORLD = new Color(210, 193, 53);
    private static final Color FREE_WORLD = new Color(200, 200, 200);
    private JLabel itemName;
    private JLabel itemCount;
    private JLabel value;
    private final CachedItem item;
    private Color lastBackground;

    BankValueTableRow(CachedItem item) {
        this.item = item;
        this.setLayout(new BorderLayout());
        this.setBorder(new EmptyBorder(2, 0, 2, 0));
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    // empty if block
                }
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    BankValueTableRow.this.setBackground(BankValueTableRow.this.getBackground().brighter());
                }
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    BankValueTableRow.this.setBackground(BankValueTableRow.this.getBackground().darker());
                }
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                BankValueTableRow.this.lastBackground = BankValueTableRow.this.getBackground();
                BankValueTableRow.this.setBackground(BankValueTableRow.this.getBackground().brighter());
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                BankValueTableRow.this.setBackground(BankValueTableRow.this.lastBackground);
            }
        });
        JPanel leftSide = new JPanel(new BorderLayout());
        JPanel rightSide = new JPanel(new BorderLayout());
        leftSide.setOpaque(false);
        rightSide.setOpaque(false);
        JPanel itemNameField = this.buildItemNameField();
        itemNameField.setOpaque(false);
        JPanel itemCountField = this.buildItemCountField();
        itemCountField.setPreferredSize(new Dimension(45, 0));
        itemCountField.setOpaque(false);
        JPanel valueField = this.buildValueField();
        valueField.setPreferredSize(new Dimension(45, 0));
        valueField.setOpaque(false);
        this.recolour();
        leftSide.add((Component)itemNameField, "Center");
        leftSide.add((Component)itemCountField, "East");
        rightSide.add((Component)valueField, "Center");
        this.add((Component)leftSide, "Center");
        this.add((Component)rightSide, "East");
    }

    public void recolour() {
    }

    private JPanel buildItemCountField() {
        JPanel column = new JPanel(new BorderLayout());
        column.setBorder(new EmptyBorder(0, 5, 0, 5));
        this.itemCount = new JLabel(QuantityFormatter.quantityToStackSize((long)this.getItemCount()));
        this.itemCount.setFont(FontManager.getRunescapeSmallFont());
        column.add((Component)this.itemCount, "West");
        return column;
    }

    int getItemCount() {
        return this.item.getQuantity();
    }

    private JPanel buildValueField() {
        JPanel column = new JPanel(new BorderLayout());
        column.setBorder(new EmptyBorder(0, 5, 0, 5));
        this.value = new JLabel(QuantityFormatter.quantityToStackSize((long)this.getPrice()));
        this.value.setFont(FontManager.getRunescapeSmallFont());
        column.add((Component)this.value, "East");
        return column;
    }

    int getPrice() {
        return this.item.getValue() * this.item.getQuantity();
    }

    private JPanel buildItemNameField() {
        JPanel column = new JPanel(new BorderLayout());
        column.setBorder(new EmptyBorder(0, 5, 0, 5));
        this.itemName = new JLabel(this.getItemName());
        this.itemName.setFont(FontManager.getRunescapeSmallFont());
        column.add((Component)this.itemName, "West");
        return column;
    }

    String getItemName() {
        return this.item.getName();
    }

    public CachedItem getItem() {
        return this.item;
    }
}

