/*
 * Decompiled with CFR 0.152.
 */
package spudjb.bankvalue;

import java.awt.image.BufferedImage;
import java.util.ArrayList;
import javax.inject.Inject;
import javax.swing.SwingUtilities;
import net.runelite.api.Client;
import net.runelite.api.InventoryID;
import net.runelite.api.Item;
import net.runelite.api.ItemComposition;
import net.runelite.api.events.ItemContainerChanged;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.game.ItemManager;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.ClientToolbar;
import net.runelite.client.ui.NavigationButton;
import net.runelite.client.ui.PluginPanel;
import net.runelite.client.util.ImageUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import spudjb.bankvalue.BankValuePanel;
import spudjb.bankvalue.CachedItem;

@PluginDescriptor(name="Bank Value", description="Shows the value of your bank in the sidebar")
public class BankValuePlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(BankValuePlugin.class);
    @Inject
    Client client;
    @Inject
    ClientToolbar clientToolbar;
    @Inject
    ItemManager itemManager;
    private BankValuePanel panel;
    private NavigationButton navButton;

    protected void startUp() throws Exception {
        this.panel = new BankValuePanel(this);
        BufferedImage icon = ImageUtil.getResourceStreamFromClass(BankValuePlugin.class, (String)"panel_icon.png");
        this.navButton = NavigationButton.builder().tooltip("Bank Value").priority(5).panel((PluginPanel)this.panel).icon(icon).build();
        this.clientToolbar.addNavigation(this.navButton);
    }

    protected void shutDown() throws Exception {
        this.clientToolbar.removeNavigation(this.navButton);
    }

    @Subscribe
    public void onItemContainerChanged(ItemContainerChanged event) {
        if (event.getContainerId() != InventoryID.BANK.getId()) {
            return;
        }
        ArrayList<CachedItem> cachedItems = new ArrayList<CachedItem>(event.getItemContainer().getItems().length);
        for (Item item : event.getItemContainer().getItems()) {
            if (this.itemManager.canonicalize(item.getId()) != item.getId() || item.getId() == -1) continue;
            int itemPrice = this.itemManager.getItemPrice(item.getId());
            ItemComposition itemDefinition = this.client.getItemDefinition(item.getId());
            cachedItems.add(new CachedItem(item.getId(), item.getQuantity(), itemDefinition.getName(), itemPrice));
        }
        SwingUtilities.invokeLater(() -> this.panel.populate(cachedItems));
    }
}

