/*
 * Decompiled with CFR 0.152.
 */
package spudjb.bankvalue;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.ui.DynamicGridLayout;
import net.runelite.client.ui.PluginPanel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import spudjb.bankvalue.BankValuePlugin;
import spudjb.bankvalue.BankValueTableHeader;
import spudjb.bankvalue.BankValueTableRow;
import spudjb.bankvalue.CachedItem;

class BankValuePanel
extends PluginPanel {
    private static final Logger log = LoggerFactory.getLogger(BankValuePanel.class);
    private static final Color ODD_ROW = new Color(44, 44, 44);
    private final JPanel listContainer = new JPanel();
    private BankValueTableHeader countHeader;
    private BankValueTableHeader valueHeader;
    private BankValueTableHeader nameHeader;
    private SortOrder orderIndex = SortOrder.VALUE;
    private boolean ascendingOrder = false;
    private ArrayList<BankValueTableRow> rows = new ArrayList();
    private BankValuePlugin plugin;

    BankValuePanel(BankValuePlugin plugin) {
        this.plugin = plugin;
        this.setBorder(null);
        this.setLayout((LayoutManager)new DynamicGridLayout(0, 1));
        JPanel headerContainer = this.buildHeader();
        this.listContainer.setLayout(new GridLayout(0, 1));
        this.add(headerContainer);
        this.add(this.listContainer);
    }

    void updateList() {
        this.rows.sort((r1, r2) -> {
            switch (this.orderIndex) {
                case NAME: {
                    return r1.getItemName().compareTo(r2.getItemName()) * (this.ascendingOrder ? 1 : -1);
                }
                case COUNT: {
                    return Integer.compare(r1.getItemCount(), r2.getItemCount()) * (this.ascendingOrder ? 1 : -1);
                }
                case VALUE: {
                    return Integer.compare(r1.getPrice(), r2.getPrice()) * (this.ascendingOrder ? 1 : -1);
                }
            }
            return 0;
        });
        this.listContainer.removeAll();
        for (int i = 0; i < this.rows.size(); ++i) {
            BankValueTableRow row = this.rows.get(i);
            row.setBackground(i % 2 == 0 ? ODD_ROW : ColorScheme.DARK_GRAY_COLOR);
            this.listContainer.add(row);
        }
        this.listContainer.revalidate();
        this.listContainer.repaint();
    }

    void populate(List<CachedItem> items) {
        this.rows.clear();
        for (int i = 0; i < items.size(); ++i) {
            CachedItem item = items.get(i);
            this.rows.add(this.buildRow(item, i % 2 == 0));
        }
        this.updateList();
    }

    private void orderBy(SortOrder order) {
        this.nameHeader.highlight(false, this.ascendingOrder);
        this.countHeader.highlight(false, this.ascendingOrder);
        this.valueHeader.highlight(false, this.ascendingOrder);
        switch (order) {
            case NAME: {
                this.nameHeader.highlight(true, this.ascendingOrder);
                break;
            }
            case COUNT: {
                this.countHeader.highlight(true, this.ascendingOrder);
                break;
            }
            case VALUE: {
                this.valueHeader.highlight(true, this.ascendingOrder);
            }
        }
        this.orderIndex = order;
        this.updateList();
    }

    private JPanel buildHeader() {
        JPanel header = new JPanel(new BorderLayout());
        JPanel leftSide = new JPanel(new BorderLayout());
        JPanel rightSide = new JPanel(new BorderLayout());
        this.nameHeader = new BankValueTableHeader("Name", this.orderIndex == SortOrder.NAME, this.ascendingOrder);
        this.nameHeader.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (SwingUtilities.isRightMouseButton(mouseEvent)) {
                    return;
                }
                BankValuePanel.this.ascendingOrder = BankValuePanel.this.orderIndex != SortOrder.NAME || !BankValuePanel.this.ascendingOrder;
                BankValuePanel.this.orderBy(SortOrder.NAME);
            }
        });
        this.countHeader = new BankValueTableHeader("#", this.orderIndex == SortOrder.COUNT, this.ascendingOrder);
        this.countHeader.setPreferredSize(new Dimension(45, 0));
        this.countHeader.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (SwingUtilities.isRightMouseButton(mouseEvent)) {
                    return;
                }
                BankValuePanel.this.ascendingOrder = BankValuePanel.this.orderIndex != SortOrder.COUNT || !BankValuePanel.this.ascendingOrder;
                BankValuePanel.this.orderBy(SortOrder.COUNT);
            }
        });
        this.valueHeader = new BankValueTableHeader("$", this.orderIndex == SortOrder.VALUE, this.ascendingOrder);
        this.valueHeader.setPreferredSize(new Dimension(45, 0));
        this.valueHeader.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (SwingUtilities.isRightMouseButton(mouseEvent)) {
                    return;
                }
                BankValuePanel.this.ascendingOrder = BankValuePanel.this.orderIndex != SortOrder.VALUE || !BankValuePanel.this.ascendingOrder;
                BankValuePanel.this.orderBy(SortOrder.VALUE);
            }
        });
        leftSide.add((Component)this.nameHeader, "Center");
        leftSide.add((Component)this.countHeader, "East");
        rightSide.add((Component)this.valueHeader, "Center");
        header.add((Component)leftSide, "Center");
        header.add((Component)rightSide, "East");
        return header;
    }

    private BankValueTableRow buildRow(CachedItem item, boolean stripe) {
        BankValueTableRow row = new BankValueTableRow(item);
        row.setBackground(stripe ? ODD_ROW : ColorScheme.DARK_GRAY_COLOR);
        return row;
    }

    private static enum SortOrder {
        COUNT,
        VALUE,
        NAME;

    }
}

