/*
 * Decompiled with CFR 0.152.
 */
package trevor.tobhealthbars;

import com.google.common.collect.ImmutableSet;
import com.google.inject.Provides;
import java.util.Set;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.events.ScriptPostFired;
import net.runelite.api.events.VarbitChanged;
import net.runelite.api.widgets.Widget;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import trevor.tobhealthbars.TobHealthBarsConfig;
import trevor.tobhealthbars.TobHealthBarsOverlay;

@PluginDescriptor(name="Tob Health Bars")
public class TobHealthBarsPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(TobHealthBarsPlugin.class);
    private static final Set<Integer> TOB_SCRIPTS = ImmutableSet.of((Object)2509, (Object)2296);
    @Inject
    private Client client;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private TobHealthBarsOverlay overlay;
    @Inject
    private ClientThread clientThread;
    private TobPlayer[] players = new TobPlayer[]{new TobPlayer(6442, 330), new TobPlayer(6443, 331), new TobPlayer(6444, 332), new TobPlayer(6445, 333), new TobPlayer(6446, 334)};
    private boolean inTob;

    protected void startUp() throws Exception {
        this.overlayManager.add((Overlay)this.overlay);
        this.clientThread.invoke(() -> this.setHidden(true));
    }

    protected void shutDown() throws Exception {
        this.overlayManager.remove((Overlay)this.overlay);
        this.clientThread.invoke(() -> this.setHidden(false));
    }

    @Subscribe
    public void onVarbitChanged(VarbitChanged event) {
        this.inTob = this.client.getVar(6440) > 1;
    }

    @Subscribe
    public void onScriptPostFired(ScriptPostFired event) {
        if (!TOB_SCRIPTS.contains(event.getScriptId()) || !this.inTob) {
            return;
        }
        Widget widget = this.client.getWidget(WidgetInfo.TOB_PARTY_STATS);
        if (widget == null || widget.isHidden()) {
            return;
        }
        widget.setHidden(true);
    }

    private void setHidden(boolean shouldHide) {
        if (this.client.getGameState() != GameState.LOGGED_IN) {
            return;
        }
        boolean bl = this.inTob = this.client.getVar(6440) > 1;
        if (!this.inTob) {
            return;
        }
        Widget widget = this.client.getWidget(WidgetInfo.TOB_PARTY_STATS);
        if (widget != null) {
            widget.setHidden(shouldHide);
        }
    }

    @Provides
    TobHealthBarsConfig provideConfig(ConfigManager configManager) {
        return (TobHealthBarsConfig)configManager.getConfig(TobHealthBarsConfig.class);
    }

    public TobPlayer[] getPlayers() {
        return this.players;
    }

    public boolean isInTob() {
        return this.inTob;
    }

    class TobPlayer {
        private final int healthVarb;
        private final int nameVarc;

        public TobPlayer(int healthVarb, int nameVarc) {
            this.healthVarb = healthVarb;
            this.nameVarc = nameVarc;
        }

        public int getHealthVarb() {
            return this.healthVarb;
        }

        public int getNameVarc() {
            return this.nameVarc;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TobPlayer)) {
                return false;
            }
            TobPlayer other = (TobPlayer)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getHealthVarb() != other.getHealthVarb()) {
                return false;
            }
            return this.getNameVarc() == other.getNameVarc();
        }

        protected boolean canEqual(Object other) {
            return other instanceof TobPlayer;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getHealthVarb();
            result = result * 59 + this.getNameVarc();
            return result;
        }

        public String toString() {
            return "TobHealthBarsPlugin.TobPlayer(healthVarb=" + this.getHealthVarb() + ", nameVarc=" + this.getNameVarc() + ")";
        }
    }
}

