/*
 * Decompiled with CFR 0.152.
 */
package trevor.tobhealthbars;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.OverlayPriority;
import net.runelite.client.ui.overlay.components.PanelComponent;
import net.runelite.client.ui.overlay.components.ProgressBarComponent;
import net.runelite.client.ui.overlay.components.TitleComponent;
import trevor.tobhealthbars.TobHealthBarsConfig;
import trevor.tobhealthbars.TobHealthBarsPlugin;

public class TobHealthBarsOverlay
extends Overlay {
    private static final int LOCAL_TOB_ORB_VARB = 6441;
    private static final Color HP_GREEN = new Color(0, 146, 54, 230);
    private static final Color HP_RED = new Color(102, 15, 16, 230);
    private Client client;
    private TobHealthBarsPlugin plugin;
    private TobHealthBarsConfig config;
    private final PanelComponent panel = new PanelComponent();

    @Inject
    private TobHealthBarsOverlay(Client client, TobHealthBarsPlugin plugin, TobHealthBarsConfig config) {
        this.client = client;
        this.plugin = plugin;
        this.config = config;
        this.setPosition(OverlayPosition.TOP_LEFT);
        this.setPriority(OverlayPriority.HIGH);
    }

    public Dimension render(Graphics2D graphics) {
        if (!this.plugin.isInTob()) {
            return null;
        }
        this.panel.getChildren().clear();
        int localPlayerIndex = this.client.getVarbitValue(6441) - 1;
        for (int i = 0; i < 5; ++i) {
            TobHealthBarsPlugin.TobPlayer player = this.plugin.getPlayers()[i];
            int healthVarb = this.client.getVarbitValue(player.getHealthVarb());
            String playerName = this.client.getVarcStrValue(player.getNameVarc());
            if (healthVarb == 0) break;
            if (healthVarb == 30) {
                healthVarb = 1;
            }
            if (localPlayerIndex == i && !this.config.showLocalName()) {
                playerName = "Me";
            }
            this.panel.getChildren().add(TitleComponent.builder().text(playerName).build());
            ProgressBarComponent progressBarComponent = new ProgressBarComponent();
            progressBarComponent.setBackgroundColor(HP_RED);
            progressBarComponent.setForegroundColor(HP_GREEN);
            float floatRatio = (float)(healthVarb - 1) / 26.0f;
            progressBarComponent.setValue((double)floatRatio * 100.0);
            this.panel.getChildren().add(progressBarComponent);
        }
        return this.panel.render(graphics);
    }
}

